/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererOptions;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.model.DynamicTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

public final class DynamicType
extends FlexibleType
implements DynamicTypeMarker {
    private final TypeAttributes attributes;

    public DynamicType(KotlinBuiltIns kotlinBuiltIns, TypeAttributes typeAttributes) {
        Intrinsics.checkNotNullParameter((Object)kotlinBuiltIns, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeAttributes, (String)"");
        SimpleType simpleType = kotlinBuiltIns.getNothingType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"");
        SimpleType simpleType2 = kotlinBuiltIns.getNullableAnyType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"");
        super(simpleType, simpleType2);
        this.attributes = typeAttributes;
    }

    @Override
    public TypeAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public SimpleType getDelegate() {
        return this.getUpperBound();
    }

    @Override
    public DynamicType makeNullableAsSpecified(boolean bl) {
        return this;
    }

    @Override
    public boolean isMarkedNullable() {
        return false;
    }

    @Override
    public DynamicType replaceAttributes(TypeAttributes typeAttributes) {
        Intrinsics.checkNotNullParameter((Object)typeAttributes, (String)"");
        return new DynamicType(TypeUtilsKt.getBuiltIns(this.getDelegate()), typeAttributes);
    }

    @Override
    public String render(DescriptorRenderer descriptorRenderer, DescriptorRendererOptions descriptorRendererOptions) {
        Intrinsics.checkNotNullParameter((Object)descriptorRenderer, (String)"");
        Intrinsics.checkNotNullParameter((Object)descriptorRendererOptions, (String)"");
        return "dynamic";
    }

    @Override
    public DynamicType refine(KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"");
        return this;
    }
}

