/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.TypeIntersectionScope;
import kotlin.reflect.jvm.internal.impl.types.IntersectionTypeConstructor$$Lambda$0;
import kotlin.reflect.jvm.internal.impl.types.IntersectionTypeConstructor$$Lambda$1;
import kotlin.reflect.jvm.internal.impl.types.IntersectionTypeConstructor$$Lambda$2;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.model.IntersectionTypeConstructorMarker;

public final class IntersectionTypeConstructor
implements TypeConstructor,
IntersectionTypeConstructorMarker {
    private KotlinType alternative;
    private final LinkedHashSet<KotlinType> intersectedTypes;
    private final int hashCode;

    public IntersectionTypeConstructor(Collection<? extends KotlinType> collection) {
        boolean bl;
        Intrinsics.checkNotNullParameter(collection, (String)"");
        boolean bl2 = bl = !collection.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Attempt to create an empty intersection";
            throw new AssertionError((Object)string);
        }
        this.intersectedTypes = new LinkedHashSet<KotlinType>(collection);
        this.hashCode = this.intersectedTypes.hashCode();
    }

    private IntersectionTypeConstructor(Collection<? extends KotlinType> collection, KotlinType kotlinType) {
        this(collection);
        this.alternative = kotlinType;
    }

    @Override
    public List<TypeParameterDescriptor> getParameters() {
        return CollectionsKt.emptyList();
    }

    @Override
    public Collection<KotlinType> getSupertypes() {
        return this.intersectedTypes;
    }

    public final MemberScope createScopeForKotlinType() {
        return TypeIntersectionScope.Companion.create("member scope for intersection type", (Collection<? extends KotlinType>)this.intersectedTypes);
    }

    @Override
    public boolean isDenotable() {
        return false;
    }

    @Override
    public ClassifierDescriptor getDeclarationDescriptor() {
        return null;
    }

    @Override
    public KotlinBuiltIns getBuiltIns() {
        KotlinBuiltIns kotlinBuiltIns = ((KotlinType)this.intersectedTypes.iterator().next()).getConstructor().getBuiltIns();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinBuiltIns, (String)"");
        return kotlinBuiltIns;
    }

    public String toString() {
        return IntersectionTypeConstructor.makeDebugNameForIntersectionType$default(this, null, 1, null);
    }

    public final String makeDebugNameForIntersectionType(Function1<? super KotlinType, ? extends Object> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"");
        Iterable iterable = this.intersectedTypes;
        boolean bl = false;
        Function1<? super KotlinType, ? extends Object> function12 = function1;
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)iterable, (Comparator)new Comparator(function1){
            final /* synthetic */ Function1 $getProperTypeRelatedToStringify$inlined;
            {
                this.$getProperTypeRelatedToStringify$inlined = function1;
            }

            public final int compare(T t, T t2) {
                KotlinType kotlinType = (KotlinType)t;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)kotlinType);
                Comparable comparable = (Comparable)((Object)this.$getProperTypeRelatedToStringify$inlined.invoke((Object)kotlinType).toString());
                kotlinType = (KotlinType)t2;
                Comparable comparable2 = comparable;
                bl = false;
                Intrinsics.checkNotNull((Object)kotlinType);
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)this.$getProperTypeRelatedToStringify$inlined.invoke((Object)kotlinType).toString())));
            }
        }), (CharSequence)" & ", (CharSequence)"{", (CharSequence)"}", (int)0, null, (Function1)new IntersectionTypeConstructor$$Lambda$0(function12), (int)24, null);
    }

    public static /* synthetic */ String makeDebugNameForIntersectionType$default(IntersectionTypeConstructor intersectionTypeConstructor, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = IntersectionTypeConstructor$$Lambda$1.INSTANCE;
        }
        return intersectionTypeConstructor.makeDebugNameForIntersectionType((Function1<? super KotlinType, ? extends Object>)function1);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IntersectionTypeConstructor)) {
            return false;
        }
        return Intrinsics.areEqual(this.intersectedTypes, ((IntersectionTypeConstructor)object).intersectedTypes);
    }

    public final SimpleType createType() {
        IntersectionTypeConstructor intersectionTypeConstructor = this;
        return KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(TypeAttributes.Companion.getEmpty(), this, CollectionsKt.emptyList(), false, this.createScopeForKotlinType(), new IntersectionTypeConstructor$$Lambda$2(intersectionTypeConstructor));
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public IntersectionTypeConstructor refine(KotlinTypeRefiner kotlinTypeRefiner) {
        IntersectionTypeConstructor intersectionTypeConstructor;
        IntersectionTypeConstructor intersectionTypeConstructor2;
        boolean bl;
        Object object;
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"");
        IntersectionTypeConstructor intersectionTypeConstructor3 = this;
        boolean bl2 = false;
        boolean bl3 = false;
        Iterable iterable = intersectionTypeConstructor3.getSupertypes();
        boolean bl4 = false;
        Iterable iterable2 = iterable;
        Object object2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl5 = false;
        for (Object t : iterable2) {
            KotlinType kotlinType;
            KotlinType kotlinType2 = (KotlinType)t;
            Collection collection = object2;
            boolean bl6 = false;
            object = kotlinType2;
            bl = false;
            if (true) {
                bl3 = true;
                object = kotlinType2;
                bl = false;
                kotlinType = ((KotlinType)object).refine(kotlinTypeRefiner);
            } else {
                kotlinType = kotlinType2;
            }
            collection.add(kotlinType);
        }
        List list = (List)object2;
        if (!bl3) {
            intersectionTypeConstructor2 = null;
        } else {
            Object object3;
            KotlinType kotlinType = intersectionTypeConstructor3.getAlternativeType();
            if (kotlinType != null) {
                object2 = kotlinType;
                bl5 = false;
                object = object2;
                bl = false;
                if (true) {
                    object = object2;
                    bl = false;
                    object3 = ((KotlinType)object).refine(kotlinTypeRefiner);
                } else {
                    object3 = object2;
                }
            } else {
                object3 = null;
            }
            iterable = object3;
            intersectionTypeConstructor2 = intersectionTypeConstructor = new IntersectionTypeConstructor(list).setAlternative((KotlinType)((Object)iterable));
        }
        if (intersectionTypeConstructor2 == null) {
            intersectionTypeConstructor = this;
        }
        return intersectionTypeConstructor;
    }

    public final IntersectionTypeConstructor setAlternative(KotlinType kotlinType) {
        return new IntersectionTypeConstructor((Collection<? extends KotlinType>)this.intersectedTypes, kotlinType);
    }

    public final KotlinType getAlternativeType() {
        return this.alternative;
    }

    private static final String makeDebugNameForIntersectionType$lambda$1(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        return kotlinType.toString();
    }

    private static final CharSequence makeDebugNameForIntersectionType$lambda$3(Function1 function1, KotlinType kotlinType) {
        Intrinsics.checkNotNull((Object)kotlinType);
        return function1.invoke((Object)kotlinType).toString();
    }

    private static final SimpleType createType$lambda$4(IntersectionTypeConstructor intersectionTypeConstructor, KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"");
        return intersectionTypeConstructor.refine(kotlinTypeRefiner).createType();
    }

    static /* synthetic */ CharSequence accessor$IntersectionTypeConstructor$lambda0(Function1 function1, KotlinType kotlinType) {
        return IntersectionTypeConstructor.makeDebugNameForIntersectionType$lambda$3(function1, kotlinType);
    }

    static /* synthetic */ String accessor$IntersectionTypeConstructor$lambda1(KotlinType kotlinType) {
        return IntersectionTypeConstructor.makeDebugNameForIntersectionType$lambda$1(kotlinType);
    }

    static /* synthetic */ SimpleType accessor$IntersectionTypeConstructor$lambda2(IntersectionTypeConstructor intersectionTypeConstructor, KotlinTypeRefiner kotlinTypeRefiner) {
        return IntersectionTypeConstructor.createType$lambda$4(intersectionTypeConstructor, kotlinTypeRefiner);
    }
}

