/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.List;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.NotNullSimpleType;
import kotlin.reflect.jvm.internal.impl.types.NullableSimpleType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SimpleTypeWithAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorScope;
import kotlin.reflect.jvm.internal.impl.types.error.ThrowingScope;

final class SimpleTypeImpl
extends SimpleType {
    private final TypeConstructor constructor;
    private final List<TypeProjection> arguments;
    private final boolean isMarkedNullable;
    private final MemberScope memberScope;
    private final Function1<KotlinTypeRefiner, SimpleType> refinedTypeFactory;

    public SimpleTypeImpl(TypeConstructor typeConstructor2, List<? extends TypeProjection> list, boolean bl, MemberScope memberScope, Function1<? super KotlinTypeRefiner, ? extends SimpleType> function1) {
        Intrinsics.checkNotNullParameter((Object)typeConstructor2, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter((Object)memberScope, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        this.constructor = typeConstructor2;
        this.arguments = list;
        this.isMarkedNullable = bl;
        this.memberScope = memberScope;
        this.refinedTypeFactory = function1;
        if (this.getMemberScope() instanceof ErrorScope && !(this.getMemberScope() instanceof ThrowingScope)) {
            throw new IllegalStateException("SimpleTypeImpl should not be created for error type: " + this.getMemberScope() + '\n' + this.getConstructor());
        }
    }

    @Override
    public TypeConstructor getConstructor() {
        return this.constructor;
    }

    @Override
    public List<TypeProjection> getArguments() {
        return this.arguments;
    }

    @Override
    public boolean isMarkedNullable() {
        return this.isMarkedNullable;
    }

    @Override
    public MemberScope getMemberScope() {
        return this.memberScope;
    }

    @Override
    public TypeAttributes getAttributes() {
        return TypeAttributes.Companion.getEmpty();
    }

    @Override
    public SimpleType replaceAttributes(TypeAttributes typeAttributes) {
        Intrinsics.checkNotNullParameter((Object)typeAttributes, (String)"");
        return typeAttributes.isEmpty() ? (SimpleType)this : (SimpleType)new SimpleTypeWithAttributes(this, typeAttributes);
    }

    @Override
    public SimpleType makeNullableAsSpecified(boolean bl) {
        return bl == this.isMarkedNullable() ? (SimpleType)this : (bl ? (SimpleType)new NullableSimpleType(this) : (SimpleType)new NotNullSimpleType(this));
    }

    @Override
    public SimpleType refine(KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"");
        SimpleType simpleType = (SimpleType)this.refinedTypeFactory.invoke((Object)kotlinTypeRefiner);
        if (simpleType == null) {
            simpleType = this;
        }
        return simpleType;
    }
}

