/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.checker;

import java.util.Collection;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.AbstractTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.model.KotlinTypeMarker;

public abstract class KotlinTypeRefiner
extends AbstractTypeRefiner {
    @Override
    public abstract KotlinType refineType(KotlinTypeMarker var1);

    public abstract Collection<KotlinType> refineSupertypes(ClassDescriptor var1);

    public abstract ClassifierDescriptor refineDescriptor(DeclarationDescriptor var1);

    public abstract ClassDescriptor findClassAcrossModuleDependencies(ClassId var1);

    public abstract boolean isRefinementNeededForModule(ModuleDescriptor var1);

    public abstract boolean isRefinementNeededForTypeConstructor(TypeConstructor var1);

    public abstract <S extends MemberScope> S getOrPutScopeForClass(ClassDescriptor var1, Function0<? extends S> var2);

    public static final class Default
    extends KotlinTypeRefiner {
        public static final Default INSTANCE = new Default();

        private Default() {
        }

        @Override
        public KotlinType refineType(KotlinTypeMarker kotlinTypeMarker) {
            Intrinsics.checkNotNullParameter((Object)kotlinTypeMarker, (String)"");
            return (KotlinType)kotlinTypeMarker;
        }

        @Override
        public Collection<KotlinType> refineSupertypes(ClassDescriptor classDescriptor) {
            Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"");
            Collection<KotlinType> collection = classDescriptor.getTypeConstructor().getSupertypes();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"");
            return collection;
        }

        @Override
        public ClassDescriptor refineDescriptor(DeclarationDescriptor declarationDescriptor) {
            Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
            return null;
        }

        @Override
        public ClassDescriptor findClassAcrossModuleDependencies(ClassId classId) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"");
            return null;
        }

        @Override
        public boolean isRefinementNeededForModule(ModuleDescriptor moduleDescriptor) {
            Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"");
            return false;
        }

        @Override
        public boolean isRefinementNeededForTypeConstructor(TypeConstructor typeConstructor2) {
            Intrinsics.checkNotNullParameter((Object)typeConstructor2, (String)"");
            return false;
        }

        @Override
        public <S extends MemberScope> S getOrPutScopeForClass(ClassDescriptor classDescriptor, Function0<? extends S> function0) {
            Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"");
            Intrinsics.checkNotNullParameter(function0, (String)"");
            return (S)((MemberScope)function0.invoke());
        }
    }
}

