/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import java.util.Arrays;
import java.util.Collection;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.util.Check;
import kotlin.reflect.jvm.internal.impl.util.CheckResult;
import kotlin.text.Regex;

public final class Checks {
    private final Name name;
    private final Regex regex;
    private final Collection<Name> nameList;
    private final Function1<FunctionDescriptor, String> additionalCheck;
    private final Check[] checks;

    private Checks(Name name, Regex regex, Collection<Name> collection, Function1<? super FunctionDescriptor, String> function1, Check ... checkArray) {
        this.name = name;
        this.regex = regex;
        this.nameList = collection;
        this.additionalCheck = function1;
        this.checks = checkArray;
    }

    public final boolean isApplicable(FunctionDescriptor functionDescriptor) {
        Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"");
        if (this.name != null && !Intrinsics.areEqual((Object)functionDescriptor.getName(), (Object)this.name)) {
            return false;
        }
        if (this.regex != null) {
            String string = functionDescriptor.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            CharSequence charSequence = string;
            if (!this.regex.matches(charSequence)) {
                return false;
            }
        }
        return this.nameList == null || this.nameList.contains(functionDescriptor.getName());
    }

    public final CheckResult checkAll(FunctionDescriptor functionDescriptor) {
        Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"");
        for (Check check : this.checks) {
            String string = check.invoke(functionDescriptor);
            if (string == null) continue;
            return new CheckResult.IllegalSignature(string);
        }
        String string = (String)this.additionalCheck.invoke((Object)functionDescriptor);
        if (string != null) {
            return new CheckResult.IllegalSignature(string);
        }
        return CheckResult.SuccessCheck.INSTANCE;
    }

    public Checks(Name name, Check[] checkArray, Function1<? super FunctionDescriptor, String> function1) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Intrinsics.checkNotNullParameter((Object)checkArray, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        this(name, null, null, function1, Arrays.copyOf(checkArray, checkArray.length));
    }

    public /* synthetic */ Checks(Name name, Check[] checkArray, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = 2.INSTANCE;
        }
        this(name, checkArray, (Function1<? super FunctionDescriptor, String>)function1);
    }

    public Checks(Regex regex, Check[] checkArray, Function1<? super FunctionDescriptor, String> function1) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"");
        Intrinsics.checkNotNullParameter((Object)checkArray, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        this(null, regex, null, function1, Arrays.copyOf(checkArray, checkArray.length));
    }

    public /* synthetic */ Checks(Regex regex, Check[] checkArray, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = 3.INSTANCE;
        }
        this(regex, checkArray, (Function1<? super FunctionDescriptor, String>)function1);
    }

    public Checks(Collection<Name> collection, Check[] checkArray, Function1<? super FunctionDescriptor, String> function1) {
        Intrinsics.checkNotNullParameter(collection, (String)"");
        Intrinsics.checkNotNullParameter((Object)checkArray, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        this(null, null, collection, function1, Arrays.copyOf(checkArray, checkArray.length));
    }

    public /* synthetic */ Checks(Collection collection, Check[] checkArray, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = 4.INSTANCE;
        }
        this(collection, checkArray, (Function1<? super FunctionDescriptor, String>)function1);
    }
}

