/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.utils;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class SmartList<E>
extends AbstractList<E>
implements RandomAccess {
    private int mySize;
    private Object myElem;

    @Override
    public E get(int n) {
        if (n < 0 || n >= this.mySize) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.mySize);
        }
        if (this.mySize == 1) {
            return (E)this.myElem;
        }
        return (E)((Object[])this.myElem)[n];
    }

    @Override
    public boolean add(E e) {
        if (this.mySize == 0) {
            this.myElem = e;
        } else if (this.mySize == 1) {
            Object[] objectArray = new Object[]{this.myElem, e};
            this.myElem = objectArray;
        } else {
            Object[] objectArray = (Object[])this.myElem;
            int n = objectArray.length;
            if (this.mySize >= n) {
                int n2 = n * 3 / 2 + 1;
                int n3 = this.mySize + 1;
                if (n2 < n3) {
                    n2 = n3;
                }
                Object[] objectArray2 = objectArray;
                objectArray = new Object[n2];
                this.myElem = objectArray;
                System.arraycopy(objectArray2, 0, objectArray, 0, n);
            }
            objectArray[this.mySize] = e;
        }
        ++this.mySize;
        ++this.modCount;
        return true;
    }

    @Override
    public void add(int n, E e) {
        if (n < 0 || n > this.mySize) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.mySize);
        }
        if (this.mySize == 0) {
            this.myElem = e;
        } else if (this.mySize == 1 && n == 0) {
            Object[] objectArray = new Object[]{e, this.myElem};
            this.myElem = objectArray;
        } else {
            Object[] objectArray = new Object[this.mySize + 1];
            if (this.mySize == 1) {
                objectArray[0] = this.myElem;
            } else {
                Object[] objectArray2 = (Object[])this.myElem;
                System.arraycopy(objectArray2, 0, objectArray, 0, n);
                System.arraycopy(objectArray2, n, objectArray, n + 1, this.mySize - n);
            }
            objectArray[n] = e;
            this.myElem = objectArray;
        }
        ++this.mySize;
        ++this.modCount;
    }

    @Override
    public int size() {
        return this.mySize;
    }

    @Override
    public void clear() {
        this.myElem = null;
        this.mySize = 0;
        ++this.modCount;
    }

    @Override
    public E set(int n, E e) {
        Object object;
        if (n < 0 || n >= this.mySize) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.mySize);
        }
        if (this.mySize == 1) {
            object = this.myElem;
            this.myElem = e;
        } else {
            Object[] objectArray = (Object[])this.myElem;
            object = objectArray[n];
            objectArray[n] = e;
        }
        return (E)object;
    }

    @Override
    public E remove(int n) {
        Object object;
        if (n < 0 || n >= this.mySize) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.mySize);
        }
        if (this.mySize == 1) {
            object = this.myElem;
            this.myElem = null;
        } else {
            Object[] objectArray = (Object[])this.myElem;
            object = objectArray[n];
            if (this.mySize == 2) {
                this.myElem = objectArray[1 - n];
            } else {
                int n2 = this.mySize - n - 1;
                if (n2 > 0) {
                    System.arraycopy(objectArray, n + 1, objectArray, n, n2);
                }
                objectArray[this.mySize - 1] = null;
            }
        }
        --this.mySize;
        ++this.modCount;
        return (E)object;
    }

    @Override
    public Iterator<E> iterator() {
        if (this.mySize == 0) {
            EmptyIterator emptyIterator = EmptyIterator.getInstance();
            if (emptyIterator == null) {
                SmartList.$$$reportNull$$$0(2);
            }
            return emptyIterator;
        }
        if (this.mySize == 1) {
            return new SingletonIterator();
        }
        Iterator iterator2 = super.iterator();
        if (iterator2 == null) {
            SmartList.$$$reportNull$$$0(3);
        }
        return iterator2;
    }

    @Override
    public void sort(Comparator<? super E> comparator) {
        if (this.mySize >= 2) {
            Arrays.sort((Object[])this.myElem, 0, this.mySize, comparator);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public <T> T[] toArray(T[] TArray) {
        int n;
        block10: {
            if (TArray == null) {
                SmartList.$$$reportNull$$$0(4);
            }
            n = TArray.length;
            if (this.mySize == 1) {
                if (n != 0) {
                    TArray[0] = this.myElem;
                    break block10;
                } else {
                    Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), 1);
                    objectArray[0] = this.myElem;
                    if (objectArray == null) {
                        SmartList.$$$reportNull$$$0(5);
                    }
                    return objectArray;
                }
            }
            if (n < this.mySize) {
                T[] TArray2 = Arrays.copyOf((Object[])this.myElem, this.mySize, TArray.getClass());
                if (TArray2 == null) {
                    SmartList.$$$reportNull$$$0(6);
                }
                return TArray2;
            }
            if (this.mySize != 0) {
                System.arraycopy(this.myElem, 0, TArray, 0, this.mySize);
            }
        }
        if (n > this.mySize) {
            TArray[this.mySize] = null;
        }
        if (TArray == null) {
            SmartList.$$$reportNull$$$0(7);
        }
        return TArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlin/reflect/jvm/internal/impl/utils/SmartList";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "kotlin/reflect/jvm/internal/impl/utils/SmartList";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SingletonIterator
    extends SingletonIteratorBase<E> {
        private final int myInitialModCount;

        public SingletonIterator() {
            this.myInitialModCount = SmartList.this.modCount;
        }

        @Override
        protected E getElement() {
            return SmartList.this.myElem;
        }

        @Override
        protected void checkCoModification() {
            if (SmartList.this.modCount != this.myInitialModCount) {
                throw new ConcurrentModificationException("ModCount: " + SmartList.this.modCount + "; expected: " + this.myInitialModCount);
            }
        }

        @Override
        public void remove() {
            this.checkCoModification();
            SmartList.this.clear();
        }
    }

    private static abstract class SingletonIteratorBase<T>
    implements Iterator<T> {
        private boolean myVisited;

        private SingletonIteratorBase() {
        }

        @Override
        public final boolean hasNext() {
            return !this.myVisited;
        }

        @Override
        public final T next() {
            if (this.myVisited) {
                throw new NoSuchElementException();
            }
            this.myVisited = true;
            this.checkCoModification();
            return this.getElement();
        }

        protected abstract void checkCoModification();

        protected abstract T getElement();
    }

    private static class EmptyIterator<T>
    implements Iterator<T> {
        private static final EmptyIterator INSTANCE = new EmptyIterator();

        private EmptyIterator() {
        }

        public static <T> EmptyIterator<T> getInstance() {
            return INSTANCE;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }
}

