/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.CvArr;
import org.bytedeco.opencv.opencv_core.CvMat;
import org.bytedeco.opencv.opencv_core.CvScalar;
import org.bytedeco.opencv.opencv_core.IplImage;
import org.bytedeco.opencv.opencv_core.IplROI;

@Properties(inherit={org.bytedeco.opencv.presets.opencv_core.class})
public abstract class AbstractCvMat
extends CvArr {
    protected BytePointer pointer;
    private int fullSize = 0;
    private ByteBuffer byteBuffer = null;
    private ShortBuffer shortBuffer = null;
    private IntBuffer intBuffer = null;
    private FloatBuffer floatBuffer = null;
    private DoubleBuffer doubleBuffer = null;

    public AbstractCvMat(Pointer pointer) {
        super(pointer);
    }

    public static CvMat create(int n, int n2, int n3) {
        CvMat cvMat = opencv_core.cvCreateMat(n, n2, n3);
        if (cvMat != null) {
            cvMat.fullSize = cvMat.size();
            cvMat.deallocator(new ReleaseDeallocator(cvMat));
        }
        return cvMat;
    }

    public static CvMat create(int n, int n2, int n3, int n4) {
        return AbstractCvMat.create(n, n2, opencv_core.CV_MAKETYPE(n3, n4));
    }

    public static CvMat create(int n, int n2) {
        return AbstractCvMat.create(n, n2, 6, 1);
    }

    public static CvMat createHeader(int n, int n2, int n3) {
        CvMat cvMat = opencv_core.cvCreateMatHeader(n, n2, n3);
        if (cvMat != null) {
            cvMat.fullSize = cvMat.size();
            cvMat.deallocator(new ReleaseDeallocator(cvMat));
        }
        return cvMat;
    }

    public static CvMat createHeader(int n, int n2, int n3, int n4) {
        return AbstractCvMat.createHeader(n, n2, opencv_core.CV_MAKETYPE(n3, n4));
    }

    public static CvMat createHeader(int n, int n2) {
        return AbstractCvMat.createHeader(n, n2, 6, 1);
    }

    public static CvMat create(int n, int n2, int n3, int n4, Pointer pointer) {
        CvMat cvMat = AbstractCvMat.createHeader(n, n2, n3, n4);
        cvMat.pointer = new BytePointer(pointer);
        cvMat.data_ptr(cvMat.pointer);
        return cvMat;
    }

    public static ThreadLocal<CvMat> createThreadLocal(final int n, final int n2, final int n3) {
        return new ThreadLocal<CvMat>(){

            @Override
            protected CvMat initialValue() {
                return AbstractCvMat.create(n, n2, n3);
            }
        };
    }

    public static ThreadLocal<CvMat> createThreadLocal(int n, int n2, int n3, int n4) {
        return AbstractCvMat.createThreadLocal(n, n2, opencv_core.CV_MAKETYPE(n3, n4));
    }

    public static ThreadLocal<CvMat> createThreadLocal(int n, int n2) {
        return AbstractCvMat.createThreadLocal(n, n2, 6, 1);
    }

    public static ThreadLocal<CvMat> createHeaderThreadLocal(final int n, final int n2, final int n3) {
        return new ThreadLocal<CvMat>(){

            @Override
            protected CvMat initialValue() {
                return AbstractCvMat.createHeader(n, n2, n3);
            }
        };
    }

    public static ThreadLocal<CvMat> createHeaderThreadLocal(int n, int n2, int n3, int n4) {
        return AbstractCvMat.createHeaderThreadLocal(n, n2, opencv_core.CV_MAKETYPE(n3, n4));
    }

    public static ThreadLocal<CvMat> createHeaderThreadLocal(int n, int n2) {
        return AbstractCvMat.createHeaderThreadLocal(n, n2, 6, 1);
    }

    public CvMat clone() {
        CvMat cvMat = opencv_core.cvCloneMat((CvMat)this);
        if (cvMat != null) {
            cvMat.deallocator(new ReleaseDeallocator(cvMat));
        }
        return cvMat;
    }

    public void release() {
        this.deallocate();
    }

    public abstract int type();

    public abstract CvMat type(int var1);

    public abstract int step();

    public abstract BytePointer data_ptr();

    public abstract FloatPointer data_fl();

    public abstract DoublePointer data_db();

    public abstract IntPointer data_i();

    public abstract ShortPointer data_s();

    public abstract int rows();

    public abstract int cols();

    public int matType() {
        return opencv_core.CV_MAT_TYPE(this.type());
    }

    public void type(int n, int n2) {
        this.type(opencv_core.CV_MAKETYPE(n, n2) | 0x42420000);
    }

    public int depth() {
        return opencv_core.CV_MAT_DEPTH(this.type());
    }

    public int channels() {
        return opencv_core.CV_MAT_CN(this.type());
    }

    public int nChannels() {
        return opencv_core.CV_MAT_CN(this.type());
    }

    public boolean isContinuous() {
        return opencv_core.CV_IS_MAT_CONT(this.type()) != 0;
    }

    public int elemSize() {
        switch (this.depth()) {
            case 0: 
            case 1: {
                return 1;
            }
            case 2: 
            case 3: {
                return 2;
            }
            case 4: 
            case 5: {
                return 4;
            }
            case 6: {
                return 8;
            }
        }
        assert (false);
        return 0;
    }

    public int length() {
        return this.rows() * this.cols();
    }

    public int total() {
        return this.rows() * this.cols();
    }

    public boolean empty() {
        return this.length() == 0;
    }

    public int size() {
        int n = this.rows();
        return this.cols() * this.elemSize() * this.channels() + (n > 1 ? this.step() * (n - 1) : 0);
    }

    @Override
    public int arrayChannels() {
        return this.channels();
    }

    @Override
    public int arrayDepth() {
        switch (this.depth()) {
            case 0: {
                return 8;
            }
            case 1: {
                return -2147483640;
            }
            case 2: {
                return 16;
            }
            case 3: {
                return -2147483632;
            }
            case 4: {
                return -2147483616;
            }
            case 5: {
                return 32;
            }
            case 6: {
                return 64;
            }
        }
        assert (false);
        return -1;
    }

    @Override
    public int arrayOrigin() {
        return 0;
    }

    @Override
    public void arrayOrigin(int n) {
    }

    @Override
    public int arrayWidth() {
        return this.cols();
    }

    @Override
    public int arrayHeight() {
        return this.rows();
    }

    @Override
    public IplROI arrayROI() {
        return null;
    }

    @Override
    public long arraySize() {
        return this.size();
    }

    @Override
    public BytePointer arrayData() {
        return this.data_ptr();
    }

    @Override
    public long arrayStep() {
        return this.step();
    }

    @Deprecated
    public void reset() {
        this.fullSize = 0;
        this.byteBuffer = null;
        this.shortBuffer = null;
        this.intBuffer = null;
        this.floatBuffer = null;
        this.doubleBuffer = null;
    }

    private int fullSize() {
        return this.fullSize > 0 ? this.fullSize : (this.fullSize = this.size());
    }

    @Override
    @Deprecated
    public ByteBuffer getByteBuffer() {
        if (this.byteBuffer == null) {
            this.byteBuffer = this.data_ptr().capacity((long)this.fullSize()).asBuffer();
        }
        this.byteBuffer.position(0);
        return this.byteBuffer;
    }

    @Override
    @Deprecated
    public ShortBuffer getShortBuffer() {
        if (this.shortBuffer == null) {
            this.shortBuffer = this.data_s().capacity((long)(this.fullSize() / 2)).asBuffer();
        }
        this.shortBuffer.position(0);
        return this.shortBuffer;
    }

    @Override
    @Deprecated
    public IntBuffer getIntBuffer() {
        if (this.intBuffer == null) {
            this.intBuffer = this.data_i().capacity((long)(this.fullSize() / 4)).asBuffer();
        }
        this.intBuffer.position(0);
        return this.intBuffer;
    }

    @Override
    @Deprecated
    public FloatBuffer getFloatBuffer() {
        if (this.floatBuffer == null) {
            this.floatBuffer = this.data_fl().capacity((long)(this.fullSize() / 4)).asBuffer();
        }
        this.floatBuffer.position(0);
        return this.floatBuffer;
    }

    @Override
    @Deprecated
    public DoubleBuffer getDoubleBuffer() {
        if (this.doubleBuffer == null) {
            this.doubleBuffer = this.data_db().capacity((long)(this.fullSize() / 8)).asBuffer();
        }
        this.doubleBuffer.position(0);
        return this.doubleBuffer;
    }

    @Deprecated
    public double get(int n) {
        switch (this.depth()) {
            case 0: {
                return this.getByteBuffer().get(n) & 0xFF;
            }
            case 1: {
                return this.getByteBuffer().get(n);
            }
            case 2: {
                return this.getShortBuffer().get(n) & 0xFFFF;
            }
            case 3: {
                return this.getShortBuffer().get(n);
            }
            case 4: {
                return this.getIntBuffer().get(n);
            }
            case 5: {
                return this.getFloatBuffer().get(n);
            }
            case 6: {
                return this.getDoubleBuffer().get(n);
            }
        }
        assert (false);
        return Double.NaN;
    }

    @Deprecated
    public double get(int n, int n2) {
        return this.get(n * this.step() / this.elemSize() + n2 * this.channels());
    }

    @Deprecated
    public double get(int n, int n2, int n3) {
        return this.get(n * this.step() / this.elemSize() + n2 * this.channels() + n3);
    }

    @Deprecated
    public synchronized CvMat get(int n, double[] dArray, int n2, int n3) {
        int n4 = this.depth();
        switch (n4) {
            case 0: 
            case 1: {
                ByteBuffer byteBuffer = this.getByteBuffer();
                byteBuffer.position(n);
                for (int i = 0; i < n3; ++i) {
                    dArray[i + n2] = n4 == 0 ? (double)(byteBuffer.get(i) & 0xFF) : (double)byteBuffer.get(i);
                }
                break;
            }
            case 2: 
            case 3: {
                ShortBuffer shortBuffer = this.getShortBuffer();
                shortBuffer.position(n);
                for (int i = 0; i < n3; ++i) {
                    dArray[i + n2] = n4 == 2 ? (double)(shortBuffer.get() & 0xFFFF) : (double)shortBuffer.get();
                }
                break;
            }
            case 4: {
                IntBuffer intBuffer = this.getIntBuffer();
                intBuffer.position(n);
                for (int i = 0; i < n3; ++i) {
                    dArray[i + n2] = intBuffer.get();
                }
                break;
            }
            case 5: {
                FloatBuffer floatBuffer = this.getFloatBuffer();
                floatBuffer.position(n);
                for (int i = 0; i < n3; ++i) {
                    dArray[i + n2] = floatBuffer.get();
                }
                break;
            }
            case 6: {
                this.getDoubleBuffer().position(n);
                this.getDoubleBuffer().get(dArray, n2, n3);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return (CvMat)this;
    }

    @Deprecated
    public CvMat get(int n, double[] dArray) {
        return this.get(n, dArray, 0, dArray.length);
    }

    @Deprecated
    public CvMat get(double[] dArray) {
        return this.get(0, dArray);
    }

    @Deprecated
    public double[] get() {
        double[] dArray = new double[this.fullSize() / this.elemSize()];
        this.get(dArray);
        return dArray;
    }

    @Deprecated
    public CvMat put(int n, double d) {
        switch (this.depth()) {
            case 0: 
            case 1: {
                this.getByteBuffer().put(n, (byte)d);
                break;
            }
            case 2: 
            case 3: {
                this.getShortBuffer().put(n, (short)d);
                break;
            }
            case 4: {
                this.getIntBuffer().put(n, (int)d);
                break;
            }
            case 5: {
                this.getFloatBuffer().put(n, (float)d);
                break;
            }
            case 6: {
                this.getDoubleBuffer().put(n, d);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return (CvMat)this;
    }

    @Deprecated
    public CvMat put(int n, int n2, double d) {
        return this.put(n * this.step() / this.elemSize() + n2 * this.channels(), d);
    }

    @Deprecated
    public CvMat put(int n, int n2, int n3, double d) {
        return this.put(n * this.step() / this.elemSize() + n2 * this.channels() + n3, d);
    }

    @Deprecated
    public synchronized CvMat put(int n, double[] dArray, int n2, int n3) {
        switch (this.depth()) {
            case 0: 
            case 1: {
                ByteBuffer byteBuffer = this.getByteBuffer();
                byteBuffer.position(n);
                for (int i = 0; i < n3; ++i) {
                    byteBuffer.put((byte)dArray[i + n2]);
                }
                break;
            }
            case 2: 
            case 3: {
                ShortBuffer shortBuffer = this.getShortBuffer();
                shortBuffer.position(n);
                for (int i = 0; i < n3; ++i) {
                    shortBuffer.put((short)dArray[i + n2]);
                }
                break;
            }
            case 4: {
                IntBuffer intBuffer = this.getIntBuffer();
                intBuffer.position(n);
                for (int i = 0; i < n3; ++i) {
                    intBuffer.put((int)dArray[i + n2]);
                }
                break;
            }
            case 5: {
                FloatBuffer floatBuffer = this.getFloatBuffer();
                floatBuffer.position(n);
                for (int i = 0; i < n3; ++i) {
                    floatBuffer.put((float)dArray[i + n2]);
                }
                break;
            }
            case 6: {
                DoubleBuffer doubleBuffer = this.getDoubleBuffer();
                doubleBuffer.position(n);
                doubleBuffer.put(dArray, n2, n3);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return (CvMat)this;
    }

    @Deprecated
    public CvMat put(int n, double ... dArray) {
        return this.put(n, dArray, 0, dArray.length);
    }

    @Deprecated
    public CvMat put(double ... dArray) {
        return this.put(0, dArray);
    }

    public CvMat put(CvMat cvMat) {
        return this.put(0, 0, 0, cvMat, 0, 0, 0);
    }

    public synchronized CvMat put(int n, int n2, int n3, CvMat cvMat, int n4, int n5, int n6) {
        if (this.rows() == cvMat.rows() && this.cols() == cvMat.cols() && this.step() == cvMat.step() && this.type() == cvMat.type() && n == 0 && n2 == 0 && n3 == 0 && n4 == 0 && n5 == 0 && n6 == 0) {
            this.getByteBuffer().clear();
            cvMat.getByteBuffer().clear();
            this.getByteBuffer().put(cvMat.getByteBuffer());
        } else {
            int n7 = Math.min(this.rows() - n, cvMat.rows() - n4);
            int n8 = Math.min(this.cols() - n2, cvMat.cols() - n5);
            int n9 = Math.min(this.channels() - n3, cvMat.channels() - n6);
            for (int i = 0; i < n7; ++i) {
                for (int j = 0; j < n8; ++j) {
                    for (int k = 0; k < n9; ++k) {
                        this.put(i + n, j + n2, k + n3, cvMat.get(i + n4, j + n5, k + n6));
                    }
                }
            }
        }
        return (CvMat)this;
    }

    public IplImage asIplImage() {
        IplImage iplImage = new IplImage();
        opencv_core.cvGetImage(this, iplImage);
        return iplImage;
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    public String toString(int n) {
        StringBuilder stringBuilder = new StringBuilder("[ ");
        int n2 = this.channels();
        for (int i = 0; i < this.rows(); ++i) {
            int n3;
            for (n3 = 0; n3 < this.cols(); ++n3) {
                CvScalar cvScalar = opencv_core.cvGet2D(this, i, n3);
                if (n2 > 1) {
                    stringBuilder.append("(");
                }
                for (int j = 0; j < n2; ++j) {
                    stringBuilder.append((float)cvScalar.val(j));
                    if (j >= n2 - 1) continue;
                    stringBuilder.append(", ");
                }
                if (n2 > 1) {
                    stringBuilder.append(")");
                }
                if (n3 >= this.cols() - 1) continue;
                stringBuilder.append(", ");
            }
            if (i >= this.rows() - 1) continue;
            stringBuilder.append("\n  ");
            for (n3 = 0; n3 < n; ++n3) {
                stringBuilder.append(' ');
            }
        }
        stringBuilder.append(" ]");
        return stringBuilder.toString();
    }

    protected static class ReleaseDeallocator
    extends CvMat
    implements Pointer.Deallocator {
        ReleaseDeallocator(CvMat cvMat) {
            super(cvMat);
        }

        public void deallocate() {
            if (this.isNull()) {
                return;
            }
            opencv_core.cvReleaseMat(this);
            this.setNull();
        }
    }
}

