/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.CvArr;
import org.bytedeco.opencv.opencv_core.CvMat;
import org.bytedeco.opencv.opencv_core.CvSize;
import org.bytedeco.opencv.opencv_core.IplImage;
import org.bytedeco.opencv.opencv_core.IplROI;

@Properties(inherit={org.bytedeco.opencv.presets.opencv_core.class})
public abstract class AbstractIplImage
extends CvArr {
    protected BytePointer pointer;

    public AbstractIplImage(Pointer pointer) {
        super(pointer);
    }

    public static IplImage create(CvSize cvSize, int n, int n2) {
        IplImage iplImage = opencv_core.cvCreateImage(cvSize, n, n2);
        if (iplImage != null) {
            iplImage.deallocator(new ReleaseDeallocator(iplImage));
        }
        return iplImage;
    }

    public static IplImage create(int n, int n2, int n3, int n4) {
        return AbstractIplImage.create(opencv_core.cvSize(n, n2), n3, n4);
    }

    public static IplImage create(CvSize cvSize, int n, int n2, int n3) {
        IplImage iplImage = AbstractIplImage.create(cvSize, n, n2);
        if (iplImage != null) {
            iplImage.origin(n3);
        }
        return iplImage;
    }

    public static IplImage create(int n, int n2, int n3, int n4, int n5) {
        IplImage iplImage = AbstractIplImage.create(n, n2, n3, n4);
        if (iplImage != null) {
            iplImage.origin(n5);
        }
        return iplImage;
    }

    public static IplImage createHeader(CvSize cvSize, int n, int n2) {
        IplImage iplImage = opencv_core.cvCreateImageHeader(cvSize, n, n2);
        if (iplImage != null) {
            iplImage.deallocator(new HeaderReleaseDeallocator(iplImage));
        }
        return iplImage;
    }

    public static IplImage createHeader(int n, int n2, int n3, int n4) {
        return AbstractIplImage.createHeader(opencv_core.cvSize(n, n2), n3, n4);
    }

    public static IplImage createHeader(CvSize cvSize, int n, int n2, int n3) {
        IplImage iplImage = AbstractIplImage.createHeader(cvSize, n, n2);
        if (iplImage != null) {
            iplImage.origin(n3);
        }
        return iplImage;
    }

    public static IplImage createHeader(int n, int n2, int n3, int n4, int n5) {
        IplImage iplImage = AbstractIplImage.createHeader(n, n2, n3, n4);
        if (iplImage != null) {
            iplImage.origin(n5);
        }
        return iplImage;
    }

    public static IplImage create(int n, int n2, int n3, int n4, Pointer pointer) {
        IplImage iplImage = AbstractIplImage.createHeader(n, n2, n3, n4);
        iplImage.pointer = new BytePointer(pointer);
        iplImage.imageData(iplImage.pointer);
        return iplImage;
    }

    public static IplImage createCompatible(IplImage iplImage) {
        return AbstractIplImage.createIfNotCompatible(null, iplImage);
    }

    public static IplImage createIfNotCompatible(IplImage iplImage, IplImage iplImage2) {
        if (iplImage == null || iplImage.width() != iplImage2.width() || iplImage.height() != iplImage2.height() || iplImage.depth() != iplImage2.depth() || iplImage.nChannels() != iplImage2.nChannels()) {
            iplImage = AbstractIplImage.create(iplImage2.width(), iplImage2.height(), iplImage2.depth(), iplImage2.nChannels(), iplImage2.origin());
        }
        iplImage.origin(iplImage2.origin());
        return iplImage;
    }

    public IplImage clone() {
        IplImage iplImage = opencv_core.cvCloneImage((IplImage)this);
        if (iplImage != null) {
            iplImage.deallocator(new ReleaseDeallocator(iplImage));
        }
        return iplImage;
    }

    public void release() {
        this.deallocate();
    }

    public abstract int nChannels();

    public abstract int depth();

    public abstract int origin();

    public abstract IplImage origin(int var1);

    public abstract int width();

    public abstract int height();

    public abstract IplROI roi();

    public abstract int imageSize();

    public abstract BytePointer imageData();

    public abstract int widthStep();

    @Override
    public int arrayChannels() {
        return this.nChannels();
    }

    @Override
    public int arrayDepth() {
        return this.depth();
    }

    @Override
    public int arrayOrigin() {
        return this.origin();
    }

    @Override
    public void arrayOrigin(int n) {
        this.origin(n);
    }

    @Override
    public int arrayWidth() {
        return this.width();
    }

    @Override
    public int arrayHeight() {
        return this.height();
    }

    @Override
    public IplROI arrayROI() {
        return this.roi();
    }

    @Override
    public long arraySize() {
        return this.imageSize();
    }

    @Override
    public BytePointer arrayData() {
        return this.imageData();
    }

    @Override
    public long arrayStep() {
        return this.widthStep();
    }

    public CvMat asCvMat() {
        CvMat cvMat = new CvMat();
        opencv_core.cvGetMat((CvArr)this, cvMat, (IntPointer)null, 0);
        return cvMat;
    }

    protected static class HeaderReleaseDeallocator
    extends IplImage
    implements Pointer.Deallocator {
        HeaderReleaseDeallocator(IplImage iplImage) {
            super(iplImage);
        }

        public void deallocate() {
            if (this.isNull()) {
                return;
            }
            opencv_core.cvReleaseImageHeader(this);
            this.setNull();
        }
    }

    protected static class ReleaseDeallocator
    extends IplImage
    implements Pointer.Deallocator {
        ReleaseDeallocator(IplImage iplImage) {
            super(iplImage);
        }

        public void deallocate() {
            if (this.isNull()) {
                return;
            }
            opencv_core.cvReleaseImage(this);
            this.setNull();
        }
    }
}

