/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.opencv_core.DMatch;
import org.bytedeco.opencv.presets.opencv_core;

@Name(value={"std::vector<cv::DMatch>"})
@Properties(inherit={opencv_core.class})
public class DMatchVector
extends Pointer {
    public DMatchVector(Pointer pointer) {
        super(pointer);
    }

    public DMatchVector(DMatch dMatch) {
        this(1L);
        this.put(0L, dMatch);
    }

    public DMatchVector(DMatch ... dMatchArray) {
        this(dMatchArray.length);
        this.put(dMatchArray);
    }

    public DMatchVector() {
        this.allocate();
    }

    public DMatchVector(long l) {
        this.allocate(l);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native DMatchVector put(@ByRef DMatchVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public DMatch front() {
        return this.get(0L);
    }

    public DMatch back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @ByRef
    public native DMatch get(@Cast(value={"size_t"}) long var1);

    public native DMatchVector put(@Cast(value={"size_t"}) long var1, DMatch var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @ByRef DMatch var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public DMatch[] get() {
        DMatch[] dMatchArray = new DMatch[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < dMatchArray.length; ++i) {
            dMatchArray[i] = this.get(i);
        }
        return dMatchArray;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public DMatch pop_back() {
        long l = this.size();
        DMatch dMatch = this.get(l - 1L);
        this.resize(l - 1L);
        return dMatch;
    }

    public DMatchVector push_back(DMatch dMatch) {
        long l = this.size();
        this.resize(l + 1L);
        return this.put(l, dMatch);
    }

    public DMatchVector put(DMatch dMatch) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, dMatch);
    }

    public DMatchVector put(DMatch ... dMatchArray) {
        if (this.size() != (long)dMatchArray.length) {
            this.resize(dMatchArray.length);
        }
        for (int i = 0; i < dMatchArray.length; ++i) {
            this.put(i, dMatchArray[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer pointer) {
            super(pointer);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @ByRef
        @Const
        public native DMatch get();
    }
}

