/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.opencv_core.KeyPointVector;
import org.bytedeco.opencv.presets.opencv_core;

@Name(value={"std::vector<std::vector<cv::KeyPoint> >"})
@Properties(inherit={opencv_core.class})
public class KeyPointVectorVector
extends Pointer {
    public KeyPointVectorVector(Pointer pointer) {
        super(pointer);
    }

    public KeyPointVectorVector(KeyPointVector keyPointVector) {
        this(1L);
        this.put(0L, keyPointVector);
    }

    public KeyPointVectorVector(KeyPointVector ... keyPointVectorArray) {
        this(keyPointVectorArray.length);
        this.put(keyPointVectorArray);
    }

    public KeyPointVectorVector() {
        this.allocate();
    }

    public KeyPointVectorVector(long l) {
        this.allocate(l);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native KeyPointVectorVector put(@ByRef KeyPointVectorVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public KeyPointVector front() {
        return this.get(0L);
    }

    public KeyPointVector back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @ByRef
    public native KeyPointVector get(@Cast(value={"size_t"}) long var1);

    public native KeyPointVectorVector put(@Cast(value={"size_t"}) long var1, KeyPointVector var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @ByRef KeyPointVector var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public KeyPointVector[] get() {
        KeyPointVector[] keyPointVectorArray = new KeyPointVector[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < keyPointVectorArray.length; ++i) {
            keyPointVectorArray[i] = this.get(i);
        }
        return keyPointVectorArray;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public KeyPointVector pop_back() {
        long l = this.size();
        KeyPointVector keyPointVector = this.get(l - 1L);
        this.resize(l - 1L);
        return keyPointVector;
    }

    public KeyPointVectorVector push_back(KeyPointVector keyPointVector) {
        long l = this.size();
        this.resize(l + 1L);
        return this.put(l, keyPointVector);
    }

    public KeyPointVectorVector put(KeyPointVector keyPointVector) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, keyPointVector);
    }

    public KeyPointVectorVector put(KeyPointVector ... keyPointVectorArray) {
        if (this.size() != (long)keyPointVectorArray.length) {
            this.resize(keyPointVectorArray.length);
        }
        for (int i = 0; i < keyPointVectorArray.length; ++i) {
            this.put(i, keyPointVectorArray[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer pointer) {
            super(pointer);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @ByRef
        @Const
        public native KeyPointVector get();
    }
}

