/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.opencv_core.Point2dVector;
import org.bytedeco.opencv.presets.opencv_core;

@Name(value={"std::vector<std::vector<cv::Point2d> >"})
@Properties(inherit={opencv_core.class})
public class Point2dVectorVector
extends Pointer {
    public Point2dVectorVector(Pointer pointer) {
        super(pointer);
    }

    public Point2dVectorVector(Point2dVector point2dVector) {
        this(1L);
        this.put(0L, point2dVector);
    }

    public Point2dVectorVector(Point2dVector ... point2dVectorArray) {
        this(point2dVectorArray.length);
        this.put(point2dVectorArray);
    }

    public Point2dVectorVector() {
        this.allocate();
    }

    public Point2dVectorVector(long l) {
        this.allocate(l);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native Point2dVectorVector put(@ByRef Point2dVectorVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public Point2dVector front() {
        return this.get(0L);
    }

    public Point2dVector back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @ByRef
    public native Point2dVector get(@Cast(value={"size_t"}) long var1);

    public native Point2dVectorVector put(@Cast(value={"size_t"}) long var1, Point2dVector var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @ByRef Point2dVector var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public Point2dVector[] get() {
        Point2dVector[] point2dVectorArray = new Point2dVector[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < point2dVectorArray.length; ++i) {
            point2dVectorArray[i] = this.get(i);
        }
        return point2dVectorArray;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public Point2dVector pop_back() {
        long l = this.size();
        Point2dVector point2dVector = this.get(l - 1L);
        this.resize(l - 1L);
        return point2dVector;
    }

    public Point2dVectorVector push_back(Point2dVector point2dVector) {
        long l = this.size();
        this.resize(l + 1L);
        return this.put(l, point2dVector);
    }

    public Point2dVectorVector put(Point2dVector point2dVector) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, point2dVector);
    }

    public Point2dVectorVector put(Point2dVector ... point2dVectorArray) {
        if (this.size() != (long)point2dVectorArray.length) {
            this.resize(point2dVectorArray.length);
        }
        for (int i = 0; i < point2dVectorArray.length; ++i) {
            this.put(i, point2dVectorArray[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer pointer) {
            super(pointer);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @ByRef
        @Const
        public native Point2dVector get();
    }
}

