/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.opencv_core.Point;
import org.bytedeco.opencv.presets.opencv_core;

@Name(value={"std::vector<cv::Point>"})
@Properties(inherit={opencv_core.class})
public class PointVector
extends Pointer {
    public PointVector(Pointer pointer) {
        super(pointer);
    }

    public PointVector(Point point) {
        this(1L);
        this.put(0L, point);
    }

    public PointVector(Point ... pointArray) {
        this(pointArray.length);
        this.put(pointArray);
    }

    public PointVector() {
        this.allocate();
    }

    public PointVector(long l) {
        this.allocate(l);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native PointVector put(@ByRef PointVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public Point front() {
        return this.get(0L);
    }

    public Point back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @ByRef
    public native Point get(@Cast(value={"size_t"}) long var1);

    public native PointVector put(@Cast(value={"size_t"}) long var1, Point var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @ByRef Point var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public Point[] get() {
        Point[] pointArray = new Point[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < pointArray.length; ++i) {
            pointArray[i] = this.get(i);
        }
        return pointArray;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public Point pop_back() {
        long l = this.size();
        Point point = this.get(l - 1L);
        this.resize(l - 1L);
        return point;
    }

    public PointVector push_back(Point point) {
        long l = this.size();
        this.resize(l + 1L);
        return this.put(l, point);
    }

    public PointVector put(Point point) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, point);
    }

    public PointVector put(Point ... pointArray) {
        if (this.size() != (long)pointArray.length) {
            this.resize(pointArray.length);
        }
        for (int i = 0; i < pointArray.length; ++i) {
            this.put(i, pointArray[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer pointer) {
            super(pointer);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @ByRef
        @Const
        public native Point get();
    }
}

