/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.opencv_core.RectVector;
import org.bytedeco.opencv.presets.opencv_core;

@Name(value={"std::vector<std::vector<cv::Rect> >"})
@Properties(inherit={opencv_core.class})
public class RectVectorVector
extends Pointer {
    public RectVectorVector(Pointer pointer) {
        super(pointer);
    }

    public RectVectorVector(RectVector rectVector) {
        this(1L);
        this.put(0L, rectVector);
    }

    public RectVectorVector(RectVector ... rectVectorArray) {
        this(rectVectorArray.length);
        this.put(rectVectorArray);
    }

    public RectVectorVector() {
        this.allocate();
    }

    public RectVectorVector(long l) {
        this.allocate(l);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native RectVectorVector put(@ByRef RectVectorVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public RectVector front() {
        return this.get(0L);
    }

    public RectVector back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @ByRef
    public native RectVector get(@Cast(value={"size_t"}) long var1);

    public native RectVectorVector put(@Cast(value={"size_t"}) long var1, RectVector var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @ByRef RectVector var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public RectVector[] get() {
        RectVector[] rectVectorArray = new RectVector[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < rectVectorArray.length; ++i) {
            rectVectorArray[i] = this.get(i);
        }
        return rectVectorArray;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public RectVector pop_back() {
        long l = this.size();
        RectVector rectVector = this.get(l - 1L);
        this.resize(l - 1L);
        return rectVector;
    }

    public RectVectorVector push_back(RectVector rectVector) {
        long l = this.size();
        this.resize(l + 1L);
        return this.put(l, rectVector);
    }

    public RectVectorVector put(RectVector rectVector) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, rectVector);
    }

    public RectVectorVector put(RectVector ... rectVectorArray) {
        if (this.size() != (long)rectVectorArray.length) {
            this.resize(rectVectorArray.length);
        }
        for (int i = 0; i < rectVectorArray.length; ++i) {
            this.put(i, rectVectorArray[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer pointer) {
            super(pointer);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @ByRef
        @Const
        public native RectVector get();
    }
}

