/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.opencv_core.Size;
import org.bytedeco.opencv.presets.opencv_core;

@Name(value={"std::vector<cv::Size>"})
@Properties(inherit={opencv_core.class})
public class SizeVector
extends Pointer {
    public SizeVector(Pointer pointer) {
        super(pointer);
    }

    public SizeVector(Size size) {
        this(1L);
        this.put(0L, size);
    }

    public SizeVector(Size ... sizeArray) {
        this(sizeArray.length);
        this.put(sizeArray);
    }

    public SizeVector() {
        this.allocate();
    }

    public SizeVector(long l) {
        this.allocate(l);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native SizeVector put(@ByRef SizeVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public Size front() {
        return this.get(0L);
    }

    public Size back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @ByRef
    public native Size get(@Cast(value={"size_t"}) long var1);

    public native SizeVector put(@Cast(value={"size_t"}) long var1, Size var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @ByRef Size var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public Size[] get() {
        Size[] sizeArray = new Size[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < sizeArray.length; ++i) {
            sizeArray[i] = this.get(i);
        }
        return sizeArray;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public Size pop_back() {
        long l = this.size();
        Size size = this.get(l - 1L);
        this.resize(l - 1L);
        return size;
    }

    public SizeVector push_back(Size size) {
        long l = this.size();
        this.resize(l + 1L);
        return this.put(l, size);
    }

    public SizeVector put(Size size) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, size);
    }

    public SizeVector put(Size ... sizeArray) {
        if (this.size() != (long)sizeArray.length) {
            this.resize(sizeArray.length);
        }
        for (int i = 0; i < sizeArray.length; ++i) {
            this.put(i, sizeArray[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer pointer) {
            super(pointer);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @ByRef
        @Const
        public native Size get();
    }
}

