/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_stitching;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.opencv_stitching.MatchesInfo;
import org.bytedeco.opencv.presets.opencv_stitching;

@Name(value={"std::vector<cv::detail::MatchesInfo>"})
@Properties(inherit={opencv_stitching.class})
public class MatchesInfoVector
extends Pointer {
    public MatchesInfoVector(Pointer pointer) {
        super(pointer);
    }

    public MatchesInfoVector(MatchesInfo matchesInfo) {
        this(1L);
        this.put(0L, matchesInfo);
    }

    public MatchesInfoVector(MatchesInfo ... matchesInfoArray) {
        this(matchesInfoArray.length);
        this.put(matchesInfoArray);
    }

    public MatchesInfoVector() {
        this.allocate();
    }

    public MatchesInfoVector(long l) {
        this.allocate(l);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native MatchesInfoVector put(@ByRef MatchesInfoVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public MatchesInfo front() {
        return this.get(0L);
    }

    public MatchesInfo back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @ByRef
    public native MatchesInfo get(@Cast(value={"size_t"}) long var1);

    public native MatchesInfoVector put(@Cast(value={"size_t"}) long var1, MatchesInfo var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @ByRef MatchesInfo var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public MatchesInfo[] get() {
        MatchesInfo[] matchesInfoArray = new MatchesInfo[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < matchesInfoArray.length; ++i) {
            matchesInfoArray[i] = this.get(i);
        }
        return matchesInfoArray;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public MatchesInfo pop_back() {
        long l = this.size();
        MatchesInfo matchesInfo = this.get(l - 1L);
        this.resize(l - 1L);
        return matchesInfo;
    }

    public MatchesInfoVector push_back(MatchesInfo matchesInfo) {
        long l = this.size();
        this.resize(l + 1L);
        return this.put(l, matchesInfo);
    }

    public MatchesInfoVector put(MatchesInfo matchesInfo) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, matchesInfo);
    }

    public MatchesInfoVector put(MatchesInfo ... matchesInfoArray) {
        if (this.size() != (long)matchesInfoArray.length) {
            this.resize(matchesInfoArray.length);
        }
        for (int i = 0; i < matchesInfoArray.length; ++i) {
            this.put(i, matchesInfoArray[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer pointer) {
            super(pointer);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @ByRef
        @Const
        public native MatchesInfo get();
    }
}

