/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_text;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.presets.opencv_text;

@Name(value={"std::vector<double>"})
@Properties(inherit={opencv_text.class})
public class DoubleVector
extends Pointer {
    public DoubleVector(Pointer pointer) {
        super(pointer);
    }

    public DoubleVector(double d) {
        this(1L);
        this.put(0L, d);
    }

    public DoubleVector(double ... dArray) {
        this(dArray.length);
        this.put(dArray);
    }

    public DoubleVector() {
        this.allocate();
    }

    public DoubleVector(long l) {
        this.allocate(l);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native DoubleVector put(@ByRef DoubleVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public double front() {
        return this.get(0L);
    }

    public double back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    public native double get(@Cast(value={"size_t"}) long var1);

    public native DoubleVector put(@Cast(value={"size_t"}) long var1, double var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, double var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public double[] get() {
        double[] dArray = new double[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.get(i);
        }
        return dArray;
    }

    public String toString() {
        return Arrays.toString(this.get());
    }

    public double pop_back() {
        long l = this.size();
        double d = this.get(l - 1L);
        this.resize(l - 1L);
        return d;
    }

    public DoubleVector push_back(double d) {
        long l = this.size();
        this.resize(l + 1L);
        return this.put(l, d);
    }

    public DoubleVector put(double d) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, d);
    }

    public DoubleVector put(double ... dArray) {
        if (this.size() != (long)dArray.length) {
            this.resize(dArray.length);
        }
        for (int i = 0; i < dArray.length; ++i) {
            this.put(i, dArray[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer pointer) {
            super(pointer);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        public native double get();
    }
}

