/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.selector;

import io.ktor.network.selector.InterestSuspensionsMap;
import io.ktor.network.selector.SelectInterest;
import io.ktor.network.selector.Selectable;
import io.ktor.network.selector.SelectorManager;
import io.ktor.network.selector.SelectorManagerSupport;
import io.ktor.network.selector.SelectorManagerSupportKt;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.n;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0011\b&\u0018\u00002\u00020\u0001:\u00018B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H$\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\tH\u0086@\u00a2\u0006\u0004\b\u000b\u0010\fJ+\u0010\u0012\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u000eH\u0004\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0004H\u0004\u00a2\u0006\u0004\b\u0019\u0010\u001aJ'\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0004H\u0004\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010 \u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u001eH\u0004\u00a2\u0006\u0004\b \u0010!J!\u0010 \u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00172\b\u0010\u001f\u001a\u0004\u0018\u00010\u001eH\u0004\u00a2\u0006\u0004\b \u0010\"R\u0017\u0010$\u001a\u00020#8\u0006\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'R\"\u0010)\u001a\u00020(8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\"\u0010/\u001a\u00020(8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b/\u0010*\u001a\u0004\b0\u0010,\"\u0004\b1\u0010.R,\u00107\u001a\u0004\u0018\u00010\u0004*\u00020\u000e2\b\u00102\u001a\u0004\u0018\u00010\u00048B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b3\u00104\"\u0004\b5\u00106\u00a8\u00069"}, d2={"Lio/ktor/network/selector/SelectorManagerSupport;", "Lio/ktor/network/selector/SelectorManager;", "<init>", "()V", "Lio/ktor/network/selector/Selectable;", "selectable", "", "publishInterest", "(Lio/ktor/network/selector/Selectable;)V", "Lio/ktor/network/selector/SelectInterest;", "interest", "select", "(Lio/ktor/network/selector/Selectable;Lio/ktor/network/selector/SelectInterest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "Ljava/nio/channels/SelectionKey;", "selectedKeys", "", "keys", "handleSelectedKeys", "(Ljava/util/Set;Ljava/util/Set;)V", "key", "handleSelectedKey", "(Ljava/nio/channels/SelectionKey;)V", "Ljava/nio/channels/Selector;", "selector", "applyInterest", "(Ljava/nio/channels/Selector;Lio/ktor/network/selector/Selectable;)V", "attachment", "notifyClosedImpl", "(Ljava/nio/channels/Selector;Ljava/nio/channels/SelectionKey;Lio/ktor/network/selector/Selectable;)V", "", "cause", "cancelAllSuspensions", "(Lio/ktor/network/selector/Selectable;Ljava/lang/Throwable;)V", "(Ljava/nio/channels/Selector;Ljava/lang/Throwable;)V", "Ljava/nio/channels/spi/SelectorProvider;", "provider", "Ljava/nio/channels/spi/SelectorProvider;", "getProvider", "()Ljava/nio/channels/spi/SelectorProvider;", "", "pending", "I", "getPending", "()I", "setPending", "(I)V", "cancelled", "getCancelled", "setCancelled", "newValue", "getSubject", "(Ljava/nio/channels/SelectionKey;)Lio/ktor/network/selector/Selectable;", "setSubject", "(Ljava/nio/channels/SelectionKey;Lio/ktor/network/selector/Selectable;)V", "subject", "ClosedSelectorCancellationException", "ktor-network"})
public abstract class SelectorManagerSupport
implements SelectorManager {
    private final SelectorProvider provider;
    private int pending;
    private int cancelled;

    public SelectorManagerSupport() {
        SelectorProvider selectorProvider = SelectorProvider.provider();
        Intrinsics.checkNotNullExpressionValue((Object)selectorProvider, (String)"");
        this.provider = selectorProvider;
    }

    @Override
    public final SelectorProvider getProvider() {
        return this.provider;
    }

    protected final int getPending() {
        return this.pending;
    }

    protected final void setPending(int n) {
        this.pending = n;
    }

    protected final int getCancelled() {
        return this.cancelled;
    }

    protected final void setCancelled(int n) {
        this.cancelled = n;
    }

    protected abstract void publishInterest(Selectable var1);

    @Override
    public final Object select(Selectable selectable, SelectInterest selectInterest, Continuation<? super Unit> continuation) {
        int n2 = selectable.getInterestedOps();
        int n3 = selectInterest.getFlag();
        if (selectable.isClosed()) {
            SelectorManagerSupportKt.access$selectableIsClosed();
            throw new KotlinNothingValueException();
        }
        if ((n2 & n3) == 0) {
            SelectorManagerSupportKt.access$selectableIsInvalid(n2, n3);
            throw new KotlinNothingValueException();
        }
        boolean bl = false;
        Continuation<? super Unit> continuation2 = continuation;
        boolean bl2 = false;
        n n4 = new n(IntrinsicsKt.intercepted(continuation2), 1);
        n4.f();
        CancellableContinuation cancellableContinuation = (CancellableContinuation)n4;
        boolean bl3 = false;
        cancellableContinuation.a((Function1)select.2.1.INSTANCE);
        selectable.getSuspensions().addSuspension(selectInterest, (CancellableContinuation<? super Unit>)cancellableContinuation);
        if (!cancellableContinuation.c()) {
            this.publishInterest(selectable);
        }
        Object object = n4.i();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended(continuation);
        }
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    protected final void handleSelectedKeys(Set<SelectionKey> set, Set<? extends SelectionKey> set2) {
        Intrinsics.checkNotNullParameter(set, (String)"");
        Intrinsics.checkNotNullParameter(set2, (String)"");
        int n2 = set.size();
        this.pending = set2.size() - n2;
        this.cancelled = 0;
        if (n2 <= 0) {
            return;
        }
        Iterator<SelectionKey> iterator = set.iterator();
        while (iterator.hasNext()) {
            SelectionKey selectionKey = iterator.next();
            this.handleSelectedKey(selectionKey);
            iterator.remove();
        }
    }

    protected final void handleSelectedKey(SelectionKey selectionKey) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)selectionKey, (String)"");
            try {
                int n2 = selectionKey.readyOps();
                int n3 = selectionKey.interestOps();
                Selectable selectable = this.getSubject(selectionKey);
                if (selectable == null) {
                    selectionKey.cancel();
                    int n4 = this.cancelled;
                    this.cancelled = n4 + 1;
                    break block5;
                }
                InterestSuspensionsMap interestSuspensionsMap = selectable.getSuspensions();
                int n5 = n2;
                boolean bl = false;
                int[] nArray = SelectInterest.Companion.getFlags();
                int n6 = nArray.length;
                for (int j = 0; j < n6; ++j) {
                    CancellableContinuation<Unit> cancellableContinuation;
                    if ((nArray[j] & n5) == 0 || interestSuspensionsMap.removeSuspension(j) == null) continue;
                    boolean bl2 = false;
                    ((Continuation)cancellableContinuation).resumeWith(Result.constructor-impl((Object)Unit.INSTANCE));
                }
                int n7 = n3 & ~n2;
                if (n7 != n3) {
                    selectionKey.interestOps(n7);
                }
                if (n7 == 0) break block5;
                n5 = this.pending;
                this.pending = n5 + 1;
            }
            catch (Throwable throwable) {
                selectionKey.cancel();
                int n8 = this.cancelled;
                this.cancelled = n8 + 1;
                Selectable selectable = this.getSubject(selectionKey);
                if (selectable == null) break block5;
                Selectable selectable2 = selectable;
                boolean bl = false;
                this.cancelAllSuspensions(selectable2, throwable);
                this.setSubject(selectionKey, null);
            }
        }
    }

    protected final void applyInterest(Selector selector, Selectable selectable) {
        Intrinsics.checkNotNullParameter((Object)selector, (String)"");
        Intrinsics.checkNotNullParameter((Object)selectable, (String)"");
        try {
            SelectableChannel selectableChannel = selectable.getChannel();
            SelectionKey selectionKey = selectableChannel.keyFor(selector);
            int n2 = selectable.getInterestedOps();
            if (selectionKey == null) {
                if (n2 != 0) {
                    selectableChannel.register(selector, n2, selectable);
                }
            } else if (selectionKey.interestOps() != n2) {
                selectionKey.interestOps(n2);
            }
            if (n2 != 0) {
                int n3 = this.pending;
                this.pending = n3 + 1;
            }
        }
        catch (Throwable throwable) {
            SelectionKey selectionKey = selectable.getChannel().keyFor(selector);
            if (selectionKey != null) {
                selectionKey.cancel();
            }
            this.cancelAllSuspensions(selectable, throwable);
        }
    }

    protected final void notifyClosedImpl(Selector selector, SelectionKey selectionKey, Selectable selectable) {
        Intrinsics.checkNotNullParameter((Object)selector, (String)"");
        Intrinsics.checkNotNullParameter((Object)selectionKey, (String)"");
        Intrinsics.checkNotNullParameter((Object)selectable, (String)"");
        this.cancelAllSuspensions(selectable, (Throwable)new ClosedChannelException());
        this.setSubject(selectionKey, null);
        selector.wakeup();
    }

    protected final void cancelAllSuspensions(Selectable selectable, Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)selectable, (String)"");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"");
        InterestSuspensionsMap interestSuspensionsMap = selectable.getSuspensions();
        boolean bl = false;
        for (SelectInterest selectInterest : SelectInterest.Companion.getAllInterests()) {
            CancellableContinuation<Unit> cancellableContinuation;
            if (interestSuspensionsMap.removeSuspension(selectInterest) == null) continue;
            boolean bl2 = false;
            SelectInterest selectInterest2 = selectInterest;
            CancellableContinuation<Unit> cancellableContinuation2 = cancellableContinuation;
            boolean bl3 = false;
            ((Continuation)cancellableContinuation2).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable)));
        }
    }

    protected final void cancelAllSuspensions(Selector selector, Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)selector, (String)"");
        Throwable throwable2 = throwable;
        if (throwable2 == null) {
            throwable2 = new ClosedSelectorCancellationException();
        }
        Throwable throwable3 = throwable2;
        Set<SelectionKey> set = selector.keys();
        Intrinsics.checkNotNullExpressionValue(set, (String)"");
        Iterable iterable = set;
        boolean bl = false;
        for (Object t : iterable) {
            Object object;
            SelectionKey selectionKey = (SelectionKey)t;
            boolean bl2 = false;
            try {
                if (selectionKey.isValid()) {
                    selectionKey.interestOps(0);
                }
            }
            catch (CancelledKeyException cancelledKeyException) {
                // empty catch block
            }
            if (((object = selectionKey.attachment()) instanceof Selectable ? (Selectable)object : null) != null) {
                Selectable selectable;
                selectable = selectable;
                boolean bl3 = false;
                this.cancelAllSuspensions(selectable, throwable3);
            }
            selectionKey.cancel();
        }
    }

    private final Selectable getSubject(SelectionKey selectionKey) {
        Object object = selectionKey.attachment();
        return object instanceof Selectable ? (Selectable)object : null;
    }

    private final void setSubject(SelectionKey selectionKey, Selectable selectable) {
        selectionKey.attach(selectable);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lio/ktor/network/selector/SelectorManagerSupport$ClosedSelectorCancellationException;", "Ljava/util/concurrent/CancellationException;", "Lkotlinx/coroutines/CancellationException;", "<init>", "()V", "ktor-network"})
    public static final class ClosedSelectorCancellationException
    extends CancellationException {
        public ClosedSelectorCancellationException() {
            super("Closed selector");
        }
    }
}

