/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import dorkbox.os.OS;
import dorkbox.util.LocationResolver;
import dorkbox.util.Sys;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\fJ\u0016\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0004J\u0016\u0010\u0018\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0004J\u000e\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u0004R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u001e"}, d2={"Ldorkbox/util/FontUtil;", "", "()V", "FONTS_LOCATION", "", "getFONTS_LOCATION", "()Ljava/lang/String;", "setFONTS_LOCATION", "(Ljava/lang/String;)V", "version", "getVersion", "getAlphaNumericFontHeight", "", "font", "Ljava/awt/Font;", "getFontAsImage", "Ljava/awt/image/BufferedImage;", "text", "foregroundColor", "Ljava/awt/Color;", "getFontForSpecificHeight", "height", "getFontHeight", "string", "getFontWidth", "getMaxFontHeight", "loadAllFonts", "", "parseFont", "fontInfo", "Utilities"})
public final class FontUtil {
    public static final FontUtil INSTANCE = new FontUtil();
    private static final String version = Sys.INSTANCE.getVersion();
    private static volatile String FONTS_LOCATION = OS.INSTANCE.getProperty(FontUtil.class.getCanonicalName() + ".FONTS_LOCATION", "resources/fonts");

    private FontUtil() {
    }

    public final String getVersion() {
        return version;
    }

    public final String getFONTS_LOCATION() {
        return FONTS_LOCATION;
    }

    public final void setFONTS_LOCATION(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        FONTS_LOCATION = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadAllFonts() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Enumeration<URL> enumeration = LocationResolver.Companion.getResources(FONTS_LOCATION);
        if (enumeration == null) {
            return;
        }
        Enumeration<URL> enumeration2 = enumeration;
        if (enumeration2.hasMoreElements()) {
            enumeration2.nextElement();
            while (enumeration2.hasMoreElements()) {
                URL uRL = enumeration2.nextElement();
                InputStream inputStream = null;
                try {
                    String string = uRL.toURI().getPath();
                    Intrinsics.checkNotNull((Object)string);
                    if (!StringsKt.endsWith$default((String)string, (String)".ttf", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)string, (String)".otf", (boolean)false, (int)2, null)) continue;
                    inputStream = uRL.openStream();
                    Font font = Font.createFont(0, inputStream);
                    graphicsEnvironment.registerFont(font);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (URISyntaxException uRISyntaxException) {
                    uRISyntaxException.printStackTrace();
                }
                catch (FontFormatException fontFormatException) {
                    fontFormatException.printStackTrace();
                }
                finally {
                    if (inputStream == null) continue;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
    }

    public final Font parseFont(String string) {
        Font font;
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        try {
            int n = StringsKt.lastIndexOf$default((CharSequence)string, (String)" ", (int)0, (boolean)false, (int)6, null);
            String string2 = string.substring(n + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
            String string3 = string2;
            int n2 = StringsKt.indexOf$default((CharSequence)string, (String)" ", (int)(n - 7), (boolean)false, (int)4, null);
            String string4 = string.substring(n2 + 1, n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"");
            String string5 = string4;
            int n3 = 0;
            if (StringsKt.equals((String)string5, (String)"bold", (boolean)true)) {
                n3 = 1;
            } else if (StringsKt.equals((String)string5, (String)"italic", (boolean)true)) {
                n3 = 2;
            }
            String string6 = string.substring(0, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"");
            String string7 = string6;
            font = new Font(string7, n3, Integer.parseInt(string3));
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to load font info from '" + string + '\'', exception);
        }
        return font;
    }

    public final Font getFontForSpecificHeight(Font font, int n) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"");
        int n2 = font.getSize();
        Boolean bl = null;
        while (true) {
            Boolean bl2;
            Font font2;
            int n3;
            if ((n3 = this.getMaxFontHeight(font2 = new Font(font.getName(), 0, n2))) < n && bl != Boolean.FALSE) {
                ++n2;
                bl2 = Boolean.TRUE;
            } else if (n3 > n && bl != Boolean.TRUE) {
                --n2;
                bl2 = Boolean.FALSE;
            } else {
                return font2;
            }
            bl = bl2;
        }
    }

    public final int getFontHeight(Font font, String string) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, string);
        int n = glyphVector.getPixelBounds(null, (float)0.0f, (float)0.0f).height;
        graphics2D.dispose();
        return n;
    }

    public final int getFontWidth(Font font, String string) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, string);
        int n = glyphVector.getPixelBounds(null, (float)0.0f, (float)0.0f).width;
        graphics2D.dispose();
        return n;
    }

    public final int getAlphaNumericFontHeight(Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"");
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        int n = fontMetrics.getAscent() + fontMetrics.getDescent();
        graphics2D.dispose();
        return n;
    }

    public final int getMaxFontHeight(Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"");
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        int n = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        graphics2D.dispose();
        return n;
    }

    public final BufferedImage getFontAsImage(Font font, String string, Color color) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)color, (String)"");
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getHeight();
        graphics2D.dispose();
        if (n > n2) {
            n2 = n;
        } else {
            n = n2;
        }
        bufferedImage = new BufferedImage(n, n2, 2);
        graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setFont(font);
        fontMetrics = graphics2D.getFontMetrics();
        graphics2D.setColor(color);
        graphics2D.drawString(string, (float)n / 4.0f, (float)fontMetrics.getAscent());
        graphics2D.dispose();
        return bufferedImage;
    }
}

