/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import dorkbox.updates.Updates;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0010\"\u00020\u000eH\u0007\u00a2\u0006\u0002\u0010\u0011J\u001a\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\b\b\u0002\u0010\u0014\u001a\u00020\u0004H\u0007J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\nH\u0007J\u000e\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u0004J\u000e\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\bJ\u000e\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\bJ\u000e\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\bJ$\u0010\u001f\u001a\u00020\n2\b\u0010 \u001a\u0004\u0018\u00010\n2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\"J\u0016\u0010#\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\n2\u0006\u0010$\u001a\u00020%J\u001a\u0010&\u001a\u00020'\"\b\b\u0000\u0010(*\u00020)2\u0006\u0010*\u001a\u00020)H\u0002J\n\u0010+\u001a\u00020'*\u00020)R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006,"}, d2={"Ldorkbox/util/Sys;", "", "()V", "GIGABYTE", "", "KILOBYTE", "MEGABYTE", "TERABYTE", "", "version", "", "getVersion", "()Ljava/lang/String;", "concatBytes", "", "arrayBytes", "", "([[B)[B", "copyBytes", "src", "position", "getBytesFromStream", "inputStream", "Ljava/io/InputStream;", "getExtension", "fileName", "getSizePretty", "size", "getTimePretty", "nanoSeconds", "getTimePrettyFull", "replaceStringFast", "string", "replacements", "", "searchStringFast", "c", "", "throwException0", "", "T", "", "t", "unchecked", "Utilities"})
public final class Sys {
    public static final Sys INSTANCE = new Sys();
    private static final String version = "1.48";
    public static final int KILOBYTE = 1024;
    public static final int MEGABYTE = 0x100000;
    public static final int GIGABYTE = 0x40000000;
    public static final long TERABYTE = 0x10000000000L;

    private Sys() {
    }

    public final String getVersion() {
        return version;
    }

    public final String replaceStringFast(String string, Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, (String)"");
        StringBuilder stringBuilder = new StringBuilder(string);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string2 = entry.getKey();
            String string3 = entry.getValue();
            int n = stringBuilder.indexOf(string2, 0);
            while (n > -1) {
                int n2 = n + string2.length();
                int n3 = n + string3.length();
                stringBuilder.replace(n, n2, string3);
                n = stringBuilder.indexOf(string2, n3);
            }
        }
        String string4 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"");
        return string4;
    }

    public final int searchStringFast(String string, char c) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        int n = string.length();
        for (int j = 0; j < n; ++j) {
            if (string.charAt(j) != c) continue;
            return j;
        }
        return -1;
    }

    public final String getSizePretty(long l) {
        String string;
        if (l > 0x10000000000L) {
            String string2 = "%2.2fTB";
            Object[] objectArray = new Object[]{(double)l / (double)0x10000000000L};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
            return string3;
        }
        if (l > 0x40000000L) {
            String string4 = "%2.2fGB";
            Object[] objectArray = new Object[]{(double)l / (double)0x40000000};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"");
            return string5;
        }
        if (l > 0x100000L) {
            String string6 = "%2.2fMB";
            Object[] objectArray = new Object[]{(double)l / (double)0x100000};
            String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"");
            return string7;
        }
        if (l > 1024L) {
            String string8 = "%2.2fKB";
            Object[] objectArray = new Object[]{(double)l / (double)1024};
            String string9 = String.format(string8, Arrays.copyOf(objectArray, objectArray.length));
            string = string9;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"");
        } else {
            string = "" + l + 'B';
        }
        return string;
    }

    public final String getSizePretty(int n) {
        String string;
        if (n > 0x40000000) {
            String string2 = "%2.2fGB";
            Object[] objectArray = new Object[]{(double)n / (double)0x40000000};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
            return string3;
        }
        if (n > 0x100000) {
            String string4 = "%2.2fMB";
            Object[] objectArray = new Object[]{(double)n / (double)0x100000};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"");
            return string5;
        }
        if (n > 1024) {
            String string6 = "%2.2fKB";
            Object[] objectArray = new Object[]{(double)n / (double)1024};
            String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
            string = string7;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"");
        } else {
            string = "" + n + 'B';
        }
        return string;
    }

    public final String getTimePretty(long l) {
        String string;
        TimeUnit timeUnit = null;
        String string2 = null;
        if (TimeUnit.DAYS.convert(l, TimeUnit.NANOSECONDS) > 0L) {
            timeUnit = TimeUnit.DAYS;
            string2 = "d";
        } else if (TimeUnit.HOURS.convert(l, TimeUnit.NANOSECONDS) > 0L) {
            timeUnit = TimeUnit.HOURS;
            string2 = "h";
        } else if (TimeUnit.MINUTES.convert(l, TimeUnit.NANOSECONDS) > 0L) {
            timeUnit = TimeUnit.MINUTES;
            string2 = "m";
        } else if (TimeUnit.SECONDS.convert(l, TimeUnit.NANOSECONDS) > 0L) {
            timeUnit = TimeUnit.SECONDS;
            string2 = "s";
        } else if (TimeUnit.MILLISECONDS.convert(l, TimeUnit.NANOSECONDS) > 0L) {
            timeUnit = TimeUnit.MILLISECONDS;
            string2 = "ms";
        } else if (TimeUnit.MICROSECONDS.convert(l, TimeUnit.NANOSECONDS) > 0L) {
            timeUnit = TimeUnit.MICROSECONDS;
            string2 = "\u03bcs";
        } else {
            timeUnit = TimeUnit.NANOSECONDS;
            string2 = "ns";
        }
        double d = (double)l / (double)TimeUnit.NANOSECONDS.convert(1L, timeUnit);
        if (d < 10.0) {
            String string3 = "%.1g " + string2;
            Object[] objectArray = new Object[]{d};
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"");
        } else if (d < 100.0) {
            String string5 = "%.2g " + string2;
            Object[] objectArray = new Object[]{d};
            String string6 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
            string = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"");
        } else if (d < 1000.0) {
            String string7 = "%.3g " + string2;
            Object[] objectArray = new Object[]{d};
            String string8 = String.format(string7, Arrays.copyOf(objectArray, objectArray.length));
            string = string8;
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"");
        } else {
            String string9 = "%.4g " + string2;
            Object[] objectArray = new Object[]{d};
            String string10 = String.format(string9, Arrays.copyOf(objectArray, objectArray.length));
            string = string10;
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"");
        }
        return string;
    }

    public final String getTimePrettyFull(long l) {
        String string;
        TimeUnit timeUnit = null;
        String string2 = null;
        if (TimeUnit.DAYS.convert(l, TimeUnit.NANOSECONDS) > 0L) {
            timeUnit = TimeUnit.DAYS;
            string2 = "day";
        } else if (TimeUnit.HOURS.convert(l, TimeUnit.NANOSECONDS) > 0L) {
            timeUnit = TimeUnit.HOURS;
            string2 = "hour";
        } else if (TimeUnit.MINUTES.convert(l, TimeUnit.NANOSECONDS) > 0L) {
            timeUnit = TimeUnit.MINUTES;
            string2 = "minute";
        } else if (TimeUnit.SECONDS.convert(l, TimeUnit.NANOSECONDS) > 0L) {
            timeUnit = TimeUnit.SECONDS;
            string2 = "second";
        } else if (TimeUnit.MILLISECONDS.convert(l, TimeUnit.NANOSECONDS) > 0L) {
            timeUnit = TimeUnit.MILLISECONDS;
            string2 = "milli-second";
        } else if (TimeUnit.MICROSECONDS.convert(l, TimeUnit.NANOSECONDS) > 0L) {
            timeUnit = TimeUnit.MICROSECONDS;
            string2 = "micro-second";
        } else {
            timeUnit = TimeUnit.NANOSECONDS;
            string2 = "nano-second";
        }
        double d = (double)l / (double)TimeUnit.NANOSECONDS.convert(1L, timeUnit);
        if (d > 1.0) {
            string2 = string2 + 's';
        }
        if (d < 10.0) {
            String string3 = "%.1g " + string2;
            Object[] objectArray = new Object[]{d};
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"");
        } else if (d < 100.0) {
            String string5 = "%.2g " + string2;
            Object[] objectArray = new Object[]{d};
            String string6 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
            string = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"");
        } else if (d < 1000.0) {
            String string7 = "%.3g " + string2;
            Object[] objectArray = new Object[]{d};
            String string8 = String.format(string7, Arrays.copyOf(objectArray, objectArray.length));
            string = string8;
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"");
        } else {
            String string9 = "%.4g " + string2;
            Object[] objectArray = new Object[]{d};
            String string10 = String.format(string9, Arrays.copyOf(objectArray, objectArray.length));
            string = string10;
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"");
        }
        return string;
    }

    private final <T extends Throwable> void throwException0(Throwable throwable) {
        Intrinsics.checkNotNull((Object)throwable);
        throw throwable;
    }

    public final void unchecked(Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"");
        this.throwException0(throwable);
    }

    @Deprecated(message="Use kotlin")
    public final String getExtension(String string) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        int n = StringsKt.lastIndexOf$default((CharSequence)string, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (n > -1) {
            String string3 = string.substring(n + 1);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
        } else {
            string2 = "";
        }
        return string2;
    }

    @Deprecated(message="Use kotlin")
    public final byte[] getBytesFromStream(InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
        byte[] byArray = new byte[4096];
        int n = 0;
        while (true) {
            int n2;
            int n3 = n2 = inputStream.read(byArray);
            boolean bl = false;
            n = n3;
            if (n2 <= 0) break;
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.flush();
        inputStream.close();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"");
        return byArray2;
    }

    @Deprecated(message="Use kotlin")
    public final byte[] copyBytes(byte[] byArray, int n) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"");
        int n2 = byArray.length - n;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public static /* synthetic */ byte[] copyBytes$default(Sys sys, byte[] byArray, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return sys.copyBytes(byArray, n);
    }

    @Deprecated(message="Use kotlin")
    public final byte[] concatBytes(byte[] ... byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"");
        int n = 0;
        int n2 = ((Object[])byArray).length;
        for (int j = 0; j < n2; ++j) {
            byte[] byArray2 = byArray[j];
            n += byArray2.length;
        }
        byte[] byArray3 = new byte[n];
        n = 0;
        int n3 = ((Object[])byArray).length;
        for (n2 = 0; n2 < n3; ++n2) {
            byte[] byArray4 = byArray[n2];
            System.arraycopy(byArray4, 0, byArray3, n, byArray4.length);
            n += byArray4.length;
        }
        return byArray3;
    }

    @Deprecated(message="Use kotlin")
    public final byte[] copyBytes(byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"");
        return Sys.copyBytes$default(this, byArray, 0, 2, null);
    }

    static {
        Updates.INSTANCE.add(Sys.class, "aebbb926aeb144739e9f3cab90ffaa72", version);
    }
}

