/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import kotlin.IgnorableReturnValue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.builders.ListBuilder;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 3, 0}, k=5, xi=49, d1={"\u0000\\\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\u001a#\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0003\u001a\u0002H\u0002H\u0086\u0080\u0004\u00a2\u0006\u0002\u0010\u0004\u001a1\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u0002H\u00020\u0006j\b\u0012\u0004\u0012\u0002H\u0002`\u0007\"\u0004\b\u0000\u0010\u0002*\n\u0012\u0006\b\u0001\u0012\u0002H\u00020\bH\u0081\u0088\u0004\u00a2\u0006\u0002\u0010\t\u001a8\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0001\"\u0004\b\u0000\u0010\u000b2\u001d\u0010\f\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000b0\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0002\b\u0010H\u0081\u0088\u0004\u00f8\u0001\u0000\u001a@\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0001\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u001d\u0010\f\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000b0\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0002\b\u0010H\u0081\u0088\u0004\u00f8\u0001\u0000\u001a\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000e\"\u0004\b\u0000\u0010\u000bH\u0081\u0080\u0004\u001a\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000e\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0081\u0080\u0004\u001a$\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0001\"\u0004\b\u0000\u0010\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000eH\u0081\u0080\u0004\u001a \u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0017H\u0087\u0088\u0004\u001a \u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0019H\u0087\u0080\u0004\u001a(\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0087\u0080\u0004\u001a#\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\b2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0081\u0088\u0004\u00a2\u0006\u0002\u0010 \u001a5\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00020\b\"\u0004\b\u0000\u0010\u00022\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u00020\bH\u0081\u0088\u0004\u00a2\u0006\u0002\u0010\"\u001a1\u0010#\u001a\b\u0012\u0004\u0012\u0002H\u00020\b\"\u0004\b\u0000\u0010\u00022\u0006\u0010$\u001a\u00020\u00122\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u00020\bH\u0080\u0080\u0004\u00a2\u0006\u0002\u0010%\u001a3\u0010&\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001d0\b\"\u0004\b\u0000\u0010\u0002*\n\u0012\u0006\b\u0001\u0012\u0002H\u00020\b2\u0006\u0010'\u001a\u00020(H\u0080\u0080\u0004\u00a2\u0006\u0002\u0010)\u001a\u0012\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u0012H\u0081\u0088\b\u001a\u0012\u0010,\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u0012H\u0081\u0088\b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006."}, d2={"listOf", "", "T", "element", "(Ljava/lang/Object;)Ljava/util/List;", "asArrayList", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "", "([Ljava/lang/Object;)Ljava/util/ArrayList;", "buildListInternal", "E", "builderAction", "Lkotlin/Function1;", "", "", "Lkotlin/ExtensionFunctionType;", "capacity", "", "createListBuilder", "build", "builder", "toList", "Ljava/util/Enumeration;", "shuffled", "", "random", "Ljava/util/Random;", "collectionToArray", "", "collection", "", "(Ljava/util/Collection;)[Ljava/lang/Object;", "array", "(Ljava/util/Collection;[Ljava/lang/Object;)[Ljava/lang/Object;", "terminateCollectionToArray", "collectionSize", "(I[Ljava/lang/Object;)[Ljava/lang/Object;", "copyToArrayOfAny", "isVarargs", "", "([Ljava/lang/Object;Z)[Ljava/lang/Object;", "checkIndexOverflow", "index", "checkCountOverflow", "count", "kotlin-stdlib"}, xs="kotlin/collections/CollectionsKt")
class CollectionsKt__CollectionsJVMKt {
    public static final <T> List<T> listOf(T t) {
        List<T> list = Collections.singletonList(t);
        Intrinsics.checkNotNullExpressionValue(list, "");
        return list;
    }

    private static final <T> ArrayList<T> asArrayList(T[] TArray) {
        Intrinsics.checkNotNullParameter(TArray, "");
        return new ArrayList<T>(CollectionsKt.asCollection(TArray, true));
    }

    private static final <E> List<E> buildListInternal(Function1<? super List<E>, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, "");
        List<E> list = CollectionsKt.createListBuilder();
        function1.invoke(list);
        return CollectionsKt.build(list);
    }

    private static final <E> List<E> buildListInternal(int n, Function1<? super List<E>, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, "");
        List<E> list = CollectionsKt.createListBuilder(n);
        function1.invoke(list);
        return CollectionsKt.build(list);
    }

    public static final <E> List<E> createListBuilder() {
        return new ListBuilder(0, 1, null);
    }

    public static final <E> List<E> createListBuilder(int n) {
        return new ListBuilder(n);
    }

    public static final <E> List<E> build(List<E> list) {
        Intrinsics.checkNotNullParameter(list, "");
        return ((ListBuilder)list).build();
    }

    private static final <T> List<T> toList(Enumeration<T> enumeration) {
        Intrinsics.checkNotNullParameter(enumeration, "");
        ArrayList<T> arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, "");
        return arrayList;
    }

    public static final <T> List<T> shuffled(Iterable<? extends T> iterable) {
        List<T> list;
        Intrinsics.checkNotNullParameter(iterable, "");
        List<T> list2 = list = CollectionsKt.toMutableList(iterable);
        boolean bl = false;
        Collections.shuffle(list2);
        return list;
    }

    public static final <T> List<T> shuffled(Iterable<? extends T> iterable, Random random) {
        List<T> list;
        Intrinsics.checkNotNullParameter(iterable, "");
        Intrinsics.checkNotNullParameter(random, "");
        List<T> list2 = list = CollectionsKt.toMutableList(iterable);
        boolean bl = false;
        Collections.shuffle(list2, random);
        return list;
    }

    private static final Object[] collectionToArray(Collection<?> collection) {
        Intrinsics.checkNotNullParameter(collection, "");
        return CollectionToArray.toArray(collection);
    }

    private static final <T> T[] collectionToArray(Collection<?> collection, T[] TArray) {
        Intrinsics.checkNotNullParameter(collection, "");
        Intrinsics.checkNotNullParameter(TArray, "");
        return CollectionToArray.toArray(collection, TArray);
    }

    public static final <T> T[] terminateCollectionToArray(int n, T[] TArray) {
        Intrinsics.checkNotNullParameter(TArray, "");
        if (n < TArray.length) {
            TArray[n] = null;
        }
        return TArray;
    }

    public static final <T> Object[] copyToArrayOfAny(T[] TArray, boolean bl) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(TArray, "");
        if (bl && Intrinsics.areEqual(TArray.getClass(), Object[].class)) {
            objectArray = TArray;
        } else {
            T[] TArray2 = Arrays.copyOf(TArray, TArray.length, Object[].class);
            objectArray = TArray2;
            Intrinsics.checkNotNullExpressionValue(TArray2, "");
        }
        return objectArray;
    }

    @IgnorableReturnValue
    private static final int checkIndexOverflow(int n) {
        if (n < 0) {
            CollectionsKt.throwIndexOverflow();
        }
        return n;
    }

    @IgnorableReturnValue
    private static final int checkCountOverflow(int n) {
        if (n < 0) {
            CollectionsKt.throwCountOverflow();
        }
        return n;
    }
}

