/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\bB\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0086\u0080\u0004J\u0012\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\tH\u0082\u0080\u0004J\n\u0010\u001d\u001a\u00020\u0005H\u0082\u0080\u0004J\u001a\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005H\u0082\u0080\u0004J\u0012\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001aH\u0082\u0080\u0004J\n\u0010#\u001a\u00020\"H\u0082\u0080\u0004J\n\u0010$\u001a\u00020\"H\u0082\u0080\u0004R\u000f\u0010\u0004\u001a\u00020\u0005X\u0082\u00d4\b\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0006\u001a\u00020\u0007X\u0082\u00ae\b\u00a2\u0006\u0002\n\u0000R\u000f\u0010\b\u001a\u00020\tX\u0082\u008e\b\u00a2\u0006\u0002\n\u0000R\u000f\u0010\n\u001a\u00020\u000bX\u0082\u0084\b\u00a2\u0006\u0002\n\u0000R\u000f\u0010\f\u001a\u00020\rX\u0082\u0084\b\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u000e\u001a\u00020\u000fX\u0082\u0084\b\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0010\u001a\u00020\u0011X\u0082\u0084\b\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014X\u0082\u0084\b\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lkotlin/io/LineReader;", "", "<init>", "()V", "BUFFER_SIZE", "", "decoder", "Ljava/nio/charset/CharsetDecoder;", "directEOL", "", "bytes", "", "chars", "", "byteBuf", "Ljava/nio/ByteBuffer;", "charBuf", "Ljava/nio/CharBuffer;", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "readLine", "", "inputStream", "Ljava/io/InputStream;", "charset", "Ljava/nio/charset/Charset;", "decode", "endOfInput", "compactBytes", "decodeEndOfInput", "nBytes", "nChars", "updateCharset", "", "resetAll", "trimStringBuilder", "kotlin-stdlib"})
public final class LineReader {
    public static final LineReader INSTANCE = new LineReader();
    private static final int BUFFER_SIZE = 32;
    private static CharsetDecoder decoder;
    private static boolean directEOL;
    private static final byte[] bytes;
    private static final char[] chars;
    private static final ByteBuffer byteBuf;
    private static final CharBuffer charBuf;
    private static final StringBuilder sb;

    private LineReader() {
    }

    public final synchronized String readLine(InputStream inputStream, Charset charset) {
        block12: {
            block11: {
                Intrinsics.checkNotNullParameter(inputStream, "");
                Intrinsics.checkNotNullParameter(charset, "");
                if (decoder == null) break block11;
                CharsetDecoder charsetDecoder = decoder;
                if (charsetDecoder == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("");
                    charsetDecoder = null;
                }
                if (Intrinsics.areEqual(charsetDecoder.charset(), charset)) break block12;
            }
            this.updateCharset(charset);
        }
        int n = 0;
        int n2 = 0;
        while (true) {
            int n3;
            if ((n3 = inputStream.read()) == -1) {
                if (((CharSequence)sb).length() == 0 && n == 0 && n2 == 0) {
                    return null;
                }
                n2 = this.decodeEndOfInput(n, n2);
                break;
            }
            LineReader.bytes[n++] = (byte)n3;
            if (n3 != 10 && n != 32 && directEOL) continue;
            byteBuf.limit(n);
            charBuf.position(n2);
            n2 = this.decode(false);
            if (n2 > 0 && chars[n2 - 1] == '\n') {
                byteBuf.position(0);
                break;
            }
            n = this.compactBytes();
        }
        if (n2 > 0 && chars[n2 - 1] == '\n' && --n2 > 0 && chars[n2 - 1] == '\r') {
            --n2;
        }
        if (((CharSequence)sb).length() == 0) {
            return new String(chars, 0, n2);
        }
        sb.append(chars, 0, n2);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "");
        String string2 = string;
        if (sb.length() > 32) {
            this.trimStringBuilder();
        }
        sb.setLength(0);
        return string2;
    }

    private final int decode(boolean bl) {
        while (true) {
            CoderResult coderResult;
            CharsetDecoder charsetDecoder;
            if ((charsetDecoder = decoder) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("");
                charsetDecoder = null;
            }
            Intrinsics.checkNotNullExpressionValue(charsetDecoder.decode(byteBuf, charBuf, bl), "");
            if (coderResult.isError()) {
                this.resetAll();
                coderResult.throwException();
            }
            int n = charBuf.position();
            if (!coderResult.isOverflow()) {
                return n;
            }
            sb.append(chars, 0, n - 1);
            charBuf.position(0);
            charBuf.limit(32);
            charBuf.put(chars[n - 1]);
        }
    }

    private final int compactBytes() {
        int n;
        ByteBuffer byteBuffer = byteBuf;
        boolean bl = false;
        byteBuffer.compact();
        int n2 = n = byteBuffer.position();
        boolean bl2 = false;
        byteBuffer.position(0);
        return n;
    }

    private final int decodeEndOfInput(int n, int n2) {
        int n3;
        byteBuf.limit(n);
        charBuf.position(n2);
        int n4 = n3 = this.decode(true);
        boolean bl = false;
        CharsetDecoder charsetDecoder = decoder;
        if (charsetDecoder == null) {
            Intrinsics.throwUninitializedPropertyAccessException("");
            charsetDecoder = null;
        }
        charsetDecoder.reset();
        byteBuf.position(0);
        return n3;
    }

    private final void updateCharset(Charset charset) {
        CharsetDecoder charsetDecoder = charset.newDecoder();
        Intrinsics.checkNotNullExpressionValue(charsetDecoder, "");
        decoder = charsetDecoder;
        byteBuf.clear();
        charBuf.clear();
        byteBuf.put((byte)10);
        byteBuf.flip();
        CharsetDecoder charsetDecoder2 = decoder;
        if (charsetDecoder2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("");
            charsetDecoder2 = null;
        }
        charsetDecoder2.decode(byteBuf, charBuf, false);
        directEOL = charBuf.position() == 1 && charBuf.get(0) == '\n';
        this.resetAll();
    }

    private final void resetAll() {
        CharsetDecoder charsetDecoder = decoder;
        if (charsetDecoder == null) {
            Intrinsics.throwUninitializedPropertyAccessException("");
            charsetDecoder = null;
        }
        charsetDecoder.reset();
        byteBuf.position(0);
        sb.setLength(0);
    }

    private final void trimStringBuilder() {
        sb.setLength(32);
        sb.trimToSize();
    }

    static {
        bytes = new byte[32];
        chars = new char[32];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "");
        byteBuf = byteBuffer;
        CharBuffer charBuffer = CharBuffer.wrap(chars);
        Intrinsics.checkNotNullExpressionValue(charBuffer, "");
        charBuf = charBuffer;
        sb = new StringBuilder();
    }
}

