/*
 * Decompiled with CFR 0.152.
 */
package kotlin.jvm.internal;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import kotlin.jvm.KotlinReflectionNotSupportedError;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KCallable;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeParameter;
import kotlin.reflect.KVisibility;

public abstract class CallableReference
implements Serializable,
KCallable {
    private transient KCallable reflected;
    protected final Object receiver;
    private final Class owner;
    private final String name;
    private final String signature;
    private final boolean isTopLevel;
    public static final Object NO_RECEIVER = NoReceiver.access$000();

    public CallableReference() {
        this(NO_RECEIVER);
    }

    protected CallableReference(Object object) {
        this(object, null, null, null, false);
    }

    protected CallableReference(Object object, Class clazz, String string, String string2, boolean bl) {
        this.receiver = object;
        this.owner = clazz;
        this.name = string;
        this.signature = string2;
        this.isTopLevel = bl;
    }

    protected abstract KCallable computeReflected();

    public Object getBoundReceiver() {
        return this.receiver;
    }

    public KCallable compute() {
        KCallable kCallable = this.reflected;
        if (kCallable == null) {
            this.reflected = kCallable = this.computeReflected();
        }
        return kCallable;
    }

    protected KCallable getReflected() {
        KCallable kCallable = this.compute();
        if (kCallable == this) {
            throw new KotlinReflectionNotSupportedError();
        }
        return kCallable;
    }

    public KDeclarationContainer getOwner() {
        return this.owner == null ? null : (this.isTopLevel ? Reflection.getOrCreateKotlinPackage(this.owner) : Reflection.getOrCreateKotlinClass(this.owner));
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getSignature() {
        return this.signature;
    }

    @Override
    public List<KParameter> getParameters() {
        return this.getReflected().getParameters();
    }

    @Override
    public KType getReturnType() {
        return this.getReflected().getReturnType();
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.getReflected().getAnnotations();
    }

    @Override
    public List<KTypeParameter> getTypeParameters() {
        return this.getReflected().getTypeParameters();
    }

    public Object call(Object ... objectArray) {
        return this.getReflected().call(objectArray);
    }

    public Object callBy(Map map) {
        return this.getReflected().callBy(map);
    }

    @Override
    public KVisibility getVisibility() {
        return this.getReflected().getVisibility();
    }

    @Override
    public boolean isFinal() {
        return this.getReflected().isFinal();
    }

    @Override
    public boolean isOpen() {
        return this.getReflected().isOpen();
    }

    @Override
    public boolean isAbstract() {
        return this.getReflected().isAbstract();
    }

    @Override
    public boolean isSuspend() {
        return this.getReflected().isSuspend();
    }

    private static class NoReceiver
    implements Serializable {
        private static final NoReceiver INSTANCE = new NoReceiver();

        private NoReceiver() {
        }

        private Object readResolve() {
            return INSTANCE;
        }

        static /* synthetic */ NoReceiver access$000() {
            return INSTANCE;
        }
    }
}

