/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.parsing;

import io.ktor.http.parsing.AnyOfGrammar;
import io.ktor.http.parsing.AtLeastOne;
import io.ktor.http.parsing.Grammar;
import io.ktor.http.parsing.ManyGrammar;
import io.ktor.http.parsing.MaybeGrammar;
import io.ktor.http.parsing.NamedGrammar;
import io.ktor.http.parsing.OrGrammar;
import io.ktor.http.parsing.RangeGrammar;
import io.ktor.http.parsing.RawGrammar;
import io.ktor.http.parsing.SequenceGrammar;
import io.ktor.http.parsing.StringGrammar;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u001a\u001d\u0010\u0004\u001a\u00020\u0003*\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u001f\u0010\b\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lio/ktor/http/parsing/Grammar;", "", "offset", "", "printDebug", "(Lio/ktor/http/parsing/Grammar;I)V", "", "node", "printlnWithOffset", "(ILjava/lang/Object;)V", "ktor-http"})
public final class DebugKt {
    public static final void printDebug(Grammar grammar, int n) {
        Intrinsics.checkNotNullParameter((Object)grammar, (String)"");
        Grammar grammar2 = grammar;
        if (grammar2 instanceof StringGrammar) {
            DebugKt.printlnWithOffset(n, "STRING[" + Regex.Companion.escape(((StringGrammar)grammar).getValue()) + ']');
        } else if (grammar2 instanceof RawGrammar) {
            DebugKt.printlnWithOffset(n, "STRING[" + ((RawGrammar)grammar).getValue() + ']');
        } else if (grammar2 instanceof NamedGrammar) {
            DebugKt.printlnWithOffset(n, "NAMED[" + ((NamedGrammar)grammar).getName() + ']');
            DebugKt.printDebug(((NamedGrammar)grammar).getGrammar(), n + 2);
        } else if (grammar2 instanceof SequenceGrammar) {
            DebugKt.printlnWithOffset(n, "SEQUENCE");
            Iterable iterable = ((SequenceGrammar)grammar).getGrammars();
            boolean bl = false;
            for (Object t : iterable) {
                Grammar grammar3 = (Grammar)t;
                boolean bl2 = false;
                DebugKt.printDebug(grammar3, n + 2);
            }
        } else if (grammar2 instanceof OrGrammar) {
            DebugKt.printlnWithOffset(n, "OR");
            Iterable iterable = ((OrGrammar)grammar).getGrammars();
            boolean bl = false;
            for (Object t : iterable) {
                Grammar grammar4 = (Grammar)t;
                boolean bl3 = false;
                DebugKt.printDebug(grammar4, n + 2);
            }
        } else if (grammar2 instanceof MaybeGrammar) {
            DebugKt.printlnWithOffset(n, "MAYBE");
            DebugKt.printDebug(((MaybeGrammar)grammar).getGrammar(), n + 2);
        } else if (grammar2 instanceof ManyGrammar) {
            DebugKt.printlnWithOffset(n, "MANY");
            DebugKt.printDebug(((ManyGrammar)grammar).getGrammar(), n + 2);
        } else if (grammar2 instanceof AtLeastOne) {
            DebugKt.printlnWithOffset(n, "MANY_NOT_EMPTY");
            DebugKt.printDebug(((AtLeastOne)grammar).getGrammar(), n + 2);
        } else if (grammar2 instanceof AnyOfGrammar) {
            DebugKt.printlnWithOffset(n, "ANY_OF[" + Regex.Companion.escape(((AnyOfGrammar)grammar).getValue()) + ']');
        } else if (grammar2 instanceof RangeGrammar) {
            DebugKt.printlnWithOffset(n, "RANGE[" + ((RangeGrammar)grammar).getFrom() + '-' + ((RangeGrammar)grammar).getTo() + ']');
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    public static /* synthetic */ void printDebug$default(Grammar grammar, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        DebugKt.printDebug(grammar, n);
    }

    private static final void printlnWithOffset(int n, Object object) {
        System.out.println((Object)(StringsKt.repeat((CharSequence)" ", (int)n) + n / 2 + ": " + object));
    }
}

