/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.exposed.sql.BasicBinaryColumnType;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0096\u0002J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/exposed/sql/BinaryColumnType;", "Lorg/jetbrains/exposed/sql/BasicBinaryColumnType;", "length", "", "(I)V", "getLength", "()I", "equals", "", "other", "", "hashCode", "sqlType", "", "validateValueBeforeUpdate", "", "value", "", "exposed-core"})
public class BinaryColumnType
extends BasicBinaryColumnType {
    private final int length;

    public BinaryColumnType(int n) {
        this.length = n;
    }

    public final int getLength() {
        return this.length;
    }

    @Override
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().binaryType(this.length);
    }

    @Override
    public void validateValueBeforeUpdate(byte[] byArray) {
        int n;
        if (byArray != null && !((n = byArray.length) <= this.length)) {
            boolean bl = false;
            String string = "Value can't be stored to database column because exceeds length (" + n + " > " + this.length + ')';
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        Object object2 = object;
        if (!Intrinsics.areEqual(this.getClass(), object2 != null ? object2.getClass() : null)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)object);
        BinaryColumnType cfr_ignored_0 = (BinaryColumnType)object;
        return this.length == ((BinaryColumnType)object).length;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + this.length;
        return n;
    }
}

