/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.exposed.sql.CurrentOrPreceding;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.SortOrder;
import org.jetbrains.exposed.sql.WindowFrameBound;
import org.jetbrains.exposed.sql.WindowFrameClause;
import org.jetbrains.exposed.sql.WindowFrameUnit;
import org.jetbrains.exposed.sql.WindowFunction;
import org.jetbrains.exposed.sql.WindowFunctionDefinition;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B&\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\b\u00028\u00000\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0013\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015JE\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u000022\u0010\u0018\u001a\u001a\u0012\u0016\b\u0001\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u0004\u0012\u00020\u00100\u000e0\u0019\"\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u0004\u0012\u00020\u00100\u000e\u00a2\u0006\u0002\u0010\u001aJ\"\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u000f2\b\b\u0002\u0010\u0018\u001a\u00020\u0010J-\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u001a\u0010\u001d\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u000f0\u0019\"\u0006\u0012\u0002\b\u00030\u000f\u00a2\u0006\u0002\u0010\u001eJ\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0013\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015J\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0013\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\f\u0010%\u001a\u00020\"*\u00020$H\u0002J\f\u0010&\u001a\u00020\"*\u00020$H\u0002R\u001f\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\b\u00028\u00000\u0004X\u0096\u0004\u00f8\u0001\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u0004\u0012\u00020\u00100\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b9\u00a8\u0006'"}, d2={"Lorg/jetbrains/exposed/sql/WindowFunctionDefinition;", "T", "Lorg/jetbrains/exposed/sql/ExpressionWithColumnType;", "columnType", "Lorg/jetbrains/exposed/sql/IColumnType;", "function", "Lorg/jetbrains/exposed/sql/WindowFunction;", "(Lorg/jetbrains/exposed/sql/IColumnType;Lorg/jetbrains/exposed/sql/WindowFunction;)V", "getColumnType", "()Lorg/jetbrains/exposed/sql/IColumnType;", "frameClause", "Lorg/jetbrains/exposed/sql/WindowFrameClause;", "orderByExpressions", "", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/sql/Expression;", "Lorg/jetbrains/exposed/sql/SortOrder;", "partitionExpressions", "groups", "start", "Lorg/jetbrains/exposed/sql/CurrentOrPreceding;", "Lorg/jetbrains/exposed/sql/WindowFrameBound;", "end", "orderBy", "order", "", "([Lkotlin/Pair;)Lorg/jetbrains/exposed/sql/WindowFunctionDefinition;", "column", "partitionBy", "expressions", "([Lorg/jetbrains/exposed/sql/Expression;)Lorg/jetbrains/exposed/sql/WindowFunctionDefinition;", "range", "rows", "toQueryBuilder", "", "queryBuilder", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "appendOrderByClause", "appendPartitionByClause", "exposed-core"})
public final class WindowFunctionDefinition<T>
extends ExpressionWithColumnType<T> {
    private final IColumnType<T> columnType;
    private final WindowFunction<T> function;
    private final List<Expression<?>> partitionExpressions;
    private final List<Pair<Expression<?>, SortOrder>> orderByExpressions;
    private WindowFrameClause frameClause;

    public WindowFunctionDefinition(IColumnType<T> iColumnType, WindowFunction<T> windowFunction) {
        Intrinsics.checkNotNullParameter(iColumnType, (String)"");
        Intrinsics.checkNotNullParameter(windowFunction, (String)"");
        this.columnType = iColumnType;
        this.function = windowFunction;
        this.partitionExpressions = new ArrayList();
        this.orderByExpressions = new ArrayList();
    }

    @Override
    public IColumnType<T> getColumnType() {
        return this.columnType;
    }

    public final WindowFunctionDefinition<T> partitionBy(Expression<?> ... expressionArray) {
        WindowFunctionDefinition windowFunctionDefinition;
        Intrinsics.checkNotNullParameter(expressionArray, (String)"");
        WindowFunctionDefinition windowFunctionDefinition2 = windowFunctionDefinition = this;
        boolean bl = false;
        List<Expression<?>> list = windowFunctionDefinition2.partitionExpressions;
        Intrinsics.checkNotNull(list);
        CollectionsKt.addAll((Collection)TypeIntrinsics.asMutableList(list), (Object[])expressionArray);
        return windowFunctionDefinition;
    }

    public final WindowFunctionDefinition<T> orderBy(Expression<?> expression, SortOrder sortOrder) {
        Intrinsics.checkNotNullParameter(expression, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOrder), (String)"");
        Pair[] pairArray = new Pair[]{TuplesKt.to(expression, (Object)((Object)sortOrder))};
        return this.orderBy(pairArray);
    }

    public static /* synthetic */ WindowFunctionDefinition orderBy$default(WindowFunctionDefinition windowFunctionDefinition, Expression expression, SortOrder sortOrder, int n, Object object) {
        if ((n & 2) != 0) {
            sortOrder = SortOrder.ASC;
        }
        return windowFunctionDefinition.orderBy(expression, sortOrder);
    }

    public final WindowFunctionDefinition<T> orderBy(Pair<? extends Expression<?>, ? extends SortOrder> ... pairArray) {
        WindowFunctionDefinition windowFunctionDefinition;
        Intrinsics.checkNotNullParameter(pairArray, (String)"");
        WindowFunctionDefinition windowFunctionDefinition2 = windowFunctionDefinition = this;
        boolean bl = false;
        List<Pair<Expression<?>, SortOrder>> list = windowFunctionDefinition2.orderByExpressions;
        Intrinsics.checkNotNull(list);
        CollectionsKt.addAll((Collection)TypeIntrinsics.asMutableList(list), (Object[])pairArray);
        return windowFunctionDefinition;
    }

    public final WindowFunctionDefinition<T> rows(WindowFrameBound windowFrameBound, WindowFrameBound windowFrameBound2) {
        WindowFunctionDefinition windowFunctionDefinition;
        Intrinsics.checkNotNullParameter((Object)windowFrameBound, (String)"");
        Intrinsics.checkNotNullParameter((Object)windowFrameBound2, (String)"");
        WindowFunctionDefinition windowFunctionDefinition2 = windowFunctionDefinition = this;
        boolean bl = false;
        windowFunctionDefinition2.frameClause = new WindowFrameClause(WindowFrameUnit.ROWS, windowFrameBound, windowFrameBound2);
        return windowFunctionDefinition;
    }

    public final WindowFunctionDefinition<T> rows(CurrentOrPreceding currentOrPreceding) {
        WindowFunctionDefinition windowFunctionDefinition;
        Intrinsics.checkNotNullParameter((Object)currentOrPreceding, (String)"");
        WindowFunctionDefinition windowFunctionDefinition2 = windowFunctionDefinition = this;
        boolean bl = false;
        windowFunctionDefinition2.frameClause = new WindowFrameClause(WindowFrameUnit.ROWS, currentOrPreceding, null);
        return windowFunctionDefinition;
    }

    public final WindowFunctionDefinition<T> range(WindowFrameBound windowFrameBound, WindowFrameBound windowFrameBound2) {
        WindowFunctionDefinition windowFunctionDefinition;
        Intrinsics.checkNotNullParameter((Object)windowFrameBound, (String)"");
        Intrinsics.checkNotNullParameter((Object)windowFrameBound2, (String)"");
        WindowFunctionDefinition windowFunctionDefinition2 = windowFunctionDefinition = this;
        boolean bl = false;
        windowFunctionDefinition2.frameClause = new WindowFrameClause(WindowFrameUnit.RANGE, windowFrameBound, windowFrameBound2);
        return windowFunctionDefinition;
    }

    public final WindowFunctionDefinition<T> range(CurrentOrPreceding currentOrPreceding) {
        WindowFunctionDefinition windowFunctionDefinition;
        Intrinsics.checkNotNullParameter((Object)currentOrPreceding, (String)"");
        WindowFunctionDefinition windowFunctionDefinition2 = windowFunctionDefinition = this;
        boolean bl = false;
        windowFunctionDefinition2.frameClause = new WindowFrameClause(WindowFrameUnit.RANGE, currentOrPreceding, null);
        return windowFunctionDefinition;
    }

    public final WindowFunctionDefinition<T> groups(WindowFrameBound windowFrameBound, WindowFrameBound windowFrameBound2) {
        WindowFunctionDefinition windowFunctionDefinition;
        Intrinsics.checkNotNullParameter((Object)windowFrameBound, (String)"");
        Intrinsics.checkNotNullParameter((Object)windowFrameBound2, (String)"");
        WindowFunctionDefinition windowFunctionDefinition2 = windowFunctionDefinition = this;
        boolean bl = false;
        windowFunctionDefinition2.frameClause = new WindowFrameClause(WindowFrameUnit.GROUPS, windowFrameBound, windowFrameBound2);
        return windowFunctionDefinition;
    }

    public final WindowFunctionDefinition<T> groups(CurrentOrPreceding currentOrPreceding) {
        WindowFunctionDefinition windowFunctionDefinition;
        Intrinsics.checkNotNullParameter((Object)currentOrPreceding, (String)"");
        WindowFunctionDefinition windowFunctionDefinition2 = windowFunctionDefinition = this;
        boolean bl = false;
        windowFunctionDefinition2.frameClause = new WindowFrameClause(WindowFrameUnit.GROUPS, currentOrPreceding, null);
        return windowFunctionDefinition;
    }

    @Override
    public void toQueryBuilder(QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(this){
            final /* synthetic */ WindowFunctionDefinition<T> this$0;
            {
                this.this$0 = windowFunctionDefinition;
                super(1);
            }

            public final void invoke(QueryBuilder queryBuilder) {
                Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
                WindowFunctionDefinition.access$getFunction$p(this.this$0).toQueryBuilder(queryBuilder);
                queryBuilder.unaryPlus(" OVER(");
                WindowFunctionDefinition.access$appendPartitionByClause(this.this$0, queryBuilder);
                WindowFunctionDefinition.access$appendOrderByClause(this.this$0, queryBuilder);
                WindowFrameClause windowFrameClause = WindowFunctionDefinition.access$getFrameClause$p(this.this$0);
                if (windowFrameClause != null) {
                    WindowFrameClause windowFrameClause2 = windowFrameClause;
                    boolean bl = false;
                    queryBuilder.unaryPlus(" ");
                    windowFrameClause2.toQueryBuilder(queryBuilder);
                }
                queryBuilder.unaryPlus(")");
            }
        }));
    }

    private final void appendPartitionByClause(QueryBuilder queryBuilder) {
        if (!((Collection)this.partitionExpressions).isEmpty()) {
            queryBuilder.unaryPlus("PARTITION BY ");
            QueryBuilder.appendTo$default(queryBuilder, this.partitionExpressions, null, null, null, (Function2)appendPartitionByClause.1.INSTANCE, 7, null);
        }
    }

    private final void appendOrderByClause(QueryBuilder queryBuilder) {
        if (!((Collection)this.orderByExpressions).isEmpty()) {
            queryBuilder.unaryPlus(" ORDER BY ");
            QueryBuilder.appendTo$default(queryBuilder, this.orderByExpressions, null, null, null, (Function2)appendOrderByClause.1.INSTANCE, 7, null);
        }
    }

    public static final /* synthetic */ WindowFunction access$getFunction$p(WindowFunctionDefinition windowFunctionDefinition) {
        return windowFunctionDefinition.function;
    }

    public static final /* synthetic */ void access$appendPartitionByClause(WindowFunctionDefinition windowFunctionDefinition, QueryBuilder queryBuilder) {
        windowFunctionDefinition.appendPartitionByClause(queryBuilder);
    }

    public static final /* synthetic */ void access$appendOrderByClause(WindowFunctionDefinition windowFunctionDefinition, QueryBuilder queryBuilder) {
        windowFunctionDefinition.appendOrderByClause(queryBuilder);
    }

    public static final /* synthetic */ WindowFrameClause access$getFrameClause$p(WindowFunctionDefinition windowFunctionDefinition) {
        return windowFunctionDefinition.frameClause;
    }
}

