/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnDiff;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.TextColumnType;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DataTypeProvider;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.FunctionProvider;
import org.jetbrains.exposed.sql.vendors.H2DataTypeProvider;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.H2FunctionProvider;
import org.jetbrains.exposed.sql.vendors.MariaDBDialect;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.OracleDialect;
import org.jetbrains.exposed.sql.vendors.PostgreSQLDialect;
import org.jetbrains.exposed.sql.vendors.SQLServerDialect;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b1\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u0016\u0018\u0000 u2\u00020\u0001:\u0003uvwB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010W\u001a\u00020(2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010X\u001a\u00020(2\u0006\u0010Y\u001a\u00020ZH\u0016J\u0010\u0010[\u001a\u00020(2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010\\\u001a\u00020(2\u0006\u0010]\u001a\u00020^H\u0002J3\u0010_\u001a\u0014\u0012\u0004\u0012\u00020a\u0012\n\u0012\b\u0012\u0004\u0012\u00020Z0b0`2\u0012\u0010c\u001a\n\u0012\u0006\b\u0001\u0012\u00020a0d\"\u00020aH\u0016\u00a2\u0006\u0002\u0010eJ\u0014\u0010f\u001a\u00020 2\n\u0010g\u001a\u0006\u0012\u0002\b\u00030hH\u0016J\b\u0010i\u001a\u00020(H\u0016J\"\u0010j\u001a\b\u0012\u0004\u0012\u00020(0b2\n\u0010k\u001a\u0006\u0012\u0002\b\u00030l2\u0006\u0010m\u001a\u00020nH\u0016J\n\u0010o\u001a\u0004\u0018\u00010\u000fH\u0002J\u0010\u0010p\u001a\u00020\n2\u0006\u0010q\u001a\u00020rH\u0016J\u000e\u0010s\u001a\b\u0012\u0004\u0012\u00020(0bH\u0016J\b\u0010t\u001a\u00020(H\u0016R\u001b\u0010\u0003\u001a\u00020\u00048VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\n8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\b\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0010\u001a\u0004\u0018\u00010\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\b\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0015\u001a\u00020\u00168VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\b\u001a\u0004\b\u0017\u0010\u0018R\u001d\u0010\u001a\u001a\u0004\u0018\u00010\u001b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\b\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010!R\u001b\u0010\"\u001a\u00020#8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\b\u001a\u0004\b$\u0010%R\u001b\u0010'\u001a\u00020(8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010\b\u001a\u0004\b)\u0010*R\u001b\u0010,\u001a\u00020 8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010\b\u001a\u0004\b-\u0010!R\u0011\u0010/\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u0006R\u0011\u00101\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u0018R\u001b\u00103\u001a\u00020 8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u0010\b\u001a\u0004\b4\u0010!R\u001b\u00106\u001a\u00020 8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b8\u0010\b\u001a\u0004\b7\u0010!R\u001b\u00109\u001a\u00020 8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b;\u0010\b\u001a\u0004\b:\u0010!R\u001b\u0010<\u001a\u00020 8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b>\u0010\b\u001a\u0004\b=\u0010!R\u001b\u0010?\u001a\u00020 8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bA\u0010\b\u001a\u0004\b@\u0010!R\u001b\u0010B\u001a\u00020 8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bD\u0010\b\u001a\u0004\bC\u0010!R\u001b\u0010E\u001a\u00020 8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bG\u0010\b\u001a\u0004\bF\u0010!R\u001b\u0010H\u001a\u00020 8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bJ\u0010\b\u001a\u0004\bI\u0010!R\u001b\u0010K\u001a\u00020 8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bM\u0010\b\u001a\u0004\bL\u0010!R\u001b\u0010N\u001a\u00020 8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bP\u0010\b\u001a\u0004\bO\u0010!R\u001b\u0010Q\u001a\u00020 8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bS\u0010\b\u001a\u0004\bR\u0010!R\u001b\u0010T\u001a\u00020(8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\bV\u0010\b\u001a\u0004\bU\u0010*\u00a8\u0006x"}, d2={"Lorg/jetbrains/exposed/sql/vendors/H2Dialect;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "()V", "dataTypeProvider", "Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "getDataTypeProvider", "()Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "dataTypeProvider$delegate", "Lkotlin/Lazy;", "defaultReferenceOption", "Lorg/jetbrains/exposed/sql/ReferenceOption;", "getDefaultReferenceOption", "()Lorg/jetbrains/exposed/sql/ReferenceOption;", "defaultReferenceOption$delegate", "delegatedDialect", "Lorg/jetbrains/exposed/sql/vendors/DatabaseDialect;", "delegatedDialectNameProvider", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect$DialectNameProvider;", "getDelegatedDialectNameProvider", "()Lorg/jetbrains/exposed/sql/vendors/VendorDialect$DialectNameProvider;", "delegatedDialectNameProvider$delegate", "functionProvider", "Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "getFunctionProvider", "()Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "functionProvider$delegate", "h2Mode", "Lorg/jetbrains/exposed/sql/vendors/H2Dialect$H2CompatibilityMode;", "getH2Mode", "()Lorg/jetbrains/exposed/sql/vendors/H2Dialect$H2CompatibilityMode;", "h2Mode$delegate", "isSecondVersion", "", "()Z", "majorVersion", "Lorg/jetbrains/exposed/sql/vendors/H2Dialect$H2MajorVersion;", "getMajorVersion$exposed_core", "()Lorg/jetbrains/exposed/sql/vendors/H2Dialect$H2MajorVersion;", "majorVersion$delegate", "name", "", "getName", "()Ljava/lang/String;", "name$delegate", "needsSequenceToAutoInc", "getNeedsSequenceToAutoInc", "needsSequenceToAutoInc$delegate", "originalDataTypeProvider", "getOriginalDataTypeProvider", "originalFunctionProvider", "getOriginalFunctionProvider", "supportsCreateSchema", "getSupportsCreateSchema", "supportsCreateSchema$delegate", "supportsCreateSequence", "getSupportsCreateSequence", "supportsCreateSequence$delegate", "supportsDualTableConcept", "getSupportsDualTableConcept", "supportsDualTableConcept$delegate", "supportsIfNotExists", "getSupportsIfNotExists", "supportsIfNotExists$delegate", "supportsMultipleGeneratedKeys", "getSupportsMultipleGeneratedKeys", "supportsMultipleGeneratedKeys$delegate", "supportsOnlyIdentifiersInGeneratedKeys", "getSupportsOnlyIdentifiersInGeneratedKeys", "supportsOnlyIdentifiersInGeneratedKeys$delegate", "supportsOrderByNullsFirstLast", "getSupportsOrderByNullsFirstLast", "supportsOrderByNullsFirstLast$delegate", "supportsSequenceAsGeneratedKeys", "getSupportsSequenceAsGeneratedKeys", "supportsSequenceAsGeneratedKeys$delegate", "supportsSubqueryUnions", "getSupportsSubqueryUnions", "supportsSubqueryUnions$delegate", "supportsTernaryAffectedRowValues", "getSupportsTernaryAffectedRowValues", "supportsTernaryAffectedRowValues$delegate", "supportsWindowFrameGroupsMode", "getSupportsWindowFrameGroupsMode", "supportsWindowFrameGroupsMode$delegate", "version", "getVersion$exposed_core", "version$delegate", "createDatabase", "createIndex", "index", "Lorg/jetbrains/exposed/sql/Index;", "dropDatabase", "exactH2Version", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "existingIndices", "", "Lorg/jetbrains/exposed/sql/Table;", "", "tables", "", "([Lorg/jetbrains/exposed/sql/Table;)Ljava/util/Map;", "isAllowedAsColumnDefault", "e", "Lorg/jetbrains/exposed/sql/Expression;", "listDatabases", "modifyColumn", "column", "Lorg/jetbrains/exposed/sql/Column;", "columnDiff", "Lorg/jetbrains/exposed/sql/ColumnDiff;", "resolveDelegatedDialect", "resolveRefOptionFromJdbc", "refOption", "", "sequences", "toString", "Companion", "H2CompatibilityMode", "H2MajorVersion", "exposed-core"})
public class H2Dialect
extends VendorDialect {
    public static final Companion Companion = new Companion(null);
    private final Lazy version$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
        final /* synthetic */ H2Dialect this$0;
        {
            this.this$0 = h2Dialect;
            super(0);
        }

        public final String invoke() {
            return H2Dialect.access$exactH2Version(this.this$0, TransactionManager.Companion.current());
        }
    }));
    private final Lazy majorVersion$delegate = LazyKt.lazy((Function0)((Function0)new Function0<H2MajorVersion>(this){
        final /* synthetic */ H2Dialect this$0;
        {
            this.this$0 = h2Dialect;
            super(0);
        }

        public final H2MajorVersion invoke() {
            H2MajorVersion h2MajorVersion;
            if (StringsKt.startsWith$default((String)this.this$0.getVersion$exposed_core(), (String)"1.", (boolean)false, (int)2, null)) {
                h2MajorVersion = H2MajorVersion.One;
            } else if (StringsKt.startsWith$default((String)this.this$0.getVersion$exposed_core(), (String)"2.", (boolean)false, (int)2, null)) {
                h2MajorVersion = H2MajorVersion.Two;
            } else {
                throw new IllegalStateException(("Unsupported H2 version: " + this.this$0.getVersion$exposed_core()).toString());
            }
            return h2MajorVersion;
        }
    }));
    private final Lazy delegatedDialectNameProvider$delegate = LazyKt.lazy((Function0)((Function0)new Function0<VendorDialect.DialectNameProvider>(this){
        final /* synthetic */ H2Dialect this$0;
        {
            this.this$0 = h2Dialect;
            super(0);
        }

        public final VendorDialect.DialectNameProvider invoke() {
            VendorDialect.DialectNameProvider dialectNameProvider;
            H2CompatibilityMode h2CompatibilityMode = this.this$0.getH2Mode();
            switch (h2CompatibilityMode == null ? -1 : delegatedDialectNameProvider.WhenMappings.$EnumSwitchMapping$0[h2CompatibilityMode.ordinal()]) {
                case 1: {
                    dialectNameProvider = MysqlDialect.Companion;
                    break;
                }
                case 2: {
                    dialectNameProvider = MariaDBDialect.Companion;
                    break;
                }
                case 3: {
                    dialectNameProvider = PostgreSQLDialect.Companion;
                    break;
                }
                case 4: {
                    dialectNameProvider = OracleDialect.Companion;
                    break;
                }
                case 5: {
                    dialectNameProvider = SQLServerDialect.Companion;
                    break;
                }
                default: {
                    dialectNameProvider = null;
                }
            }
            return dialectNameProvider;
        }
    }));
    private DatabaseDialect delegatedDialect;
    private final FunctionProvider originalFunctionProvider = H2FunctionProvider.INSTANCE;
    private final Lazy functionProvider$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FunctionProvider>(this){
        final /* synthetic */ H2Dialect this$0;
        {
            this.this$0 = h2Dialect;
            super(0);
        }

        public final FunctionProvider invoke() {
            Object object;
            block3: {
                block2: {
                    DatabaseDialect databaseDialect;
                    object = H2Dialect.access$resolveDelegatedDialect(this.this$0);
                    if (object == null) break block2;
                    DatabaseDialect databaseDialect2 = databaseDialect = object;
                    boolean bl = false;
                    object = !(databaseDialect2 instanceof MysqlDialect) ? databaseDialect : null;
                    if (object != null && (object = object.getFunctionProvider()) != null) break block3;
                }
                object = this.this$0.getOriginalFunctionProvider();
            }
            return object;
        }
    }));
    private final DataTypeProvider originalDataTypeProvider = H2DataTypeProvider.INSTANCE;
    private final Lazy dataTypeProvider$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DataTypeProvider>(this){
        final /* synthetic */ H2Dialect this$0;
        {
            this.this$0 = h2Dialect;
            super(0);
        }

        public final DataTypeProvider invoke() {
            Object object;
            block3: {
                block2: {
                    DatabaseDialect databaseDialect;
                    object = H2Dialect.access$resolveDelegatedDialect(this.this$0);
                    if (object == null) break block2;
                    DatabaseDialect databaseDialect2 = databaseDialect = object;
                    boolean bl = false;
                    object = !(databaseDialect2 instanceof MysqlDialect) ? databaseDialect : null;
                    if (object != null && (object = object.getDataTypeProvider()) != null) break block3;
                }
                object = this.this$0.getOriginalDataTypeProvider();
            }
            return object;
        }
    }));
    private final Lazy h2Mode$delegate = LazyKt.lazy((Function0)((Function0)new Function0<H2CompatibilityMode>(this){
        final /* synthetic */ H2Dialect this$0;
        {
            this.this$0 = h2Dialect;
            super(0);
        }

        public final H2CompatibilityMode invoke() {
            Pair pair;
            switch (h2Mode.WhenMappings.$EnumSwitchMapping$0[this.this$0.getMajorVersion$exposed_core().ordinal()]) {
                case 1: {
                    pair = TuplesKt.to((Object)"NAME", (Object)"VALUE");
                    break;
                }
                case 2: {
                    pair = TuplesKt.to((Object)"SETTING_NAME", (Object)"SETTING_VALUE");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Pair pair2 = pair;
            String string = (String)pair2.component1();
            String string2 = (String)pair2.component2();
            String string3 = "SELECT " + string2 + " FROM INFORMATION_SCHEMA.SETTINGS WHERE " + string + " = 'MODE'";
            String string4 = (String)Transaction.exec$default(TransactionManager.Companion.current(), string3, null, null, (Function1)new Function1<ResultSet, String>(string2){
                final /* synthetic */ String $settingValueField;
                {
                    this.$settingValueField = string;
                    super(1);
                }

                public final String invoke(ResultSet resultSet) {
                    Intrinsics.checkNotNullParameter((Object)resultSet, (String)"");
                    resultSet.next();
                    return resultSet.getString(this.$settingValueField);
                }
            }, 6, null);
            return string4 == null ? null : (StringsKt.equals((String)string4, (String)"MySQL", (boolean)true) ? H2CompatibilityMode.MySQL : (StringsKt.equals((String)string4, (String)"MariaDB", (boolean)true) ? H2CompatibilityMode.MariaDB : (StringsKt.equals((String)string4, (String)"MSSQLServer", (boolean)true) ? H2CompatibilityMode.SQLServer : (StringsKt.equals((String)string4, (String)"Oracle", (boolean)true) ? H2CompatibilityMode.Oracle : (StringsKt.equals((String)string4, (String)"PostgreSQL", (boolean)true) ? H2CompatibilityMode.PostgreSQL : null)))));
        }
    }));
    private final Lazy name$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
        final /* synthetic */ H2Dialect this$0;
        {
            this.this$0 = h2Dialect;
            super(0);
        }

        public final String invoke() {
            String string;
            H2CompatibilityMode h2CompatibilityMode = this.this$0.getH2Mode();
            if ((h2CompatibilityMode == null ? -1 : name.WhenMappings.$EnumSwitchMapping$0[h2CompatibilityMode.ordinal()]) == -1) {
                string = H2Dialect.Companion.getDialectName();
            } else {
                StringBuilder stringBuilder = new StringBuilder().append(H2Dialect.Companion.getDialectName()).append(" (");
                H2CompatibilityMode h2CompatibilityMode2 = this.this$0.getH2Mode();
                Intrinsics.checkNotNull((Object)((Object)h2CompatibilityMode2));
                string = stringBuilder.append(h2CompatibilityMode2.name()).append(" Mode)").toString();
            }
            return string;
        }
    }));
    private final Lazy supportsMultipleGeneratedKeys$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
        final /* synthetic */ H2Dialect this$0;
        {
            this.this$0 = h2Dialect;
            super(0);
        }

        public final Boolean invoke() {
            DatabaseDialect databaseDialect = H2Dialect.access$resolveDelegatedDialect(this.this$0);
            return databaseDialect != null ? databaseDialect.getSupportsMultipleGeneratedKeys() : false;
        }
    }));
    private final Lazy supportsOnlyIdentifiersInGeneratedKeys$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
        final /* synthetic */ H2Dialect this$0;
        {
            this.this$0 = h2Dialect;
            super(0);
        }

        public final Boolean invoke() {
            DatabaseDialect databaseDialect = H2Dialect.access$resolveDelegatedDialect(this.this$0);
            return databaseDialect != null ? databaseDialect.getSupportsOnlyIdentifiersInGeneratedKeys() : true;
        }
    }));
    private final Lazy supportsIfNotExists$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
        final /* synthetic */ H2Dialect this$0;
        {
            this.this$0 = h2Dialect;
            super(0);
        }

        public final Boolean invoke() {
            DatabaseDialect databaseDialect = H2Dialect.access$resolveDelegatedDialect(this.this$0);
            return databaseDialect != null ? databaseDialect.getSupportsIfNotExists() : H2Dialect.access$getSupportsIfNotExists$s-505436258(this.this$0);
        }
    }));
    private final Lazy supportsCreateSequence$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
        final /* synthetic */ H2Dialect this$0;
        {
            this.this$0 = h2Dialect;
            super(0);
        }

        public final Boolean invoke() {
            DatabaseDialect databaseDialect = H2Dialect.access$resolveDelegatedDialect(this.this$0);
            return databaseDialect != null ? databaseDialect.getSupportsCreateSequence() : H2Dialect.access$getSupportsCreateSequence$s-505436258(this.this$0);
        }
    }));
    private final Lazy needsSequenceToAutoInc$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
        final /* synthetic */ H2Dialect this$0;
        {
            this.this$0 = h2Dialect;
            super(0);
        }

        public final Boolean invoke() {
            DatabaseDialect databaseDialect = H2Dialect.access$resolveDelegatedDialect(this.this$0);
            return databaseDialect != null ? databaseDialect.getNeedsSequenceToAutoInc() : H2Dialect.access$getNeedsSequenceToAutoInc$s-505436258(this.this$0);
        }
    }));
    private final Lazy defaultReferenceOption$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ReferenceOption>(this){
        final /* synthetic */ H2Dialect this$0;
        {
            this.this$0 = h2Dialect;
            super(0);
        }

        public final ReferenceOption invoke() {
            Object object = H2Dialect.access$resolveDelegatedDialect(this.this$0);
            if (object == null || (object = object.getDefaultReferenceOption()) == null) {
                object = H2Dialect.access$getDefaultReferenceOption$s-505436258(this.this$0);
            }
            return object;
        }
    }));
    private final Lazy supportsSequenceAsGeneratedKeys$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
        final /* synthetic */ H2Dialect this$0;
        {
            this.this$0 = h2Dialect;
            super(0);
        }

        public final Boolean invoke() {
            DatabaseDialect databaseDialect = H2Dialect.access$resolveDelegatedDialect(this.this$0);
            return databaseDialect != null ? databaseDialect.getSupportsSequenceAsGeneratedKeys() : H2Dialect.access$getSupportsSequenceAsGeneratedKeys$s-505436258(this.this$0);
        }
    }));
    private final Lazy supportsTernaryAffectedRowValues$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
        final /* synthetic */ H2Dialect this$0;
        {
            this.this$0 = h2Dialect;
            super(0);
        }

        public final Boolean invoke() {
            DatabaseDialect databaseDialect = H2Dialect.access$resolveDelegatedDialect(this.this$0);
            return databaseDialect != null ? databaseDialect.getSupportsTernaryAffectedRowValues() : H2Dialect.access$getSupportsTernaryAffectedRowValues$s-505436258(this.this$0);
        }
    }));
    private final Lazy supportsCreateSchema$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
        final /* synthetic */ H2Dialect this$0;
        {
            this.this$0 = h2Dialect;
            super(0);
        }

        public final Boolean invoke() {
            DatabaseDialect databaseDialect = H2Dialect.access$resolveDelegatedDialect(this.this$0);
            return databaseDialect != null ? databaseDialect.getSupportsCreateSchema() : H2Dialect.access$getSupportsCreateSchema$s-505436258(this.this$0);
        }
    }));
    private final Lazy supportsSubqueryUnions$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
        final /* synthetic */ H2Dialect this$0;
        {
            this.this$0 = h2Dialect;
            super(0);
        }

        public final Boolean invoke() {
            DatabaseDialect databaseDialect = H2Dialect.access$resolveDelegatedDialect(this.this$0);
            return databaseDialect != null ? databaseDialect.getSupportsSubqueryUnions() : H2Dialect.access$getSupportsSubqueryUnions$s-505436258(this.this$0);
        }
    }));
    private final Lazy supportsDualTableConcept$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
        final /* synthetic */ H2Dialect this$0;
        {
            this.this$0 = h2Dialect;
            super(0);
        }

        public final Boolean invoke() {
            DatabaseDialect databaseDialect = H2Dialect.access$resolveDelegatedDialect(this.this$0);
            return databaseDialect != null ? databaseDialect.getSupportsDualTableConcept() : H2Dialect.access$getSupportsDualTableConcept$s-505436258(this.this$0);
        }
    }));
    private final Lazy supportsOrderByNullsFirstLast$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
        final /* synthetic */ H2Dialect this$0;
        {
            this.this$0 = h2Dialect;
            super(0);
        }

        public final Boolean invoke() {
            DatabaseDialect databaseDialect = H2Dialect.access$resolveDelegatedDialect(this.this$0);
            return databaseDialect != null ? databaseDialect.getSupportsOrderByNullsFirstLast() : H2Dialect.access$getSupportsOrderByNullsFirstLast$s-505436258(this.this$0);
        }
    }));
    private final Lazy supportsWindowFrameGroupsMode$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
        final /* synthetic */ H2Dialect this$0;
        {
            this.this$0 = h2Dialect;
            super(0);
        }

        public final Boolean invoke() {
            DatabaseDialect databaseDialect = H2Dialect.access$resolveDelegatedDialect(this.this$0);
            return databaseDialect != null ? databaseDialect.getSupportsWindowFrameGroupsMode() : H2Dialect.access$getSupportsWindowFrameGroupsMode$s-505436258(this.this$0);
        }
    }));

    public H2Dialect() {
        super(Companion.getDialectName(), H2DataTypeProvider.INSTANCE, H2FunctionProvider.INSTANCE);
    }

    public String toString() {
        return "H2Dialect[" + Companion.getDialectName() + ", " + (Object)((Object)this.getH2Mode()) + ']';
    }

    public final String getVersion$exposed_core() {
        Lazy lazy = this.version$delegate;
        return (String)lazy.getValue();
    }

    public final H2MajorVersion getMajorVersion$exposed_core() {
        Lazy lazy = this.majorVersion$delegate;
        return (H2MajorVersion)((Object)lazy.getValue());
    }

    public final boolean isSecondVersion() {
        return this.getMajorVersion$exposed_core() == H2MajorVersion.Two;
    }

    private final String exactH2Version(Transaction transaction2) {
        return (String)transaction2.getDb().metadata$exposed_core(exactH2Version.1.INSTANCE);
    }

    public final VendorDialect.DialectNameProvider getDelegatedDialectNameProvider() {
        Lazy lazy = this.delegatedDialectNameProvider$delegate;
        return (VendorDialect.DialectNameProvider)lazy.getValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final DatabaseDialect resolveDelegatedDialect() {
        Object object;
        Object object3 = this.delegatedDialect;
        object3 = object3;
        if (object2 != null) return object3;
        VendorDialect.DialectNameProvider dialectNameProvider = this.getDelegatedDialectNameProvider();
        Object object4 = dialectNameProvider;
        if (dialectNameProvider == null) return null;
        String string = ((VendorDialect.DialectNameProvider)object4).getDialectName();
        object4 = string;
        if (string == null) return null;
        String string2 = ((String)object4).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        object4 = string2;
        if (string2 == null) return null;
        Object object5 = object4;
        boolean bl = false;
        Function0<DatabaseDialect> function0 = Database.Companion.getDialects$exposed_core().get(object5);
        Object object6 = function0;
        if (function0 == null) throw new IllegalStateException(("Can't resolve dialect for " + (String)object5).toString());
        if ((object6 = (DatabaseDialect)object6.invoke()) == null) {
            throw new IllegalStateException(("Can't resolve dialect for " + (String)object5).toString());
        }
        this.delegatedDialect = object = object6;
        object3 = object;
        return object3;
    }

    public final FunctionProvider getOriginalFunctionProvider() {
        return this.originalFunctionProvider;
    }

    @Override
    public FunctionProvider getFunctionProvider() {
        Lazy lazy = this.functionProvider$delegate;
        return (FunctionProvider)lazy.getValue();
    }

    public final DataTypeProvider getOriginalDataTypeProvider() {
        return this.originalDataTypeProvider;
    }

    @Override
    public DataTypeProvider getDataTypeProvider() {
        Lazy lazy = this.dataTypeProvider$delegate;
        return (DataTypeProvider)lazy.getValue();
    }

    public final H2CompatibilityMode getH2Mode() {
        Lazy lazy = this.h2Mode$delegate;
        return (H2CompatibilityMode)((Object)lazy.getValue());
    }

    @Override
    public String getName() {
        Lazy lazy = this.name$delegate;
        return (String)lazy.getValue();
    }

    @Override
    public boolean getSupportsMultipleGeneratedKeys() {
        Lazy lazy = this.supportsMultipleGeneratedKeys$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    public boolean getSupportsOnlyIdentifiersInGeneratedKeys() {
        Lazy lazy = this.supportsOnlyIdentifiersInGeneratedKeys$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    public boolean getSupportsIfNotExists() {
        Lazy lazy = this.supportsIfNotExists$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    public boolean getSupportsCreateSequence() {
        Lazy lazy = this.supportsCreateSequence$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    public boolean getNeedsSequenceToAutoInc() {
        Lazy lazy = this.needsSequenceToAutoInc$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    public ReferenceOption getDefaultReferenceOption() {
        Lazy lazy = this.defaultReferenceOption$delegate;
        return (ReferenceOption)((Object)lazy.getValue());
    }

    @Override
    public boolean getSupportsSequenceAsGeneratedKeys() {
        Lazy lazy = this.supportsSequenceAsGeneratedKeys$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    public boolean getSupportsTernaryAffectedRowValues() {
        Lazy lazy = this.supportsTernaryAffectedRowValues$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    public boolean getSupportsCreateSchema() {
        Lazy lazy = this.supportsCreateSchema$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    public boolean getSupportsSubqueryUnions() {
        Lazy lazy = this.supportsSubqueryUnions$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    public boolean getSupportsDualTableConcept() {
        Lazy lazy = this.supportsDualTableConcept$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    public boolean getSupportsOrderByNullsFirstLast() {
        Lazy lazy = this.supportsOrderByNullsFirstLast$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    public boolean getSupportsWindowFrameGroupsMode() {
        Lazy lazy = this.supportsWindowFrameGroupsMode$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    public Map<Table, List<Index>> existingIndices(Table ... tableArray) {
        Intrinsics.checkNotNullParameter((Object)tableArray, (String)"");
        LinkedHashMap linkedHashMap = super.existingIndices(Arrays.copyOf(tableArray, tableArray.length));
        boolean bl = false;
        LinkedHashMap linkedHashMap2 = linkedHashMap;
        LinkedHashMap linkedHashMap3 = new LinkedHashMap(MapsKt.mapCapacity((int)linkedHashMap.size()));
        boolean bl2 = false;
        Iterable iterable = linkedHashMap2.entrySet();
        boolean bl3 = false;
        for (Object t : iterable) {
            Map.Entry entry = (Map.Entry)t;
            LinkedHashMap linkedHashMap4 = linkedHashMap3;
            boolean bl4 = false;
            Map.Entry entry2 = (Map.Entry)t;
            Object k = entry.getKey();
            LinkedHashMap linkedHashMap5 = linkedHashMap4;
            boolean bl5 = false;
            Iterable iterable2 = (Iterable)entry2.getValue();
            boolean bl6 = false;
            Iterable iterable3 = iterable2;
            Collection collection = new ArrayList();
            boolean bl7 = false;
            for (Object t2 : iterable3) {
                Index index = (Index)t2;
                boolean bl8 = false;
                if (StringsKt.startsWith$default((String)index.getIndexName(), (String)"PRIMARY_KEY_", (boolean)false, (int)2, null)) continue;
                collection.add(t2);
            }
            List list = (List)collection;
            linkedHashMap5.put(k, list);
        }
        linkedHashMap = linkedHashMap3;
        bl = false;
        linkedHashMap2 = new LinkedHashMap();
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            iterable = (List)entry.getValue();
            bl3 = false;
            boolean bl4 = !((Collection)iterable).isEmpty();
            if (!bl4) continue;
            linkedHashMap2.put(entry.getKey(), (List)entry.getValue());
        }
        return linkedHashMap2;
    }

    @Override
    public boolean isAllowedAsColumnDefault(Expression<?> expression) {
        Intrinsics.checkNotNullParameter(expression, (String)"");
        return true;
    }

    @Override
    public String createIndex(Index index) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"");
        if (this.getMajorVersion$exposed_core() == H2MajorVersion.One || this.getH2Mode() == H2CompatibilityMode.Oracle) {
            boolean bl;
            block7: {
                Iterable iterable = index.getColumns();
                boolean bl2 = false;
                if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                    bl = false;
                } else {
                    for (Object t : iterable) {
                        Column column = (Column)t;
                        boolean bl3 = false;
                        if (!(column.getColumnType() instanceof TextColumnType)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (bl) {
                SQLLogKt.getExposedLogger().warn("Index on " + index.getTable().getTableName() + " for " + CollectionsKt.joinToString$default((Iterable)index.getColumns(), null, null, null, (int)0, null, (Function1)createIndex.2.INSTANCE, (int)31, null) + " can't be created on CLOB in H2");
                return "";
            }
        }
        if (index.getIndexType() != null) {
            SQLLogKt.getExposedLogger().warn("Index of type " + index.getIndexType() + " on " + index.getTable().getTableName() + " for " + CollectionsKt.joinToString$default((Iterable)index.getColumns(), null, null, null, (int)0, null, (Function1)createIndex.3.INSTANCE, (int)31, null) + " can't be created in H2");
            return "";
        }
        if (index.getFunctions() != null) {
            SQLLogKt.getExposedLogger().warn("Functional index on " + index.getTable().getTableName() + " using " + CollectionsKt.joinToString$default((Iterable)index.getFunctions(), null, null, null, (int)0, null, (Function1)createIndex.4.INSTANCE, (int)31, null) + " can't be created in H2");
            return "";
        }
        return super.createIndex(index);
    }

    @Override
    public String createDatabase(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return "CREATE SCHEMA IF NOT EXISTS " + DatabaseDialectKt.inProperCase(string);
    }

    @Override
    public String listDatabases() {
        return "SHOW SCHEMAS";
    }

    @Override
    public List<String> modifyColumn(Column<?> column, ColumnDiff columnDiff) {
        Intrinsics.checkNotNullParameter(column, (String)"");
        Intrinsics.checkNotNullParameter((Object)columnDiff, (String)"");
        Iterable iterable = super.modifyColumn(column, columnDiff);
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t : iterable2) {
            String string = (String)t;
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(StringsKt.replace$default((String)string, (String)"MODIFY COLUMN", (String)"ALTER COLUMN", (boolean)false, (int)4, null));
        }
        return (List)collection;
    }

    @Override
    public String dropDatabase(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return "DROP SCHEMA IF EXISTS " + DatabaseDialectKt.inProperCase(string);
    }

    @Override
    public ReferenceOption resolveRefOptionFromJdbc(int n) {
        boolean bl = this.getH2Mode() == H2CompatibilityMode.Oracle || this.getH2Mode() == H2CompatibilityMode.SQLServer;
        return n == 1 && bl ? ReferenceOption.NO_ACTION : (n == 1 ? ReferenceOption.RESTRICT : super.resolveRefOptionFromJdbc(n));
    }

    @Override
    public List<String> sequences() {
        List list = new ArrayList();
        Transaction.exec$default(TransactionManager.Companion.current(), "SELECT SEQUENCE_NAME FROM INFORMATION_SCHEMA.SEQUENCES", null, null, (Function1)new Function1<ResultSet, Unit>((List<String>)list){
            final /* synthetic */ List<String> $sequences;
            {
                this.$sequences = list;
                super(1);
            }

            public final void invoke(ResultSet resultSet) {
                Intrinsics.checkNotNullParameter((Object)resultSet, (String)"");
                while (resultSet.next()) {
                    String string = resultSet.getString("SEQUENCE_NAME");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                    this.$sequences.add(string);
                }
            }
        }, 6, null);
        return list;
    }

    public static final /* synthetic */ String access$exactH2Version(H2Dialect h2Dialect, Transaction transaction2) {
        return h2Dialect.exactH2Version(transaction2);
    }

    public static final /* synthetic */ DatabaseDialect access$resolveDelegatedDialect(H2Dialect h2Dialect) {
        return h2Dialect.resolveDelegatedDialect();
    }

    public static final /* synthetic */ boolean access$getSupportsIfNotExists$s-505436258(H2Dialect h2Dialect) {
        return super.getSupportsIfNotExists();
    }

    public static final /* synthetic */ boolean access$getSupportsCreateSequence$s-505436258(H2Dialect h2Dialect) {
        return super.getSupportsCreateSequence();
    }

    public static final /* synthetic */ boolean access$getNeedsSequenceToAutoInc$s-505436258(H2Dialect h2Dialect) {
        return super.getNeedsSequenceToAutoInc();
    }

    public static final /* synthetic */ ReferenceOption access$getDefaultReferenceOption$s-505436258(H2Dialect h2Dialect) {
        return super.getDefaultReferenceOption();
    }

    public static final /* synthetic */ boolean access$getSupportsSequenceAsGeneratedKeys$s-505436258(H2Dialect h2Dialect) {
        return super.getSupportsSequenceAsGeneratedKeys();
    }

    public static final /* synthetic */ boolean access$getSupportsTernaryAffectedRowValues$s-505436258(H2Dialect h2Dialect) {
        return super.getSupportsTernaryAffectedRowValues();
    }

    public static final /* synthetic */ boolean access$getSupportsCreateSchema$s-505436258(H2Dialect h2Dialect) {
        return super.getSupportsCreateSchema();
    }

    public static final /* synthetic */ boolean access$getSupportsSubqueryUnions$s-505436258(H2Dialect h2Dialect) {
        return super.getSupportsSubqueryUnions();
    }

    public static final /* synthetic */ boolean access$getSupportsDualTableConcept$s-505436258(H2Dialect h2Dialect) {
        return super.getSupportsDualTableConcept();
    }

    public static final /* synthetic */ boolean access$getSupportsOrderByNullsFirstLast$s-505436258(H2Dialect h2Dialect) {
        return super.getSupportsOrderByNullsFirstLast();
    }

    public static final /* synthetic */ boolean access$getSupportsWindowFrameGroupsMode$s-505436258(H2Dialect h2Dialect) {
        return super.getSupportsWindowFrameGroupsMode();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/exposed/sql/vendors/H2Dialect$Companion;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect$DialectNameProvider;", "()V", "exposed-core"})
    public static final class Companion
    extends VendorDialect.DialectNameProvider {
        private Companion() {
            super("H2");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/exposed/sql/vendors/H2Dialect$H2CompatibilityMode;", "", "(Ljava/lang/String;I)V", "MySQL", "MariaDB", "SQLServer", "Oracle", "PostgreSQL", "exposed-core"})
    public static final class H2CompatibilityMode
    extends Enum<H2CompatibilityMode> {
        public static final /* enum */ H2CompatibilityMode MySQL = new H2CompatibilityMode();
        public static final /* enum */ H2CompatibilityMode MariaDB = new H2CompatibilityMode();
        public static final /* enum */ H2CompatibilityMode SQLServer = new H2CompatibilityMode();
        public static final /* enum */ H2CompatibilityMode Oracle = new H2CompatibilityMode();
        public static final /* enum */ H2CompatibilityMode PostgreSQL = new H2CompatibilityMode();
        private static final /* synthetic */ H2CompatibilityMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static H2CompatibilityMode[] values() {
            return (H2CompatibilityMode[])$VALUES.clone();
        }

        public static H2CompatibilityMode valueOf(String string) {
            return Enum.valueOf(H2CompatibilityMode.class, string);
        }

        public static EnumEntries<H2CompatibilityMode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = h2CompatibilityModeArray = new H2CompatibilityMode[]{H2CompatibilityMode.MySQL, H2CompatibilityMode.MariaDB, H2CompatibilityMode.SQLServer, H2CompatibilityMode.Oracle, H2CompatibilityMode.PostgreSQL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/exposed/sql/vendors/H2Dialect$H2MajorVersion;", "", "(Ljava/lang/String;I)V", "One", "Two", "exposed-core"})
    public static final class H2MajorVersion
    extends Enum<H2MajorVersion> {
        public static final /* enum */ H2MajorVersion One = new H2MajorVersion();
        public static final /* enum */ H2MajorVersion Two = new H2MajorVersion();
        private static final /* synthetic */ H2MajorVersion[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static H2MajorVersion[] values() {
            return (H2MajorVersion[])$VALUES.clone();
        }

        public static H2MajorVersion valueOf(String string) {
            return Enum.valueOf(H2MajorVersion.class, string);
        }

        public static EnumEntries<H2MajorVersion> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = h2MajorVersionArray = new H2MajorVersion[]{H2MajorVersion.One, H2MajorVersion.Two};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

