/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.exposed.exceptions.UnsupportedByDialectException;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ForeignKeyConstraint;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.SchemaUtils;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.MariaDBDialect;
import org.jetbrains.exposed.sql.vendors.MysqlDataTypeProvider;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.MysqlFunctionProvider;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 22\u00020\u0001:\u00012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J(\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\nH\u0016J\u0018\u0010#\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\nH\u0016J\u0016\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0014J\u0014\u0010*\u001a\u00020\n2\n\u0010+\u001a\u0006\u0012\u0002\b\u00030,H\u0016J\u0006\u0010-\u001a\u00020\nJ\u0006\u0010.\u001a\u00020\nJ\u0010\u0010/\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u001c\u00100\u001a\u00020\n*\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u00101\u001a\u00020)H\u0014R\u001b\u0010\u0003\u001a\u00020\u00048@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\n8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\b\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u000e\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0014\u0010\u0010\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0014\u0010\u0012\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\fR\u0014\u0010\u0014\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\fR\u0014\u0010\u0016\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\f\u00a8\u00063"}, d2={"Lorg/jetbrains/exposed/sql/vendors/MysqlDialect;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "()V", "fullVersion", "", "getFullVersion$exposed_core", "()Ljava/lang/String;", "fullVersion$delegate", "Lkotlin/Lazy;", "isMysql8", "", "isMysql8$exposed_core", "()Z", "isMysql8$delegate", "supportsCreateSequence", "getSupportsCreateSequence", "supportsOrderByNullsFirstLast", "getSupportsOrderByNullsFirstLast", "supportsSetDefaultReferenceOption", "getSupportsSetDefaultReferenceOption", "supportsSubqueryUnions", "getSupportsSubqueryUnions", "supportsTernaryAffectedRowValues", "getSupportsTernaryAffectedRowValues", "createIndex", "index", "Lorg/jetbrains/exposed/sql/Index;", "createSchema", "schema", "Lorg/jetbrains/exposed/sql/Schema;", "dropIndex", "tableName", "indexName", "isUnique", "isPartialOrFunctional", "dropSchema", "cascade", "fillConstraintCacheForTables", "", "tables", "", "Lorg/jetbrains/exposed/sql/Table;", "isAllowedAsColumnDefault", "e", "Lorg/jetbrains/exposed/sql/Expression;", "isFractionDateTimeSupported", "isTimeZoneOffsetSupported", "setSchema", "metadataMatchesTable", "table", "Companion", "exposed-core"})
public class MysqlDialect
extends VendorDialect {
    public static final Companion Companion = new Companion(null);
    private final Lazy isMysql8$delegate = LazyKt.lazy((Function0)isMysql8.2.INSTANCE);
    private final Lazy fullVersion$delegate = LazyKt.lazy((Function0)fullVersion.2.INSTANCE);
    private final boolean supportsCreateSequence;
    private final boolean supportsTernaryAffectedRowValues;
    private final boolean supportsSubqueryUnions;
    private final boolean supportsOrderByNullsFirstLast;
    private final boolean supportsSetDefaultReferenceOption;

    public MysqlDialect() {
        super(Companion.getDialectName(), MysqlDataTypeProvider.INSTANCE, MysqlFunctionProvider.INSTANCE.INSTANCE);
        this.supportsTernaryAffectedRowValues = true;
        this.supportsSubqueryUnions = true;
    }

    public final boolean isMysql8$exposed_core() {
        Lazy lazy = this.isMysql8$delegate;
        return (Boolean)lazy.getValue();
    }

    public final String getFullVersion$exposed_core() {
        Lazy lazy = this.fullVersion$delegate;
        return (String)lazy.getValue();
    }

    @Override
    public boolean getSupportsCreateSequence() {
        return this.supportsCreateSequence;
    }

    @Override
    public boolean getSupportsTernaryAffectedRowValues() {
        return this.supportsTernaryAffectedRowValues;
    }

    @Override
    public boolean getSupportsSubqueryUnions() {
        return this.supportsSubqueryUnions;
    }

    @Override
    public boolean getSupportsOrderByNullsFirstLast() {
        return this.supportsOrderByNullsFirstLast;
    }

    @Override
    public boolean getSupportsSetDefaultReferenceOption() {
        return this.supportsSetDefaultReferenceOption;
    }

    public final boolean isFractionDateTimeSupported() {
        return TransactionManager.Companion.current().getDb().isVersionCovers(new BigDecimal("5.6"));
    }

    public final boolean isTimeZoneOffsetSupported() {
        return !(DatabaseDialectKt.getCurrentDialect() instanceof MariaDBDialect) && this.isMysql8$exposed_core();
    }

    @Override
    public boolean isAllowedAsColumnDefault(Expression<?> expression) {
        Intrinsics.checkNotNullParameter(expression, (String)"");
        if (super.isAllowedAsColumnDefault(expression)) {
            return true;
        }
        Object[] objectArray = new String[]{"CURRENT_TIMESTAMP", "CURRENT_TIMESTAMP()", "NOW()", "CURRENT_TIMESTAMP(6)", "NOW(6)"};
        Object[] objectArray2 = objectArray;
        return ArraysKt.contains((Object[])objectArray2, (Object)((Object)StringsKt.trim((CharSequence)expression.toString())).toString()) && this.isFractionDateTimeSupported();
    }

    @Override
    protected void fillConstraintCacheForTables(List<? extends Table> list) {
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        Intrinsics.checkNotNullParameter(list, (String)"");
        Set<String> set = (Set<String>)((Object)SchemaUtils.INSTANCE.sortTablesByReferences((Iterable<? extends Table>)list));
        boolean bl2 = false;
        int n = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)set, (int)10)), (int)16);
        Object object4 = set;
        HashMap<String, Map<String, ForeignKeyConstraint>> hashMap = new LinkedHashMap(n);
        boolean bl3 = false;
        Iterator iterator2 = object4.iterator();
        while (iterator2.hasNext()) {
            object3 = iterator2.next();
            object2 = (Table)object3;
            object = hashMap;
            bl = false;
            object.put(((Table)object2).nameInDatabaseCaseUnquoted(), object3);
        }
        HashMap<String, Map<String, ForeignKeyConstraint>> hashMap2 = hashMap;
        set = hashMap2.keySet();
        String string = CollectionsKt.joinToString$default((Iterable)set, (CharSequence)"','", (CharSequence)" ku.TABLE_NAME IN ('", (CharSequence)"')", (int)0, null, null, (int)56, null);
        Transaction transaction2 = TransactionManager.Companion.current();
        Iterable iterable = list;
        object = new StringBuilder().append('\'');
        boolean bl4 = false;
        object3 = iterable;
        object2 = new ArrayList();
        bl = false;
        Object object5 = object3;
        boolean bl5 = false;
        Iterator iterator3 = object5.iterator();
        while (iterator3.hasNext()) {
            String string2;
            Object t;
            Object t2 = t = iterator3.next();
            boolean bl6 = false;
            Table table = (Table)t2;
            boolean bl7 = false;
            if (table.getSchemaName() == null) continue;
            boolean bl8 = false;
            object2.add(string2);
        }
        String string3 = (String)CollectionsKt.singleOrNull((Iterable)CollectionsKt.toSet((Iterable)((List)object2)));
        if (string3 == null) {
            string3 = this.getDatabase();
        }
        object4 = ((StringBuilder)object).append(string3).append('\'').toString();
        hashMap = new HashMap<String, Map<String, ForeignKeyConstraint>>();
        Transaction.exec$default(transaction2, StringsKt.trimIndent((String)("SELECT\n                  rc.CONSTRAINT_NAME,\n                  ku.TABLE_NAME,\n                  ku.COLUMN_NAME,\n                  ku.REFERENCED_TABLE_NAME,\n                  ku.REFERENCED_COLUMN_NAME,\n                  rc.UPDATE_RULE,\n                  rc.DELETE_RULE\n                FROM INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS rc\n                  INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE ku\n                    ON ku.TABLE_SCHEMA = rc.CONSTRAINT_SCHEMA AND rc.CONSTRAINT_NAME = ku.CONSTRAINT_NAME\n                WHERE ku.TABLE_SCHEMA = " + (String)object4 + "\n                  AND ku.CONSTRAINT_SCHEMA = " + (String)object4 + "\n                  AND rc.CONSTRAINT_SCHEMA = " + (String)object4 + "\n                  AND " + string + "\n                ORDER BY ku.ORDINAL_POSITION\n            ")), null, null, (Function1)new Function1<ResultSet, Unit>(set, this, transaction2, hashMap2, hashMap){
            final /* synthetic */ Set<String> $allTableNames;
            final /* synthetic */ MysqlDialect this$0;
            final /* synthetic */ Transaction $tr;
            final /* synthetic */ Map<String, Table> $allTables;
            final /* synthetic */ HashMap<String, Map<String, ForeignKeyConstraint>> $constraintsToLoad;
            {
                this.$allTableNames = set;
                this.this$0 = mysqlDialect;
                this.$tr = transaction2;
                this.$allTables = map;
                this.$constraintsToLoad = hashMap;
                super(1);
            }

            public final void invoke(ResultSet resultSet) {
                Object object;
                Object object2;
                Map map;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                Map map2;
                Intrinsics.checkNotNullParameter((Object)resultSet, (String)"");
                while (resultSet.next()) {
                    String string;
                    Object object7;
                    boolean bl;
                    Column<Object> column;
                    T t2;
                    Object object8;
                    block7: {
                        String string2;
                        Object v1;
                        MysqlDialect mysqlDialect;
                        block6: {
                            Intrinsics.checkNotNull((Object)resultSet.getString("TABLE_NAME"));
                            if (!this.$allTableNames.contains(map2)) continue;
                            String string3 = resultSet.getString("COLUMN_NAME");
                            Intrinsics.checkNotNull((Object)string3);
                            String string4 = this.this$0.quoteIdentifierWhenWrongCaseOrNecessary(string3, this.$tr);
                            object6 = ((Table)MapsKt.getValue(this.$allTables, (Object)map2)).getColumns();
                            mysqlDialect = this.this$0;
                            object5 = this.$tr;
                            boolean bl2 = false;
                            object4 = object6.iterator();
                            while (object4.hasNext()) {
                                object3 = object4.next();
                                Column column2 = (Column)object3;
                                boolean bl3 = false;
                                if (!Intrinsics.areEqual((Object)mysqlDialect.quoteIdentifierWhenWrongCaseOrNecessary(column2.nameInDatabaseCase(), (Transaction)object5), (Object)string4)) continue;
                                v1 = object3;
                                break block6;
                            }
                            v1 = null;
                        }
                        if ((map = (Column)v1) == null) continue;
                        object6 = map;
                        mysqlDialect = this.this$0;
                        object5 = this.$tr;
                        Map<String, Table> map3 = this.$allTables;
                        object4 = this.$constraintsToLoad;
                        object3 = object6;
                        boolean bl4 = false;
                        Intrinsics.checkNotNull((Object)resultSet.getString("CONSTRAINT_NAME"));
                        Intrinsics.checkNotNull((Object)resultSet.getString("REFERENCED_TABLE_NAME"));
                        String string5 = resultSet.getString("REFERENCED_COLUMN_NAME");
                        Intrinsics.checkNotNull((Object)string5);
                        object2 = mysqlDialect.quoteIdentifierWhenWrongCaseOrNecessary(string5, (Transaction)object5);
                        object8 = ((Table)MapsKt.getValue(map3, (Object)string2)).getColumns();
                        boolean bl5 = false;
                        for (T t2 : object8) {
                            column = (Column)t2;
                            bl = false;
                            if (!Intrinsics.areEqual((Object)mysqlDialect.quoteIdentifierWhenWrongCaseOrNecessary(column.nameInDatabaseCase(), (Transaction)object5), (Object)object2)) continue;
                            break block7;
                        }
                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    Column column3 = (Column)t2;
                    String string6 = resultSet.getString("UPDATE_RULE");
                    Intrinsics.checkNotNull((Object)string6);
                    object8 = ReferenceOption.valueOf(StringsKt.replace$default((String)string6, (String)" ", (String)"_", (boolean)false, (int)4, null));
                    String string7 = resultSet.getString("DELETE_RULE");
                    Intrinsics.checkNotNull((Object)string7);
                    object = ReferenceOption.valueOf(StringsKt.replace$default((String)string7, (String)" ", (String)"_", (boolean)false, (int)4, null));
                    Map map4 = (Map)object4;
                    boolean bl6 = false;
                    column = map4.get(map2);
                    if (column == null) {
                        bl = false;
                        Map map5 = new LinkedHashMap<K, V>();
                        map4.put(map2, map5);
                        object7 = map5;
                    } else {
                        object7 = column;
                    }
                    ((Map)object7).merge(string, new ForeignKeyConstraint(column3, (Column<?>)object3, (ReferenceOption)((Object)object8), (ReferenceOption)((Object)object), string), (arg_0, arg_1) -> fillConstraintCacheForTables.1.invoke$lambda$4$lambda$3(fillConstraintCacheForTables.2.2.INSTANCE, arg_0, arg_1));
                }
                map2 = this.$constraintsToLoad;
                Map<String, Collection<ForeignKeyConstraint>> map6 = this.this$0.getColumnConstraintsCache();
                boolean bl = false;
                map = map2;
                object6 = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)map2.size()));
                boolean bl7 = false;
                object5 = map.entrySet();
                boolean bl8 = false;
                object4 = object5.iterator();
                while (object4.hasNext()) {
                    object3 = object4.next();
                    Map.Entry entry = (Map.Entry)object3;
                    Object object9 = object6;
                    boolean bl9 = false;
                    object2 = (Map.Entry)object3;
                    K k = entry.getKey();
                    Object object10 = object9;
                    boolean bl10 = false;
                    object = (Map)object2.getValue();
                    Collection<V> collection = object.values();
                    object10.put(k, collection);
                }
                map6.putAll((Map<String, Collection<ForeignKeyConstraint>>)object6);
            }

            private static final ForeignKeyConstraint invoke$lambda$4$lambda$3(Function2 function2, Object object, Object object2) {
                Intrinsics.checkNotNullParameter((Object)function2, (String)"");
                return (ForeignKeyConstraint)function2.invoke(object, object2);
            }
        }, 6, null);
    }

    @Override
    public String createIndex(Index index) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"");
        if (index.getFunctions() != null && !this.isMysql8$exposed_core()) {
            SQLLogKt.getExposedLogger().warn("Functional index on " + index.getTable().getTableName() + " using " + CollectionsKt.joinToString$default((Iterable)index.getFunctions(), null, null, null, (int)0, null, (Function1)createIndex.1.INSTANCE, (int)31, null) + " can't be created in MySQL prior to 8.0");
            return "";
        }
        return super.createIndex(index);
    }

    @Override
    public String dropIndex(String string, String string2, boolean bl, boolean bl2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        return "ALTER TABLE " + this.getIdentifierManager().quoteIfNecessary(string) + " DROP INDEX " + this.getIdentifierManager().quoteIfNecessary(string2);
    }

    @Override
    public String setSchema(Schema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"");
        return "USE " + schema.getIdentifier();
    }

    @Override
    public String createSchema(Schema schema) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)schema, (String)"");
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String[] stringArray = new String[]{"CREATE SCHEMA IF NOT EXISTS ", schema.getIdentifier()};
        StringsKt.append((StringBuilder)stringBuilder2, (String[])stringArray);
        if (schema.getAuthorization() != null) {
            throw new UnsupportedByDialectException(DatabaseDialectKt.getCurrentDialect().getName() + " do not have database owners. You can use GRANT to allow or deny rights on database.", DatabaseDialectKt.getCurrentDialect());
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    @Override
    public String dropSchema(Schema schema, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"");
        return "DROP SCHEMA IF EXISTS " + schema.getIdentifier();
    }

    @Override
    protected boolean metadataMatchesTable(String string, String string2, Table table) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        Intrinsics.checkNotNullParameter((Object)table, (String)"");
        if (((CharSequence)string2).length() == 0) {
            bl = Intrinsics.areEqual((Object)string, (Object)table.nameInDatabaseCaseUnquoted());
        } else {
            String string3 = StringsKt.replace$default((String)table.getTableNameWithoutScheme$exposed_core(), (String)"`", (String)"", (boolean)false, (int)4, null);
            String string4 = DatabaseDialectKt.inProperCase(string2 + '.' + string3);
            bl = Intrinsics.areEqual((Object)string, (Object)string4);
        }
        return bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/exposed/sql/vendors/MysqlDialect$Companion;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect$DialectNameProvider;", "()V", "exposed-core"})
    public static final class Companion
    extends VendorDialect.DialectNameProvider {
        private Companion() {
            super("MySQL");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

