/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import io.ktor.events.Events;
import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationEnvironment;
import io.ktor.server.application.DefaultApplicationEventsKt;
import io.ktor.server.engine.ApplicationEngine;
import io.ktor.server.engine.BaseApplicationEngineKt;
import io.ktor.server.engine.BaseApplicationResponse;
import io.ktor.server.engine.DefaultEnginePipelineKt;
import io.ktor.server.engine.DefaultTransformKt;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.server.engine.StartupInfo;
import io.ktor.util.date.DateJvmKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.v;
import kotlinx.coroutines.x;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001:\u0001\u001eB)\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0096@\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0005\u001a\u00020\u00048\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R&\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u00198\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001f"}, d2={"Lio/ktor/server/engine/BaseApplicationEngine;", "Lio/ktor/server/engine/ApplicationEngine;", "Lio/ktor/server/application/ApplicationEnvironment;", "environment", "Lio/ktor/events/Events;", "monitor", "", "developmentMode", "Lio/ktor/server/engine/EnginePipeline;", "pipeline", "<init>", "(Lio/ktor/server/application/ApplicationEnvironment;Lio/ktor/events/Events;ZLio/ktor/server/engine/EnginePipeline;)V", "", "Lio/ktor/server/engine/EngineConnectorConfig;", "resolvedConnectors", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lio/ktor/server/application/ApplicationEnvironment;", "getEnvironment", "()Lio/ktor/server/application/ApplicationEnvironment;", "Lio/ktor/events/Events;", "getMonitor", "()Lio/ktor/events/Events;", "Lio/ktor/server/engine/EnginePipeline;", "getPipeline", "()Lio/ktor/server/engine/EnginePipeline;", "Lkotlinx/coroutines/CompletableDeferred;", "resolvedConnectorsDeferred", "Lkotlinx/coroutines/CompletableDeferred;", "getResolvedConnectorsDeferred", "()Lkotlinx/coroutines/CompletableDeferred;", "Configuration", "ktor-server-core"})
public abstract class BaseApplicationEngine
implements ApplicationEngine {
    private final ApplicationEnvironment environment;
    private final Events monitor;
    private final EnginePipeline pipeline;
    private final v<List<EngineConnectorConfig>> resolvedConnectorsDeferred;

    public BaseApplicationEngine(ApplicationEnvironment applicationEnvironment, Events events, boolean bl, EnginePipeline enginePipeline) {
        Intrinsics.checkNotNullParameter((Object)applicationEnvironment, (String)"");
        Intrinsics.checkNotNullParameter((Object)events, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)enginePipeline), (String)"");
        this.environment = applicationEnvironment;
        this.monitor = events;
        this.pipeline = enginePipeline;
        this.resolvedConnectorsDeferred = x.a(null, (int)1, null);
        ApplicationEnvironment applicationEnvironment2 = this.environment;
        StartupInfo startupInfo = new StartupInfo();
        EnginePipeline enginePipeline2 = this.pipeline;
        BaseApplicationResponse.Companion.setupSendPipeline(enginePipeline2.getSendPipeline());
        BaseApplicationResponse.Companion.setupFallbackResponse$ktor_server_core(enginePipeline2, applicationEnvironment2.getLog());
        this.monitor.subscribe(DefaultApplicationEventsKt.getApplicationStarting(), arg_0 -> BaseApplicationEngine._init_$lambda$0(startupInfo, enginePipeline2, arg_0));
        this.monitor.subscribe(DefaultApplicationEventsKt.getApplicationStarted(), arg_0 -> BaseApplicationEngine._init_$lambda$1(startupInfo, applicationEnvironment2, arg_0));
    }

    public /* synthetic */ BaseApplicationEngine(ApplicationEnvironment applicationEnvironment, Events events, boolean bl, EnginePipeline enginePipeline, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            enginePipeline = DefaultEnginePipelineKt.defaultEnginePipeline(applicationEnvironment.getConfig(), bl);
        }
        this(applicationEnvironment, events, bl, enginePipeline);
    }

    @Override
    public final ApplicationEnvironment getEnvironment() {
        return this.environment;
    }

    protected final Events getMonitor() {
        return this.monitor;
    }

    public final EnginePipeline getPipeline() {
        return this.pipeline;
    }

    protected final v<List<EngineConnectorConfig>> getResolvedConnectorsDeferred() {
        return this.resolvedConnectorsDeferred;
    }

    @Override
    public Object resolvedConnectors(Continuation<? super List<? extends EngineConnectorConfig>> continuation) {
        return this.resolvedConnectorsDeferred.await(continuation);
    }

    @Override
    public Object startSuspend(boolean bl, Continuation<? super ApplicationEngine> continuation) {
        return ApplicationEngine.DefaultImpls.startSuspend(this, bl, continuation);
    }

    @Override
    public Object stopSuspend(long l2, long l3, Continuation<? super Unit> continuation) {
        return ApplicationEngine.DefaultImpls.stopSuspend(this, l2, l3, continuation);
    }

    private static final Unit _init_$lambda$0(StartupInfo startupInfo, EnginePipeline enginePipeline, Application application) {
        Intrinsics.checkNotNullParameter((Object)((Object)application), (String)"");
        if (!startupInfo.isFirstLoading()) {
            startupInfo.setInitializedStartAt(DateJvmKt.getTimeMillis());
        }
        application.getReceivePipeline().merge(enginePipeline.getReceivePipeline());
        application.getSendPipeline().merge(enginePipeline.getSendPipeline());
        DefaultTransformKt.installDefaultTransformations(application.getReceivePipeline());
        DefaultTransformKt.installDefaultTransformations(application.getSendPipeline());
        BaseApplicationEngineKt.access$installDefaultInterceptors(application);
        BaseApplicationEngineKt.access$installDefaultTransformationChecker(application);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(StartupInfo startupInfo, ApplicationEnvironment applicationEnvironment, Application application) {
        Intrinsics.checkNotNullParameter((Object)((Object)application), (String)"");
        long l2 = DateJvmKt.getTimeMillis();
        double d = (double)(l2 - startupInfo.getInitializedStartAt()) / 1000.0;
        if (startupInfo.isFirstLoading()) {
            applicationEnvironment.getLog().info("Application started in " + d + " seconds.");
            startupInfo.setFirstLoading(false);
        } else {
            applicationEnvironment.getLog().info("Application auto-reloaded in " + d + " seconds.");
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lio/ktor/server/engine/BaseApplicationEngine$Configuration;", "Lio/ktor/server/engine/ApplicationEngine$Configuration;", "<init>", "()V", "ktor-server-core"})
    public static class Configuration
    extends ApplicationEngine.Configuration {
    }
}

