/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import java.lang.annotation.Annotation;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.ClassSerialDescriptorBuilder;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u001b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0007\u0010\bB'\b\u0011\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\u0007\u0010\fJ\u001d\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fR\u0010\u0010\u0006\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0010\u001a\u00020\u00118VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lkotlinx/serialization/internal/ObjectSerializer;", "T", "", "Lkotlinx/serialization/KSerializer;", "serialName", "", "objectInstance", "<init>", "(Ljava/lang/String;Ljava/lang/Object;)V", "classAnnotations", "", "", "(Ljava/lang/String;Ljava/lang/Object;[Ljava/lang/annotation/Annotation;)V", "Ljava/lang/Object;", "_annotations", "", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor$delegate", "Lkotlin/Lazy;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "(Lkotlinx/serialization/encoding/Encoder;Ljava/lang/Object;)V", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "(Lkotlinx/serialization/encoding/Decoder;)Ljava/lang/Object;", "kotlinx-serialization-core"})
public final class ObjectSerializer<T>
implements KSerializer<T> {
    private final T objectInstance;
    private List<? extends Annotation> _annotations;
    private final Lazy descriptor$delegate;

    public ObjectSerializer(String string, T t) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter(t, (String)"");
        this.objectInstance = t;
        this._annotations = CollectionsKt.emptyList();
        this.descriptor$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> ObjectSerializer.descriptor_delegate$lambda$1(string, this));
    }

    public ObjectSerializer(String string, T t, Annotation[] annotationArray) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter(t, (String)"");
        Intrinsics.checkNotNullParameter((Object)annotationArray, (String)"");
        this(string, t);
        this._annotations = ArraysKt.asList((Object[])annotationArray);
    }

    @Override
    public SerialDescriptor getDescriptor() {
        Lazy lazy = this.descriptor$delegate;
        return (SerialDescriptor)lazy.getValue();
    }

    @Override
    public void serialize(Encoder encoder, T t) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"");
        Intrinsics.checkNotNullParameter(t, (String)"");
        encoder.beginStructure(this.getDescriptor()).endStructure(this.getDescriptor());
    }

    @Override
    public T deserialize(Decoder decoder) {
        int n;
        CompositeDecoder compositeDecoder;
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"");
        Decoder decoder2 = decoder;
        SerialDescriptor serialDescriptor = this.getDescriptor();
        boolean bl = false;
        CompositeDecoder compositeDecoder2 = compositeDecoder = decoder2.beginStructure(serialDescriptor);
        boolean bl2 = false;
        if (!compositeDecoder2.decodeSequentially() && (n = compositeDecoder2.decodeElementIndex(this.getDescriptor())) != -1) {
            throw new SerializationException("Unexpected index " + n);
        }
        compositeDecoder2 = Unit.INSTANCE;
        compositeDecoder.endStructure(serialDescriptor);
        return this.objectInstance;
    }

    private static final Unit descriptor_delegate$lambda$1$lambda$0(ObjectSerializer objectSerializer, ClassSerialDescriptorBuilder classSerialDescriptorBuilder) {
        Intrinsics.checkNotNullParameter((Object)classSerialDescriptorBuilder, (String)"");
        classSerialDescriptorBuilder.setAnnotations(objectSerializer._annotations);
        return Unit.INSTANCE;
    }

    private static final SerialDescriptor descriptor_delegate$lambda$1(String string, ObjectSerializer objectSerializer) {
        return SerialDescriptorsKt.buildSerialDescriptor(string, StructureKind.OBJECT.INSTANCE, new SerialDescriptor[0], (Function1<? super ClassSerialDescriptorBuilder, Unit>)((Function1)arg_0 -> ObjectSerializer.descriptor_delegate$lambda$1$lambda$0(objectSerializer, arg_0)));
    }
}

