/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.util.PrimitiveStack;
import java.nio.FloatBuffer;

public class FloatStack
implements PrimitiveStack {
    private int position = 0;
    private float[] buffer;
    private int growSize;

    public FloatStack(int n, int n2) {
        this.growSize = n2;
        this.buffer = new float[n];
    }

    @Override
    public final int capacity() {
        return this.buffer.length;
    }

    @Override
    public final int position() {
        return this.position;
    }

    @Override
    public final void position(int n) {
        if (0 > this.position || this.position >= this.buffer.length) {
            throw new IndexOutOfBoundsException("Invalid new position " + n + ", " + this.toString());
        }
        this.position = n;
    }

    @Override
    public final int remaining() {
        return this.buffer.length - this.position;
    }

    @Override
    public final int getGrowSize() {
        return this.growSize;
    }

    @Override
    public final void setGrowSize(int n) {
        this.growSize = n;
    }

    public final String toString() {
        return "FloatStack[0..(pos " + this.position + ").." + this.buffer.length + ", remaining " + this.remaining() + "]";
    }

    public final float[] buffer() {
        return this.buffer;
    }

    private final void growIfNecessary(int n) {
        if (this.position + n > this.buffer.length) {
            if (0 >= this.growSize) {
                throw new IndexOutOfBoundsException("Out of fixed stack size: " + this);
            }
            float[] fArray = new float[this.buffer.length + this.growSize];
            System.arraycopy(this.buffer, 0, fArray, 0, this.position);
            this.buffer = fArray;
        }
    }

    public final float[] putOnTop(float[] fArray, int n, int n2) {
        this.growIfNecessary(n2);
        System.arraycopy(fArray, n, this.buffer, this.position, n2);
        this.position += n2;
        return fArray;
    }

    public final FloatBuffer putOnTop(FloatBuffer floatBuffer, int n) {
        this.growIfNecessary(n);
        floatBuffer.get(this.buffer, this.position, n);
        this.position += n;
        return floatBuffer;
    }

    public final float[] getFromTop(float[] fArray, int n, int n2) {
        System.arraycopy(this.buffer, this.position - n2, fArray, n, n2);
        this.position -= n2;
        return fArray;
    }

    public final FloatBuffer getFromTop(FloatBuffer floatBuffer, int n) {
        floatBuffer.put(this.buffer, this.position - n, n);
        this.position -= n;
        return floatBuffer;
    }
}

