/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util.cache;

import com.jogamp.common.JogampRuntimeException;
import com.jogamp.common.net.Uri;
import com.jogamp.common.os.NativeLibrary;
import com.jogamp.common.util.JarUtil;
import com.jogamp.common.util.SecurityUtil;
import com.jogamp.common.util.cache.TempFileCache;
import java.io.File;
import java.io.IOException;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import jogamp.common.Debug;

public class TempJarCache {
    private static final boolean DEBUG = Debug.debug("TempJarCache");
    private static Map<String, String> nativeLibMap;
    private static Map<Uri, LoadState> nativeLibJars;
    private static Map<Uri, LoadState> classFileJars;
    private static Map<Uri, LoadState> resourceFileJars;
    private static TempFileCache tmpFileCache;
    private static volatile boolean staticInitError;
    private static volatile boolean staticTempIsExecutable;
    private static volatile boolean isInit;

    private static boolean testLoadState(LoadState loadState, LoadState loadState2) {
        if (null == loadState) {
            return null == loadState2;
        }
        return loadState.compliesWith(loadState2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean initSingleton() {
        if (!isInit) {
            Class<TempJarCache> clazz = TempJarCache.class;
            // MONITORENTER : com.jogamp.common.util.cache.TempJarCache.class
            if (!isInit) {
                boolean bl = staticInitError = !TempFileCache.initSingleton();
                if (!staticInitError) {
                    tmpFileCache = new TempFileCache();
                    staticInitError = !tmpFileCache.isValid(false);
                    staticTempIsExecutable = tmpFileCache.isValid(true);
                }
                if (!staticInitError) {
                    nativeLibMap = new HashMap<String, String>();
                    nativeLibJars = new HashMap<Uri, LoadState>();
                    classFileJars = new HashMap<Uri, LoadState>();
                    resourceFileJars = new HashMap<Uri, LoadState>();
                }
                if (DEBUG) {
                    File file = null != tmpFileCache ? tmpFileCache.getTempDir() : null;
                    String string = null != file ? file.getAbsolutePath() : null;
                    System.err.println("TempJarCache.initSingleton(): ok " + (false == staticInitError) + ", " + string + ", executable " + staticTempIsExecutable);
                }
                isInit = true;
            }
            // MONITOREXIT : clazz
        }
        if (staticInitError) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isInitializedImpl() {
        if (isInit) return true;
        Class<TempJarCache> clazz = TempJarCache.class;
        synchronized (TempJarCache.class) {
            if (isInit) return true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return false;
        }
    }

    public static boolean isInitialized(boolean bl) {
        return TempJarCache.isInitializedImpl() && !staticInitError && (!bl || staticTempIsExecutable);
    }

    static void checkInitialized(boolean bl) {
        if (!TempJarCache.isInitializedImpl()) {
            throw new JogampRuntimeException("initSingleton() has to be called first.");
        }
        if (staticInitError) {
            throw new JogampRuntimeException("initSingleton() failed.");
        }
        if (bl && !staticTempIsExecutable) {
            throw new JogampRuntimeException("TempJarCache folder not suitable for executables");
        }
    }

    public static TempFileCache getTempFileCache() {
        TempJarCache.checkInitialized(false);
        return tmpFileCache;
    }

    public static synchronized boolean checkNativeLibs(Uri uri, LoadState loadState) {
        TempJarCache.checkInitialized(false);
        if (null == uri) {
            throw new IllegalArgumentException("jarUri is null");
        }
        return TempJarCache.testLoadState(nativeLibJars.get(uri), loadState);
    }

    public static synchronized boolean checkClasses(Uri uri, LoadState loadState) {
        TempJarCache.checkInitialized(false);
        if (null == uri) {
            throw new IllegalArgumentException("jarUri is null");
        }
        return TempJarCache.testLoadState(classFileJars.get(uri), loadState);
    }

    public static synchronized boolean checkResources(Uri uri, LoadState loadState) {
        TempJarCache.checkInitialized(false);
        if (null == uri) {
            throw new IllegalArgumentException("jarUri is null");
        }
        return TempJarCache.testLoadState(resourceFileJars.get(uri), loadState);
    }

    public static final synchronized boolean addNativeLibs(Class<?> clazz, Uri uri, String string) {
        TempJarCache.checkInitialized(true);
        LoadState loadState = nativeLibJars.get(uri);
        if (!TempJarCache.testLoadState(loadState, LoadState.LOOKED_UP)) {
            nativeLibJars.put(uri, LoadState.LOOKED_UP);
            JarFile jarFile = JarUtil.getJarFile(uri);
            if (DEBUG) {
                System.err.println("TempJarCache: addNativeLibs: " + uri + ": nativeJar " + jarFile.getName() + " (NEW)");
            }
            TempJarCache.validateCertificates(clazz, jarFile);
            int n = JarUtil.extract(tmpFileCache.getTempDir(), nativeLibMap, jarFile, string, true, false, false);
            nativeLibJars.put(uri, LoadState.LOADED);
            return n > 0;
        }
        if (TempJarCache.testLoadState(loadState, LoadState.LOADED)) {
            if (DEBUG) {
                System.err.println("TempJarCache: addNativeLibs: " + uri + ": nativeJar " + uri + " (REUSE)");
            }
            return true;
        }
        throw new IOException("TempJarCache: addNativeLibs: " + uri + ", previous load attempt failed");
    }

    public static final synchronized void addClasses(Class<?> clazz, Uri uri) {
        TempJarCache.checkInitialized(false);
        LoadState loadState = classFileJars.get(uri);
        if (!TempJarCache.testLoadState(loadState, LoadState.LOOKED_UP)) {
            classFileJars.put(uri, LoadState.LOOKED_UP);
            JarFile jarFile = JarUtil.getJarFile(uri);
            if (DEBUG) {
                System.err.println("TempJarCache: addClasses: " + uri + ": nativeJar " + jarFile.getName());
            }
            TempJarCache.validateCertificates(clazz, jarFile);
            JarUtil.extract(tmpFileCache.getTempDir(), null, jarFile, null, false, true, false);
            classFileJars.put(uri, LoadState.LOADED);
        } else if (!TempJarCache.testLoadState(loadState, LoadState.LOADED)) {
            throw new IOException("TempJarCache: addClasses: " + uri + ", previous load attempt failed");
        }
    }

    public static final synchronized void addResources(Class<?> clazz, Uri uri) {
        TempJarCache.checkInitialized(false);
        LoadState loadState = resourceFileJars.get(uri);
        if (!TempJarCache.testLoadState(loadState, LoadState.LOOKED_UP)) {
            resourceFileJars.put(uri, LoadState.LOOKED_UP);
            JarFile jarFile = JarUtil.getJarFile(uri);
            if (DEBUG) {
                System.err.println("TempJarCache: addResources: " + uri + ": nativeJar " + jarFile.getName());
            }
            TempJarCache.validateCertificates(clazz, jarFile);
            JarUtil.extract(tmpFileCache.getTempDir(), null, jarFile, null, false, false, true);
            resourceFileJars.put(uri, LoadState.LOADED);
        } else if (!TempJarCache.testLoadState(loadState, LoadState.LOADED)) {
            throw new IOException("TempJarCache: addResources: " + uri + ", previous load attempt failed");
        }
    }

    public static final synchronized void addAll(Class<?> clazz, Uri uri) {
        TempJarCache.checkInitialized(false);
        if (null == uri) {
            throw new IllegalArgumentException("jarUri is null");
        }
        LoadState loadState = nativeLibJars.get(uri);
        LoadState loadState2 = classFileJars.get(uri);
        LoadState loadState3 = resourceFileJars.get(uri);
        if (!(TempJarCache.testLoadState(loadState, LoadState.LOOKED_UP) && TempJarCache.testLoadState(loadState2, LoadState.LOOKED_UP) && TempJarCache.testLoadState(loadState3, LoadState.LOOKED_UP))) {
            boolean bl;
            boolean bl2 = staticTempIsExecutable && !TempJarCache.testLoadState(loadState, LoadState.LOADED);
            boolean bl3 = !TempJarCache.testLoadState(loadState2, LoadState.LOADED);
            boolean bl4 = bl = !TempJarCache.testLoadState(loadState3, LoadState.LOOKED_UP);
            if (bl2) {
                nativeLibJars.put(uri, LoadState.LOOKED_UP);
            }
            if (bl3) {
                classFileJars.put(uri, LoadState.LOOKED_UP);
            }
            if (bl) {
                resourceFileJars.put(uri, LoadState.LOOKED_UP);
            }
            JarFile jarFile = JarUtil.getJarFile(uri);
            if (DEBUG) {
                System.err.println("TempJarCache: addAll: " + uri + ": nativeJar " + jarFile.getName());
            }
            TempJarCache.validateCertificates(clazz, jarFile);
            JarUtil.extract(tmpFileCache.getTempDir(), nativeLibMap, jarFile, null, bl2, bl3, bl);
            if (bl2) {
                nativeLibJars.put(uri, LoadState.LOADED);
            }
            if (bl3) {
                classFileJars.put(uri, LoadState.LOADED);
            }
            if (bl) {
                resourceFileJars.put(uri, LoadState.LOADED);
            }
        } else if (!(TempJarCache.testLoadState(loadState, LoadState.LOADED) && TempJarCache.testLoadState(loadState2, LoadState.LOADED) && TempJarCache.testLoadState(loadState3, LoadState.LOADED))) {
            throw new IOException("TempJarCache: addAll: " + uri + ", previous load attempt failed");
        }
    }

    public static final synchronized String findLibrary(String string) {
        File file;
        TempJarCache.checkInitialized(false);
        if (!staticTempIsExecutable) {
            return null;
        }
        String string2 = nativeLibMap.get(string);
        if (null == string2 && null != NativeLibrary.isValidNativeLibraryName(string, false) && (file = new File(tmpFileCache.getTempDir(), string)).exists()) {
            string2 = file.getAbsolutePath();
        }
        return string2;
    }

    public static final synchronized String findResource(String string) {
        TempJarCache.checkInitialized(false);
        File file = new File(tmpFileCache.getTempDir(), string);
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        return null;
    }

    public static final synchronized Uri getResourceUri(String string) {
        TempJarCache.checkInitialized(false);
        File file = new File(tmpFileCache.getTempDir(), string);
        if (file.exists()) {
            return Uri.valueOf(file);
        }
        return null;
    }

    private static void validateCertificates(Class<?> clazz, JarFile jarFile) {
        if (null == clazz) {
            throw new IllegalArgumentException("certClass is null");
        }
        Certificate[] certificateArray = SecurityUtil.getCerts(clazz);
        if (null != certificateArray) {
            JarUtil.validateCertificates(certificateArray, jarFile);
            if (DEBUG) {
                System.err.println("TempJarCache: validateCertificates: OK - Matching rootCerts in given class " + clazz.getName() + ", nativeJar " + jarFile.getName());
            }
        } else if (DEBUG) {
            System.err.println("TempJarCache: validateCertificates: OK - No rootCerts in given class " + clazz.getName() + ", nativeJar " + jarFile.getName());
        }
    }

    static {
        staticInitError = false;
        staticTempIsExecutable = true;
        isInit = false;
    }

    public static enum LoadState {
        LOOKED_UP,
        LOADED;


        public boolean compliesWith(LoadState loadState) {
            return null != loadState ? this.compareTo(loadState) >= 0 : false;
        }
    }
}

