/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.node;

import androidx.compose.ui.node.DepthSortedSetsForDifferentPasses;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.MeasureAndLayoutDelegate;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J\f\u0010\u0010\u001a\u00020\u000e*\u00020\u0003H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Landroidx/compose/ui/node/LayoutTreeConsistencyChecker;", "", "root", "Landroidx/compose/ui/node/LayoutNode;", "relayoutNodes", "Landroidx/compose/ui/node/DepthSortedSetsForDifferentPasses;", "postponedMeasureRequests", "", "Landroidx/compose/ui/node/MeasureAndLayoutDelegate$PostponedRequest;", "<init>", "(Landroidx/compose/ui/node/LayoutNode;Landroidx/compose/ui/node/DepthSortedSetsForDifferentPasses;Ljava/util/List;)V", "assertConsistent", "", "isTreeConsistent", "", "node", "consistentLayoutState", "nodeToString", "", "logTree", "ui"})
public final class LayoutTreeConsistencyChecker {
    private final LayoutNode root;
    private final DepthSortedSetsForDifferentPasses relayoutNodes;
    private final List<MeasureAndLayoutDelegate.PostponedRequest> postponedMeasureRequests;
    public static final int $stable = 8;

    public LayoutTreeConsistencyChecker(LayoutNode layoutNode, DepthSortedSetsForDifferentPasses depthSortedSetsForDifferentPasses, List<MeasureAndLayoutDelegate.PostponedRequest> list) {
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"");
        Intrinsics.checkNotNullParameter((Object)depthSortedSetsForDifferentPasses, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        this.root = layoutNode;
        this.relayoutNodes = depthSortedSetsForDifferentPasses;
        this.postponedMeasureRequests = list;
    }

    public final void assertConsistent() {
        boolean bl;
        boolean bl2 = bl = !this.isTreeConsistent(this.root);
        if (bl) {
            System.out.println((Object)this.logTree());
            throw new IllegalStateException("Inconsistency found!");
        }
    }

    private final boolean isTreeConsistent(LayoutNode layoutNode) {
        if (!this.consistentLayoutState(layoutNode)) {
            return false;
        }
        List<LayoutNode> list = layoutNode.getChildren$ui();
        boolean bl = false;
        int n2 = ((Collection)list).size();
        for (int j = 0; j < n2; ++j) {
            LayoutNode layoutNode2;
            LayoutNode layoutNode3 = layoutNode2 = list.get(j);
            boolean bl2 = false;
            if (this.isTreeConsistent(layoutNode3)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean consistentLayoutState(LayoutNode layoutNode) {
        boolean bl;
        MeasureAndLayoutDelegate.PostponedRequest postponedRequest;
        boolean bl2;
        MeasureAndLayoutDelegate.PostponedRequest postponedRequest2;
        MeasureAndLayoutDelegate.PostponedRequest postponedRequest3;
        int n2;
        int n3;
        boolean bl3;
        List<MeasureAndLayoutDelegate.PostponedRequest> list;
        boolean bl4;
        List<MeasureAndLayoutDelegate.PostponedRequest> list2;
        LayoutNode.LayoutState layoutState;
        LayoutNode layoutNode2;
        block25: {
            block24: {
                LayoutNode layoutNode3 = layoutNode2 = layoutNode.getParent$ui();
                LayoutNode.LayoutState layoutState2 = layoutState = layoutNode3 != null ? layoutNode3.getLayoutState$ui() : null;
                if (layoutNode.isPlaced()) break block24;
                if (layoutNode.getPlaceOrder$ui() == Integer.MAX_VALUE) break block25;
                LayoutNode layoutNode4 = layoutNode2;
                boolean bl5 = layoutNode4 != null ? layoutNode4.isPlaced() : false;
                if (!bl5) break block25;
            }
            if (layoutNode.getMeasurePending$ui()) {
                MeasureAndLayoutDelegate.PostponedRequest postponedRequest4;
                block22: {
                    list2 = this.postponedMeasureRequests;
                    bl4 = false;
                    list = list2;
                    bl3 = false;
                    n3 = ((Collection)list).size();
                    for (n2 = 0; n2 < n3; ++n2) {
                        postponedRequest2 = postponedRequest3 = list.get(n2);
                        bl2 = false;
                        postponedRequest = postponedRequest2;
                        bl = false;
                        if (!(Intrinsics.areEqual((Object)postponedRequest.getNode(), (Object)layoutNode) && !postponedRequest.isLookahead())) continue;
                        postponedRequest4 = postponedRequest2;
                        break block22;
                    }
                    postponedRequest4 = null;
                }
                if (postponedRequest4 != null) {
                    return true;
                }
            }
            if (layoutNode.isDeactivated()) {
                return true;
            }
            if (layoutNode.getMeasurePending$ui()) {
                boolean bl6;
                boolean bl7;
                if (this.relayoutNodes.contains(layoutNode)) return true;
                if (layoutNode.getLayoutState$ui() == LayoutNode.LayoutState.LookaheadMeasuring) return true;
                LayoutNode layoutNode5 = layoutNode2;
                if (layoutNode5 != null) {
                    if (layoutNode5.getMeasurePending$ui()) {
                        return true;
                    }
                    bl7 = false;
                } else {
                    bl7 = false;
                }
                if (bl7) return true;
                LayoutNode layoutNode6 = layoutNode2;
                if (layoutNode6 != null) {
                    if (layoutNode6.getLookaheadMeasurePending$ui()) {
                        return true;
                    }
                    bl6 = false;
                } else {
                    bl6 = false;
                }
                if (bl6) return true;
                if (layoutState != LayoutNode.LayoutState.Measuring) return false;
                return true;
            }
            if (layoutNode.getLayoutPending$ui()) {
                if (this.relayoutNodes.contains(layoutNode)) return true;
                if (layoutNode2 == null) return true;
                if (layoutNode2.getMeasurePending$ui()) return true;
                if (layoutNode2.getLayoutPending$ui()) return true;
                if (layoutState == LayoutNode.LayoutState.Measuring) return true;
                if (layoutState == LayoutNode.LayoutState.LayingOut) return true;
                list2 = this.postponedMeasureRequests;
                bl4 = false;
                list = list2;
                bl3 = false;
                n3 = ((Collection)list).size();
                for (n2 = 0; n2 < n3; ++n2) {
                    postponedRequest2 = postponedRequest3 = list.get(n2);
                    bl2 = false;
                    postponedRequest = postponedRequest2;
                    bl = false;
                    if (!Intrinsics.areEqual((Object)postponedRequest.getNode(), (Object)layoutNode)) continue;
                    return true;
                }
                boolean bl8 = false;
                if (bl8) return true;
                if (layoutNode.getLayoutState$ui() == LayoutNode.LayoutState.Measuring) return true;
                if (layoutNode.getLayoutState$ui() != LayoutNode.LayoutState.LayingOut) return false;
                return true;
            }
        }
        if (!Intrinsics.areEqual((Object)layoutNode.isPlacedInLookahead(), (Object)true)) return true;
        if (layoutNode.getLookaheadMeasurePending$ui()) {
            MeasureAndLayoutDelegate.PostponedRequest postponedRequest5;
            block23: {
                list2 = this.postponedMeasureRequests;
                bl4 = false;
                list = list2;
                bl3 = false;
                n3 = ((Collection)list).size();
                for (n2 = 0; n2 < n3; ++n2) {
                    postponedRequest2 = postponedRequest3 = list.get(n2);
                    bl2 = false;
                    postponedRequest = postponedRequest2;
                    bl = false;
                    if (!(Intrinsics.areEqual((Object)postponedRequest.getNode(), (Object)layoutNode) && postponedRequest.isLookahead())) continue;
                    postponedRequest5 = postponedRequest2;
                    break block23;
                }
                postponedRequest5 = null;
            }
            if (postponedRequest5 != null) {
                return true;
            }
        }
        if (layoutNode.getLookaheadMeasurePending$ui()) {
            boolean bl9;
            if (this.relayoutNodes.contains(layoutNode, true)) return true;
            LayoutNode layoutNode7 = layoutNode2;
            if (layoutNode7 != null) {
                if (layoutNode7.getLookaheadMeasurePending$ui()) {
                    return true;
                }
                bl9 = false;
            } else {
                bl9 = false;
            }
            if (bl9) return true;
            if (layoutState == LayoutNode.LayoutState.LookaheadMeasuring) return true;
            LayoutNode layoutNode8 = layoutNode2;
            if (layoutNode8 == null) return false;
            if (!layoutNode8.getMeasurePending$ui()) return false;
            boolean bl10 = true;
            if (!bl10) return false;
            if (!Intrinsics.areEqual((Object)layoutNode.getLookaheadRoot$ui(), (Object)layoutNode)) return false;
            return true;
        }
        if (!layoutNode.getLookaheadLayoutPending$ui()) return true;
        if (this.relayoutNodes.contains(layoutNode, true)) return true;
        if (layoutNode2 == null) return true;
        if (layoutNode2.getLookaheadMeasurePending$ui()) return true;
        if (layoutNode2.getLookaheadLayoutPending$ui()) return true;
        if (layoutState == LayoutNode.LayoutState.LookaheadMeasuring) return true;
        if (layoutState == LayoutNode.LayoutState.LookaheadLayingOut) return true;
        if (!layoutNode2.getLayoutPending$ui()) return false;
        if (!Intrinsics.areEqual((Object)layoutNode.getLookaheadRoot$ui(), (Object)layoutNode)) return false;
        return true;
    }

    private final String nodeToString(LayoutNode layoutNode) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        stringBuilder.append(layoutNode);
        stringBuilder.append("[" + layoutNode.getLayoutState$ui() + "]");
        if (!layoutNode.isPlaced()) {
            stringBuilder.append("[!isPlaced]");
        }
        stringBuilder.append("[measuredByParent=" + layoutNode.getMeasuredByParent$ui() + "]");
        if (!this.consistentLayoutState(layoutNode)) {
            stringBuilder.append("[INCONSISTENT]");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    private final String logTree() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Tree state:").append('\n');
        LayoutTreeConsistencyChecker.logTree$printSubTree(this, stringBuilder, this.root, 0);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    private static final void logTree$printSubTree(LayoutTreeConsistencyChecker layoutTreeConsistencyChecker, StringBuilder stringBuilder, LayoutNode layoutNode, int n2) {
        int n3 = 0;
        n3 = n2;
        String string = layoutTreeConsistencyChecker.nodeToString(layoutNode);
        if (((CharSequence)string).length() > 0) {
            for (int j = 0; j < n2; ++j) {
                stringBuilder.append("..");
            }
            stringBuilder.append(string).append('\n');
            ++n3;
        }
        List<LayoutNode> list = layoutNode.getChildren$ui();
        boolean bl = false;
        int n4 = ((Collection)list).size();
        for (int j = 0; j < n4; ++j) {
            LayoutNode layoutNode2;
            LayoutNode layoutNode3 = layoutNode2 = list.get(j);
            boolean bl2 = false;
            LayoutTreeConsistencyChecker.logTree$printSubTree(layoutTreeConsistencyChecker, stringBuilder, layoutNode3, n3);
        }
    }
}

