/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform;

import androidx.compose.ui.awt.Utils_desktopKt;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.platform.DesktopTextInputService2Kt;
import androidx.compose.ui.platform.PlatformComponent;
import androidx.compose.ui.platform.PlatformTextInputMethodRequest;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.input.TextEditingScope;
import androidx.compose.ui.text.input.TextEditorState;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputMethodEvent;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0016J\u001f\u0010)\u001a\u0004\u0018\u00010*2\u000e\u0010+\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010,H\u0016\u00a2\u0006\u0002\u0010.J\b\u0010/\u001a\u00020'H\u0016J\b\u00100\u001a\u00020'H\u0016J\u001d\u00101\u001a\u00020*2\u000e\u0010+\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010,H\u0016\u00a2\u0006\u0002\u0010.J\u0014\u00102\u001a\u0004\u0018\u0001032\b\u00104\u001a\u0004\u0018\u00010%H\u0016J-\u00105\u001a\u00020*2\u0006\u00106\u001a\u00020'2\u0006\u00107\u001a\u00020'2\u000e\u0010+\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010,H\u0016\u00a2\u0006\u0002\u00108J\u000e\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR\u001a\u0010!\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001b\"\u0004\b#\u0010\u001d\u00a8\u0006="}, d2={"Landroidx/compose/ui/platform/InputMethodSession;", "Ljava/awt/im/InputMethodRequests;", "component", "Landroidx/compose/ui/platform/PlatformComponent;", "request", "Landroidx/compose/ui/platform/PlatformTextInputMethodRequest;", "<init>", "(Landroidx/compose/ui/platform/PlatformComponent;Landroidx/compose/ui/platform/PlatformTextInputMethodRequest;)V", "state", "Landroidx/compose/ui/text/input/TextEditorState;", "getState", "()Landroidx/compose/ui/text/input/TextEditorState;", "selection", "Landroidx/compose/ui/text/TextRange;", "getSelection-d9O1mEE", "()J", "composition", "getComposition-MzsxiRA", "()Landroidx/compose/ui/text/TextRange;", "value", "", "imeComposingText", "getImeComposingText", "()Ljava/lang/String;", "ignoreNextInputMethodEvent", "", "getIgnoreNextInputMethodEvent", "()Z", "setIgnoreNextInputMethodEvent", "(Z)V", "charKeyPressed", "getCharKeyPressed", "setCharKeyPressed", "needToDeletePreviousChar", "getNeedToDeletePreviousChar", "setNeedToDeletePreviousChar", "getLocationOffset", "Ljava/awt/font/TextHitInfo;", "x", "", "y", "cancelLatestCommittedText", "Ljava/text/AttributedCharacterIterator;", "attributes", "", "Ljava/text/AttributedCharacterIterator$Attribute;", "([Ljava/text/AttributedCharacterIterator$Attribute;)Ljava/text/AttributedCharacterIterator;", "getInsertPositionOffset", "getCommittedTextLength", "getSelectedText", "getTextLocation", "Ljava/awt/Rectangle;", "offset", "getCommittedText", "beginIndex", "endIndex", "(II[Ljava/text/AttributedCharacterIterator$Attribute;)Ljava/text/AttributedCharacterIterator;", "inputMethodTextChanged", "", "event", "Ljava/awt/event/InputMethodEvent;", "ui"})
final class InputMethodSession
implements InputMethodRequests {
    private final PlatformComponent component;
    private final PlatformTextInputMethodRequest request;
    private String imeComposingText;
    private boolean ignoreNextInputMethodEvent;
    private boolean charKeyPressed;
    private boolean needToDeletePreviousChar;

    public InputMethodSession(PlatformComponent platformComponent, PlatformTextInputMethodRequest platformTextInputMethodRequest) {
        Intrinsics.checkNotNullParameter((Object)platformComponent, (String)"");
        Intrinsics.checkNotNullParameter((Object)platformTextInputMethodRequest, (String)"");
        this.component = platformComponent;
        this.request = platformTextInputMethodRequest;
        this.imeComposingText = "";
    }

    private final TextEditorState getState() {
        return this.request.getState();
    }

    private final long getSelection-d9O1mEE() {
        return this.getState().getSelection-d9O1mEE();
    }

    private final TextRange getComposition-MzsxiRA() {
        return this.getState().getComposition-MzsxiRA();
    }

    public final String getImeComposingText() {
        return this.imeComposingText;
    }

    public final boolean getIgnoreNextInputMethodEvent() {
        return this.ignoreNextInputMethodEvent;
    }

    public final void setIgnoreNextInputMethodEvent(boolean bl) {
        this.ignoreNextInputMethodEvent = bl;
    }

    public final boolean getCharKeyPressed() {
        return this.charKeyPressed;
    }

    public final void setCharKeyPressed(boolean bl) {
        this.charKeyPressed = bl;
    }

    public final boolean getNeedToDeletePreviousChar() {
        return this.needToDeletePreviousChar;
    }

    public final void setNeedToDeletePreviousChar(boolean bl) {
        this.needToDeletePreviousChar = bl;
    }

    @Override
    public TextHitInfo getLocationOffset(int n2, int n3) {
        if (this.getComposition-MzsxiRA() != null) {
            return TextHitInfo.leading(0);
        }
        return null;
    }

    @Override
    public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributeArray) {
        return null;
    }

    @Override
    public int getInsertPositionOffset() {
        TextRange textRange = this.getComposition-MzsxiRA();
        int n2 = textRange != null ? TextRange.getStart-impl((long)textRange.unbox-impl()) : 0;
        TextRange textRange2 = this.getComposition-MzsxiRA();
        int n3 = textRange2 != null ? TextRange.getEnd-impl((long)textRange2.unbox-impl()) : 0;
        int n4 = TextRange.getStart-impl((long)this.getSelection-d9O1mEE());
        if (n4 < n2) {
            return n4;
        }
        if (n4 < n3) {
            return n2;
        }
        return n4 - (n3 - n2);
    }

    @Override
    public int getCommittedTextLength() {
        TextRange textRange = this.getComposition-MzsxiRA();
        return this.getState().length() - (textRange != null ? TextRange.getLength-impl((long)textRange.unbox-impl()) : 0);
    }

    @Override
    public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributeArray) {
        if (this.charKeyPressed && OsArch_jvmKt.getHostOs() == OS.MacOS) {
            this.needToDeletePreviousChar = true;
        }
        String string = TextRangeKt.substring-FDrldGo((CharSequence)((CharSequence)this.getState()), (long)this.getSelection-d9O1mEE());
        AttributedCharacterIterator attributedCharacterIterator = new AttributedString(string).getIterator();
        Intrinsics.checkNotNullExpressionValue((Object)attributedCharacterIterator, (String)"");
        return attributedCharacterIterator;
    }

    @Override
    public Rectangle getTextLocation(TextHitInfo textHitInfo) {
        Object object;
        block3: {
            block2: {
                object = (Rect)this.request.getFocusedRectInRoot().invoke();
                if (object == null) break block2;
                Rect rect = object;
                boolean bl = false;
                long l2 = rect.getTopCenter-F1C5BW0();
                boolean bl2 = false;
                long l3 = l2;
                boolean bl3 = false;
                int n2 = (int)(l3 >> 32);
                boolean bl4 = false;
                float f2 = Float.intBitsToFloat(n2);
                Rectangle rectangle = Utils_desktopKt.toAwtRectangleRounded(Rect.copy$default((Rect)rect, (float)f2, (float)0.0f, (float)f2, (float)0.0f, (int)10, null), this.component.getDensity());
                object = rectangle;
                if (rectangle != null) break block3;
            }
            return null;
        }
        Object object2 = object;
        Point point = this.component.getLocationOnScreen();
        ((Rectangle)object2).translate(point.x, point.y);
        return object2;
    }

    @Override
    public AttributedCharacterIterator getCommittedText(int n2, int n3, AttributedCharacterIterator.Attribute[] attributeArray) {
        TextRange textRange = this.getComposition-MzsxiRA();
        long l2 = TextRangeKt.TextRange((int)RangesKt.coerceAtMost((int)n2, (int)this.getState().length()), (int)RangesKt.coerceAtMost((int)n3, (int)this.getState().length()));
        if (textRange == null) {
            String string = TextRangeKt.substring-FDrldGo((CharSequence)((CharSequence)this.getState()), (long)l2);
            AttributedCharacterIterator attributedCharacterIterator = new AttributedString(string).getIterator();
            Intrinsics.checkNotNullExpressionValue((Object)attributedCharacterIterator, (String)"");
            return attributedCharacterIterator;
        }
        String string = TextRangeKt.substring-FDrldGo((CharSequence)((CharSequence)this.getState()), (long)TextRangeKt.TextRange((int)RangesKt.coerceAtMost((int)Math.min(TextRange.getMin-impl((long)l2), TextRange.getMin-impl((long)textRange.unbox-impl())), (int)this.getState().length()), (int)RangesKt.coerceAtMost((int)Math.max(TextRange.getMax-impl((long)l2), TextRange.getMax-impl((long)textRange.unbox-impl())), (int)this.getState().length())));
        AttributedCharacterIterator attributedCharacterIterator = new AttributedString(string).getIterator();
        Intrinsics.checkNotNullExpressionValue((Object)attributedCharacterIterator, (String)"");
        return attributedCharacterIterator;
    }

    public final void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
        String string;
        Intrinsics.checkNotNullParameter((Object)inputMethodEvent, (String)"");
        String string2 = DesktopTextInputService2Kt.getCommittedText(inputMethodEvent);
        this.imeComposingText = string = DesktopTextInputService2Kt.getComposingText(inputMethodEvent);
        if (this.ignoreNextInputMethodEvent) {
            this.ignoreNextInputMethodEvent = false;
            return;
        }
        this.request.getEditText().invoke(arg_0 -> InputMethodSession.inputMethodTextChanged$lambda$0(this, string, string2, arg_0));
    }

    private static final Unit inputMethodTextChanged$lambda$0(InputMethodSession inputMethodSession, String string, String string2, TextEditingScope textEditingScope) {
        Intrinsics.checkNotNullParameter((Object)textEditingScope, (String)"");
        if (inputMethodSession.needToDeletePreviousChar && TextRange.getMin-impl((long)inputMethodSession.getSelection-d9O1mEE()) > 0 && ((CharSequence)string).length() == 0) {
            inputMethodSession.needToDeletePreviousChar = false;
            textEditingScope.deleteSurroundingTextInCodePoints(1, 0);
        }
        textEditingScope.commitText((CharSequence)string2, 1);
        if (((CharSequence)string).length() > 0) {
            textEditingScope.setComposingText((CharSequence)string, 1);
        }
        return Unit.INSTANCE;
    }
}

