/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.semantics;

import androidx.b.D;
import androidx.b.k;
import androidx.b.l;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsNodeWithAdjustedBounds;
import androidx.compose.ui.semantics.SemanticsOwner;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsRegion;
import androidx.compose.ui.semantics.SemanticsRegion_skikoKt;
import androidx.compose.ui.unit.IntRect;
import androidx.compose.ui.unit.IntRectKt;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u001a\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a,\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00020\b*\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u0000\u001a\f\u0010\u000b\u001a\u00020\u0005*\u00020\u0002H\u0000\u001a.\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013*\u00020\u00032\u0006\u0010\u0015\u001a\u00020\t2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0017H\u0000\"\u001e\u0010\f\u001a\u00020\u0005*\u00020\u00028@X\u0080\u0004\u00a2\u0006\f\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\f\u0010\u000f\"\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"getAllSemanticsNodes", "", "Landroidx/compose/ui/semantics/SemanticsNode;", "Landroidx/compose/ui/semantics/SemanticsOwner;", "mergingEnabled", "", "skipDeactivatedNodes", "getAllSemanticsNodesToMap", "", "", "useUnmergedTree", "isImportantForAccessibility", "isHidden", "isHidden$annotations", "(Landroidx/compose/ui/semantics/SemanticsNode;)V", "(Landroidx/compose/ui/semantics/SemanticsNode;)Z", "DefaultFakeNodeBounds", "Landroidx/compose/ui/geometry/Rect;", "getAllUncoveredSemanticsNodesToIntObjectMap", "Landroidx/collection/IntObjectMap;", "Landroidx/compose/ui/semantics/SemanticsNodeWithAdjustedBounds;", "customRootNodeId", "shouldIgnoreNode", "Lkotlin/Function1;", "ui"})
public final class SemanticsOwnerKt {
    private static final Rect DefaultFakeNodeBounds = new Rect(0.0f, 0.0f, 10.0f, 10.0f);

    public static final List<SemanticsNode> getAllSemanticsNodes(SemanticsOwner semanticsOwner, boolean bl, boolean bl2) {
        Intrinsics.checkNotNullParameter((Object)semanticsOwner, (String)"");
        return CollectionsKt.toList((Iterable)SemanticsOwnerKt.getAllSemanticsNodesToMap(semanticsOwner, !bl, bl2).values());
    }

    public static /* synthetic */ List getAllSemanticsNodes$default(SemanticsOwner semanticsOwner, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl2 = true;
        }
        return SemanticsOwnerKt.getAllSemanticsNodes(semanticsOwner, bl, bl2);
    }

    @Deprecated(message="Use a new overload instead", level=DeprecationLevel.HIDDEN)
    public static final /* synthetic */ List getAllSemanticsNodes(SemanticsOwner semanticsOwner, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)semanticsOwner, (String)"");
        return SemanticsOwnerKt.getAllSemanticsNodes(semanticsOwner, bl, true);
    }

    public static final Map<Integer, SemanticsNode> getAllSemanticsNodesToMap(SemanticsOwner semanticsOwner, boolean bl, boolean bl2) {
        SemanticsNode semanticsNode;
        Intrinsics.checkNotNullParameter((Object)semanticsOwner, (String)"");
        Map map = new LinkedHashMap();
        SemanticsNode semanticsNode2 = semanticsNode = bl ? semanticsOwner.getUnmergedRootSemanticsNode() : semanticsOwner.getRootSemanticsNode();
        if (!bl2 || !semanticsNode.getLayoutNode$ui().isDeactivated()) {
            SemanticsOwnerKt.getAllSemanticsNodesToMap$findAllSemanticNodesRecursive(map, bl2, semanticsNode);
        }
        return map;
    }

    public static /* synthetic */ Map getAllSemanticsNodesToMap$default(SemanticsOwner semanticsOwner, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        if ((n2 & 2) != 0) {
            bl2 = true;
        }
        return SemanticsOwnerKt.getAllSemanticsNodesToMap(semanticsOwner, bl, bl2);
    }

    public static final boolean isImportantForAccessibility(SemanticsNode semanticsNode) {
        Intrinsics.checkNotNullParameter((Object)semanticsNode, (String)"");
        return !SemanticsOwnerKt.isHidden(semanticsNode) && (semanticsNode.getUnmergedConfig$ui().isMergingSemanticsOfDescendants() || semanticsNode.getUnmergedConfig$ui().containsImportantForAccessibility$ui());
    }

    public static final boolean isHidden(SemanticsNode semanticsNode) {
        Intrinsics.checkNotNullParameter((Object)semanticsNode, (String)"");
        return semanticsNode.isTransparent$ui() || semanticsNode.getUnmergedConfig$ui().contains(SemanticsProperties.INSTANCE.getHideFromAccessibility()) || semanticsNode.getUnmergedConfig$ui().contains(SemanticsProperties.INSTANCE.getInvisibleToUser());
    }

    public static /* synthetic */ void isHidden$annotations(SemanticsNode semanticsNode) {
    }

    public static final k<SemanticsNodeWithAdjustedBounds> getAllUncoveredSemanticsNodesToIntObjectMap(SemanticsOwner semanticsOwner, int n2, Function1<? super SemanticsNode, Boolean> function1) {
        Intrinsics.checkNotNullParameter((Object)semanticsOwner, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        String string = "getAllUncoveredSemanticsNodesToIntObjectMap";
        boolean bl = false;
        boolean bl2 = false;
        SemanticsNode semanticsNode = semanticsOwner.getUnmergedRootSemanticsNode();
        if (!semanticsNode.getLayoutNode$ui().isPlaced() || !semanticsNode.getLayoutNode$ui().isAttached()) {
            return l.a();
        }
        D d2 = new D(48);
        SemanticsRegion semanticsRegion = SemanticsRegion_skikoKt.SemanticsRegion();
        semanticsRegion.set(IntRectKt.roundToIntRect((Rect)semanticsNode.getBoundsInRoot()));
        SemanticsOwnerKt.getAllUncoveredSemanticsNodesToIntObjectMap$lambda$0$findAllSemanticNodesRecursive(semanticsRegion, semanticsNode, n2, (D<SemanticsNodeWithAdjustedBounds>)d2, function1, semanticsNode, SemanticsRegion_skikoKt.SemanticsRegion());
        return (k)d2;
    }

    private static final void getAllSemanticsNodesToMap$findAllSemanticNodesRecursive(Map<Integer, SemanticsNode> map, boolean bl, SemanticsNode semanticsNode) {
        map.put(semanticsNode.getId(), semanticsNode);
        List list = SemanticsNode.getChildren$ui$default(semanticsNode, false, false, !bl, 3, null);
        boolean bl2 = false;
        int n2 = ((Collection)list).size();
        for (int j = 0; j < n2; ++j) {
            Object e2 = list.get(j);
            SemanticsNode semanticsNode2 = (SemanticsNode)e2;
            boolean bl3 = false;
            SemanticsOwnerKt.getAllSemanticsNodesToMap$findAllSemanticNodesRecursive(map, bl, semanticsNode2);
        }
    }

    private static final void getAllUncoveredSemanticsNodesToIntObjectMap$lambda$0$findAllSemanticNodesRecursive(SemanticsRegion semanticsRegion, SemanticsNode semanticsNode, int n2, D<SemanticsNodeWithAdjustedBounds> d2, Function1<? super SemanticsNode, Boolean> function1, SemanticsNode semanticsNode2, SemanticsRegion semanticsRegion2) {
        int n3;
        boolean bl;
        boolean bl2 = bl = !semanticsNode2.getLayoutNode$ui().isPlaced() || !semanticsNode2.getLayoutNode$ui().isAttached();
        if (semanticsRegion.isEmpty() && semanticsNode2.getId() != semanticsNode.getId() || bl && !semanticsNode2.isFake$ui()) {
            return;
        }
        IntRect intRect = IntRectKt.roundToIntRect((Rect)semanticsNode2.getTouchBoundsInRoot());
        semanticsRegion2.set(intRect);
        int n4 = n3 = semanticsNode2.getId() == semanticsNode.getId() ? n2 : semanticsNode2.getId();
        if (semanticsRegion2.intersect(semanticsRegion)) {
            d2.a(n3, (Object)new SemanticsNodeWithAdjustedBounds(semanticsNode2, semanticsRegion2.getBounds()));
            List<SemanticsNode> list = semanticsNode2.getReplacedChildren$ui();
            for (int j = list.size() - 1; -1 < j; --j) {
                if (((Boolean)function1.invoke((Object)list.get(j))).booleanValue()) continue;
                SemanticsOwnerKt.getAllUncoveredSemanticsNodesToIntObjectMap$lambda$0$findAllSemanticNodesRecursive(semanticsRegion, semanticsNode, n2, d2, function1, list.get(j), semanticsRegion2);
            }
            if (SemanticsOwnerKt.isImportantForAccessibility(semanticsNode2)) {
                semanticsRegion.difference(intRect);
            }
        } else if (semanticsNode2.isFake$ui()) {
            SemanticsNode semanticsNode3 = semanticsNode2.getParent();
            Object object = semanticsNode3;
            Rect rect = (object != null && (object = ((SemanticsNode)object).getLayoutInfo()) != null ? object.isPlaced() : false) ? semanticsNode3.getBoundsInRoot() : DefaultFakeNodeBounds;
            d2.a(n3, (Object)new SemanticsNodeWithAdjustedBounds(semanticsNode2, IntRectKt.roundToIntRect((Rect)rect)));
        } else if (n3 == n2) {
            d2.a(n3, (Object)new SemanticsNodeWithAdjustedBounds(semanticsNode2, semanticsRegion2.getBounds()));
        }
    }
}

