/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.retain;

import androidx.b.K;
import androidx.b.N;
import androidx.b.S;
import androidx.b.X;
import androidx.compose.runtime.retain.RetainObserver;
import androidx.compose.runtime.retain.RetainedValuesStore;
import androidx.compose.runtime.retain.impl.PreconditionsKt;
import androidx.compose.runtime.retain.impl.SafeMultiValueMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fJ\u0006\u0010\u0011\u001a\u00020\u000fJ\b\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u000fH\u0016J\b\u0010\u0014\u001a\u00020\u000fH\u0002J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\nH\u0016J\u001a\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\n2\b\u0010\u0019\u001a\u0004\u0018\u00010\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Landroidx/compose/runtime/retain/ManagedRetainedValuesStore;", "Landroidx/compose/runtime/retain/RetainedValuesStore;", "<init>", "()V", "isEnabled", "", "isDisposed", "isContentComposed", "keptExitedValues", "Landroidx/compose/runtime/retain/impl/SafeMultiValueMap;", "", "Landroidx/collection/MutableScatterMap;", "isRetainingExitedValues", "()Z", "enableRetainingExitedValues", "", "disableRetainingExitedValues", "dispose", "onContentExitComposition", "onContentEnteredComposition", "purgeUnusedExitedValues", "consumeExitedValueOrDefault", "key", "defaultValue", "saveExitingValue", "value", "runtime-retain"})
public final class ManagedRetainedValuesStore
implements RetainedValuesStore {
    private boolean isEnabled = true;
    private boolean isDisposed;
    private boolean isContentComposed;
    private final N<Object, Object> keptExitedValues = SafeMultiValueMap.constructor-impl$default(null, 1, null);
    public static final int $stable = 8;

    public final boolean isRetainingExitedValues() {
        return this.isEnabled && !this.isContentComposed;
    }

    public final void enableRetainingExitedValues() {
        boolean bl = !this.isDisposed;
        boolean bl2 = false;
        if (!bl) {
            boolean bl3 = false;
            PreconditionsKt.throwIllegalStateException("Cannot call enableRetainingExitedValues on a disposed store");
        }
        this.isEnabled = true;
    }

    public final void disableRetainingExitedValues() {
        this.isEnabled = false;
        this.purgeUnusedExitedValues();
    }

    public final void dispose() {
        this.isDisposed = true;
        this.disableRetainingExitedValues();
    }

    @Override
    public void onContentExitComposition() {
        boolean bl;
        if (this.isDisposed) {
            return;
        }
        boolean bl2 = this.isContentComposed;
        boolean bl3 = false;
        if (!bl2) {
            bl = false;
            PreconditionsKt.throwIllegalStateException("ManagedValuesStore tried to leave composition twice. Is the store installed in multiple places?");
        }
        bl2 = SafeMultiValueMap.isEmpty-impl(this.keptExitedValues);
        bl3 = false;
        if (!bl2) {
            bl = false;
            PreconditionsKt.throwIllegalStateException("Attempted to start retaining exited values with pending exited values");
        }
        this.isContentComposed = false;
    }

    @Override
    public void onContentEnteredComposition() {
        if (this.isDisposed) {
            return;
        }
        boolean bl = !this.isContentComposed;
        boolean bl2 = false;
        if (!bl) {
            boolean bl3 = false;
            PreconditionsKt.throwIllegalStateException("ManagedValuesStore tried to enter composition twice. Did you attempt to install the same store multiple times or into two compositions?");
        }
        this.purgeUnusedExitedValues();
        this.isContentComposed = true;
    }

    private final void purgeUnusedExitedValues() {
        N<Object, Object> n = this.keptExitedValues;
        boolean bl = false;
        X x = (X)n;
        boolean bl2 = false;
        Object[] objectArray = x.c;
        X x2 = x;
        boolean bl3 = false;
        int n2 = 0;
        long[] lArray = x2.a;
        int n3 = lArray.length - 2;
        if (n2 <= n3) {
            while (true) {
                long l;
                long l2 = l = lArray[n2];
                int n4 = 0;
                if ((l2 & (l2 ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int n5 = 8 - (~(n2 - n3) >>> 31);
                    for (int i = 0; i < n5; ++i) {
                        long l3 = l & 0xFFL;
                        boolean bl4 = false;
                        if (l3 < 128L) {
                            boolean bl5;
                            Object object;
                            int n6 = n4 = (n2 << 3) + i;
                            boolean bl6 = false;
                            Object object2 = objectArray[n6];
                            boolean bl7 = false;
                            if (object2 instanceof K) {
                                Object object3 = object2;
                                Intrinsics.checkNotNull((Object)object3);
                                S s = (S)((K)object3);
                                boolean bl8 = false;
                                Object[] objectArray2 = s.a;
                                int n7 = s.b;
                                for (int j = 0; j < n7; ++j) {
                                    Object object4 = objectArray2[j];
                                    boolean bl9 = false;
                                    object = object4;
                                    bl5 = false;
                                    if (!(object instanceof RetainObserver)) continue;
                                    ((RetainObserver)object).onRetired();
                                }
                            } else {
                                object = object2;
                                bl5 = false;
                                if (object instanceof RetainObserver) {
                                    ((RetainObserver)object).onRetired();
                                }
                            }
                        }
                        l >>= 8;
                    }
                    if (n5 != 8) break;
                }
                if (n2 == n3) break;
                ++n2;
            }
        }
        SafeMultiValueMap.clear-impl(this.keptExitedValues);
    }

    @Override
    public Object consumeExitedValueOrDefault(Object object, Object object2) {
        return SafeMultiValueMap.removeLast-impl(this.keptExitedValues, object, object2);
    }

    @Override
    public void saveExitingValue(Object object, Object object2) {
        if (this.isRetainingExitedValues()) {
            SafeMultiValueMap.add-impl(this.keptExitedValues, object, object2);
        } else if (object2 instanceof RetainObserver) {
            ((RetainObserver)object2).onRetired();
        }
    }
}

