/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.DefaultHeaders;
import io.netty.handler.codec.http.CombinedHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValidationUtil;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersFactory;
import io.netty.util.internal.ObjectUtil;

public final class DefaultHttpHeadersFactory
implements HttpHeadersFactory {
    private static final DefaultHeaders.NameValidator<CharSequence> DEFAULT_NAME_VALIDATOR = new DefaultHeaders.NameValidator<CharSequence>(){

        public void validateName(CharSequence charSequence) {
            if (charSequence == null || charSequence.length() == 0) {
                throw new IllegalArgumentException("empty headers are not allowed [" + charSequence + ']');
            }
            int n = HttpHeaderValidationUtil.validateToken(charSequence);
            if (n != -1) {
                throw new IllegalArgumentException("a header name can only contain \"token\" characters, but found invalid character 0x" + Integer.toHexString(charSequence.charAt(n)) + " at index " + n + " of header '" + charSequence + "'.");
            }
        }
    };
    private static final DefaultHeaders.ValueValidator<CharSequence> DEFAULT_VALUE_VALIDATOR = new DefaultHeaders.ValueValidator<CharSequence>(){

        public void validate(CharSequence charSequence) {
            int n = HttpHeaderValidationUtil.validateValidHeaderValue(charSequence);
            if (n != -1) {
                throw new IllegalArgumentException("a header value contains prohibited character 0x" + Integer.toHexString(charSequence.charAt(n)) + " at index " + n + '.');
            }
        }
    };
    private static final DefaultHeaders.NameValidator<CharSequence> DEFAULT_TRAILER_NAME_VALIDATOR = new DefaultHeaders.NameValidator<CharSequence>(){

        public void validateName(CharSequence charSequence) {
            DEFAULT_NAME_VALIDATOR.validateName((Object)charSequence);
            if (HttpHeaderNames.CONTENT_LENGTH.contentEqualsIgnoreCase(charSequence) || HttpHeaderNames.TRANSFER_ENCODING.contentEqualsIgnoreCase(charSequence) || HttpHeaderNames.TRAILER.contentEqualsIgnoreCase(charSequence)) {
                throw new IllegalArgumentException("prohibited trailing header: " + charSequence);
            }
        }
    };
    private static final DefaultHeaders.NameValidator<CharSequence> NO_NAME_VALIDATOR = DefaultHeaders.NameValidator.NOT_NULL;
    private static final DefaultHeaders.ValueValidator<CharSequence> NO_VALUE_VALIDATOR = DefaultHeaders.ValueValidator.NO_VALIDATION;
    private static final DefaultHttpHeadersFactory DEFAULT = new DefaultHttpHeadersFactory(DEFAULT_NAME_VALIDATOR, DEFAULT_VALUE_VALIDATOR, false);
    private static final DefaultHttpHeadersFactory DEFAULT_TRAILER = new DefaultHttpHeadersFactory(DEFAULT_TRAILER_NAME_VALIDATOR, DEFAULT_VALUE_VALIDATOR, false);
    private static final DefaultHttpHeadersFactory DEFAULT_COMBINING = new DefaultHttpHeadersFactory(DefaultHttpHeadersFactory.DEFAULT.nameValidator, DefaultHttpHeadersFactory.DEFAULT.valueValidator, true);
    private static final DefaultHttpHeadersFactory DEFAULT_NO_VALIDATION = new DefaultHttpHeadersFactory(NO_NAME_VALIDATOR, NO_VALUE_VALIDATOR, false);
    private final DefaultHeaders.NameValidator<CharSequence> nameValidator;
    private final DefaultHeaders.ValueValidator<CharSequence> valueValidator;
    private final boolean combiningHeaders;

    private DefaultHttpHeadersFactory(DefaultHeaders.NameValidator<CharSequence> nameValidator, DefaultHeaders.ValueValidator<CharSequence> valueValidator, boolean bl) {
        this.nameValidator = (DefaultHeaders.NameValidator)ObjectUtil.checkNotNull(nameValidator, (String)"nameValidator");
        this.valueValidator = (DefaultHeaders.ValueValidator)ObjectUtil.checkNotNull(valueValidator, (String)"valueValidator");
        this.combiningHeaders = bl;
    }

    public static DefaultHttpHeadersFactory headersFactory() {
        return DEFAULT;
    }

    public static DefaultHttpHeadersFactory trailersFactory() {
        return DEFAULT_TRAILER;
    }

    @Override
    public HttpHeaders newHeaders() {
        if (this.isCombiningHeaders()) {
            return new CombinedHttpHeaders(this.getNameValidator(), this.getValueValidator());
        }
        return new DefaultHttpHeaders(this.getNameValidator(), this.getValueValidator());
    }

    @Override
    public HttpHeaders newEmptyHeaders() {
        if (this.isCombiningHeaders()) {
            return new CombinedHttpHeaders(this.getNameValidator(), this.getValueValidator(), 2);
        }
        return new DefaultHttpHeaders(this.getNameValidator(), this.getValueValidator(), 2);
    }

    public DefaultHttpHeadersFactory withNameValidation(boolean bl) {
        return this.withNameValidator(bl ? DEFAULT_NAME_VALIDATOR : NO_NAME_VALIDATOR);
    }

    public DefaultHttpHeadersFactory withNameValidator(DefaultHeaders.NameValidator<CharSequence> nameValidator) {
        if (this.nameValidator == ObjectUtil.checkNotNull(nameValidator, (String)"validator")) {
            return this;
        }
        if (nameValidator == DEFAULT_NAME_VALIDATOR && this.valueValidator == DEFAULT_VALUE_VALIDATOR) {
            return this.combiningHeaders ? DEFAULT_COMBINING : DEFAULT;
        }
        return new DefaultHttpHeadersFactory(nameValidator, this.valueValidator, this.combiningHeaders);
    }

    public DefaultHttpHeadersFactory withValueValidation(boolean bl) {
        return this.withValueValidator(bl ? DEFAULT_VALUE_VALIDATOR : NO_VALUE_VALIDATOR);
    }

    public DefaultHttpHeadersFactory withValueValidator(DefaultHeaders.ValueValidator<CharSequence> valueValidator) {
        if (this.valueValidator == ObjectUtil.checkNotNull(valueValidator, (String)"validator")) {
            return this;
        }
        if (this.nameValidator == DEFAULT_NAME_VALIDATOR && valueValidator == DEFAULT_VALUE_VALIDATOR) {
            return this.combiningHeaders ? DEFAULT_COMBINING : DEFAULT;
        }
        return new DefaultHttpHeadersFactory(this.nameValidator, valueValidator, this.combiningHeaders);
    }

    public DefaultHttpHeadersFactory withValidation(boolean bl) {
        if (this == DEFAULT && !bl) {
            return DEFAULT_NO_VALIDATION;
        }
        if (this == DEFAULT_NO_VALIDATION && bl) {
            return DEFAULT;
        }
        return this.withNameValidation(bl).withValueValidation(bl);
    }

    public DefaultHttpHeadersFactory withCombiningHeaders(boolean bl) {
        if (this.combiningHeaders == bl) {
            return this;
        }
        return new DefaultHttpHeadersFactory(this.nameValidator, this.valueValidator, bl);
    }

    public DefaultHeaders.NameValidator<CharSequence> getNameValidator() {
        return this.nameValidator;
    }

    public DefaultHeaders.ValueValidator<CharSequence> getValueValidator() {
        return this.valueValidator;
    }

    public boolean isCombiningHeaders() {
        return this.combiningHeaders;
    }

    public boolean isValidatingHeaderNames() {
        return this.nameValidator != NO_NAME_VALIDATOR;
    }

    public boolean isValidatingHeaderValues() {
        return this.valueValidator != NO_VALUE_VALIDATOR;
    }
}

