/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.MessageAggregator;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpExpectationFailedEvent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMessageUtil;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.TooLongHttpContentException;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public class HttpObjectAggregator
extends MessageAggregator<HttpObject, HttpMessage, HttpContent, FullHttpMessage> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(HttpObjectAggregator.class);
    private static final FullHttpResponse CONTINUE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE, Unpooled.EMPTY_BUFFER);
    private static final FullHttpResponse EXPECTATION_FAILED = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.EXPECTATION_FAILED, Unpooled.EMPTY_BUFFER);
    private static final FullHttpResponse TOO_LARGE_CLOSE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, Unpooled.EMPTY_BUFFER);
    private static final FullHttpResponse TOO_LARGE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, Unpooled.EMPTY_BUFFER);
    private final boolean closeOnExpectationFailed;

    public HttpObjectAggregator(int n) {
        this(n, false);
    }

    public HttpObjectAggregator(int n, boolean bl) {
        super(n);
        this.closeOnExpectationFailed = bl;
    }

    protected boolean isStartMessage(HttpObject httpObject) {
        return httpObject instanceof HttpMessage;
    }

    protected boolean isContentMessage(HttpObject httpObject) {
        return httpObject instanceof HttpContent;
    }

    protected boolean isLastContentMessage(HttpContent httpContent) {
        return httpContent instanceof LastHttpContent;
    }

    protected boolean isAggregated(HttpObject httpObject) {
        return httpObject instanceof FullHttpMessage;
    }

    protected boolean isContentLengthInvalid(HttpMessage httpMessage, int n) {
        try {
            return HttpUtil.getContentLength(httpMessage, -1L) > (long)n;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static Object continueResponse(HttpMessage httpMessage, int n, ChannelPipeline channelPipeline) {
        if (HttpUtil.isUnsupportedExpectation(httpMessage)) {
            channelPipeline.fireUserEventTriggered((Object)HttpExpectationFailedEvent.INSTANCE);
            return EXPECTATION_FAILED.retainedDuplicate();
        }
        if (HttpUtil.is100ContinueExpected(httpMessage)) {
            if (HttpUtil.getContentLength(httpMessage, -1L) <= (long)n) {
                return CONTINUE.retainedDuplicate();
            }
            channelPipeline.fireUserEventTriggered((Object)HttpExpectationFailedEvent.INSTANCE);
            return TOO_LARGE.retainedDuplicate();
        }
        return null;
    }

    protected Object newContinueResponse(HttpMessage httpMessage, int n, ChannelPipeline channelPipeline) {
        Object object = HttpObjectAggregator.continueResponse(httpMessage, n, channelPipeline);
        if (object != null) {
            httpMessage.headers().remove((CharSequence)HttpHeaderNames.EXPECT);
        }
        return object;
    }

    protected boolean closeAfterContinueResponse(Object object) {
        return this.closeOnExpectationFailed && this.ignoreContentAfterContinueResponse(object);
    }

    protected boolean ignoreContentAfterContinueResponse(Object object) {
        if (object instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)object;
            return httpResponse.status().codeClass().equals((Object)HttpStatusClass.CLIENT_ERROR);
        }
        return false;
    }

    protected FullHttpMessage beginAggregation(HttpMessage httpMessage, ByteBuf byteBuf) {
        AggregatedFullHttpMessage aggregatedFullHttpMessage;
        assert (!(httpMessage instanceof FullHttpMessage));
        HttpUtil.setTransferEncodingChunked(httpMessage, false);
        if (httpMessage instanceof HttpRequest) {
            aggregatedFullHttpMessage = new AggregatedFullHttpRequest((HttpRequest)httpMessage, byteBuf, null);
        } else if (httpMessage instanceof HttpResponse) {
            aggregatedFullHttpMessage = new AggregatedFullHttpResponse((HttpResponse)httpMessage, byteBuf, null);
        } else {
            throw new Error();
        }
        return aggregatedFullHttpMessage;
    }

    protected void aggregate(FullHttpMessage fullHttpMessage, HttpContent httpContent) {
        if (httpContent instanceof LastHttpContent) {
            ((AggregatedFullHttpMessage)fullHttpMessage).setTrailingHeaders(((LastHttpContent)httpContent).trailingHeaders());
        }
    }

    protected void finishAggregation(FullHttpMessage fullHttpMessage) {
        if (!HttpUtil.isContentLengthSet(fullHttpMessage)) {
            fullHttpMessage.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)String.valueOf(fullHttpMessage.content().readableBytes()));
        }
    }

    protected void handleOversizedMessage(final ChannelHandlerContext channelHandlerContext, HttpMessage httpMessage) {
        if (httpMessage instanceof HttpRequest) {
            if (httpMessage instanceof FullHttpMessage || !HttpUtil.is100ContinueExpected(httpMessage) && !HttpUtil.isKeepAlive(httpMessage)) {
                ChannelFuture channelFuture = channelHandlerContext.writeAndFlush((Object)TOO_LARGE_CLOSE.retainedDuplicate());
                channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture channelFuture) {
                        if (!channelFuture.isSuccess()) {
                            logger.debug("Failed to send a 413 Request Entity Too Large.", channelFuture.cause());
                        }
                        channelHandlerContext.close();
                    }
                });
            } else {
                channelHandlerContext.writeAndFlush((Object)TOO_LARGE.retainedDuplicate()).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture channelFuture) {
                        if (!channelFuture.isSuccess()) {
                            logger.debug("Failed to send a 413 Request Entity Too Large.", channelFuture.cause());
                            channelHandlerContext.close();
                        }
                    }
                });
            }
        } else {
            if (httpMessage instanceof HttpResponse) {
                channelHandlerContext.close();
                throw new TooLongHttpContentException("Response entity too large: " + httpMessage);
            }
            throw new IllegalStateException();
        }
    }

    static {
        EXPECTATION_FAILED.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        TOO_LARGE.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        TOO_LARGE_CLOSE.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        TOO_LARGE_CLOSE.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
    }

    private static final class AggregatedFullHttpResponse
    extends AggregatedFullHttpMessage
    implements FullHttpResponse {
        AggregatedFullHttpResponse(HttpResponse httpResponse, ByteBuf byteBuf, HttpHeaders httpHeaders) {
            super(httpResponse, byteBuf, httpHeaders);
        }

        @Override
        public FullHttpResponse copy() {
            return this.replace(this.content().copy());
        }

        @Override
        public FullHttpResponse duplicate() {
            return this.replace(this.content().duplicate());
        }

        @Override
        public FullHttpResponse retainedDuplicate() {
            return this.replace(this.content().retainedDuplicate());
        }

        @Override
        public FullHttpResponse replace(ByteBuf byteBuf) {
            DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(this.getProtocolVersion(), this.getStatus(), byteBuf, this.headers().copy(), this.trailingHeaders().copy());
            defaultFullHttpResponse.setDecoderResult(this.decoderResult());
            return defaultFullHttpResponse;
        }

        @Override
        public FullHttpResponse setStatus(HttpResponseStatus httpResponseStatus) {
            ((HttpResponse)this.message).setStatus(httpResponseStatus);
            return this;
        }

        @Override
        public HttpResponseStatus getStatus() {
            return ((HttpResponse)this.message).status();
        }

        @Override
        public HttpResponseStatus status() {
            return this.getStatus();
        }

        @Override
        public FullHttpResponse setProtocolVersion(HttpVersion httpVersion) {
            super.setProtocolVersion(httpVersion);
            return this;
        }

        @Override
        public FullHttpResponse retain(int n) {
            super.retain(n);
            return this;
        }

        @Override
        public FullHttpResponse retain() {
            super.retain();
            return this;
        }

        @Override
        public FullHttpResponse touch(Object object) {
            super.touch(object);
            return this;
        }

        @Override
        public FullHttpResponse touch() {
            super.touch();
            return this;
        }

        public String toString() {
            return HttpMessageUtil.appendFullResponse(new StringBuilder(256), this).toString();
        }
    }

    private static final class AggregatedFullHttpRequest
    extends AggregatedFullHttpMessage
    implements FullHttpRequest {
        AggregatedFullHttpRequest(HttpRequest httpRequest, ByteBuf byteBuf, HttpHeaders httpHeaders) {
            super(httpRequest, byteBuf, httpHeaders);
        }

        @Override
        public FullHttpRequest copy() {
            return this.replace(this.content().copy());
        }

        @Override
        public FullHttpRequest duplicate() {
            return this.replace(this.content().duplicate());
        }

        @Override
        public FullHttpRequest retainedDuplicate() {
            return this.replace(this.content().retainedDuplicate());
        }

        @Override
        public FullHttpRequest replace(ByteBuf byteBuf) {
            DefaultFullHttpRequest defaultFullHttpRequest = new DefaultFullHttpRequest(this.protocolVersion(), this.method(), this.uri(), byteBuf, this.headers().copy(), this.trailingHeaders().copy());
            defaultFullHttpRequest.setDecoderResult(this.decoderResult());
            return defaultFullHttpRequest;
        }

        @Override
        public FullHttpRequest retain(int n) {
            super.retain(n);
            return this;
        }

        @Override
        public FullHttpRequest retain() {
            super.retain();
            return this;
        }

        @Override
        public FullHttpRequest touch() {
            super.touch();
            return this;
        }

        @Override
        public FullHttpRequest touch(Object object) {
            super.touch(object);
            return this;
        }

        @Override
        public FullHttpRequest setMethod(HttpMethod httpMethod) {
            ((HttpRequest)this.message).setMethod(httpMethod);
            return this;
        }

        @Override
        public FullHttpRequest setUri(String string) {
            ((HttpRequest)this.message).setUri(string);
            return this;
        }

        @Override
        public HttpMethod getMethod() {
            return ((HttpRequest)this.message).method();
        }

        @Override
        public String getUri() {
            return ((HttpRequest)this.message).uri();
        }

        @Override
        public HttpMethod method() {
            return this.getMethod();
        }

        @Override
        public String uri() {
            return this.getUri();
        }

        @Override
        public FullHttpRequest setProtocolVersion(HttpVersion httpVersion) {
            super.setProtocolVersion(httpVersion);
            return this;
        }

        public String toString() {
            return HttpMessageUtil.appendFullRequest(new StringBuilder(256), this).toString();
        }
    }

    private static abstract class AggregatedFullHttpMessage
    implements FullHttpMessage {
        protected final HttpMessage message;
        private final ByteBuf content;
        private HttpHeaders trailingHeaders;

        AggregatedFullHttpMessage(HttpMessage httpMessage, ByteBuf byteBuf, HttpHeaders httpHeaders) {
            this.message = httpMessage;
            this.content = byteBuf;
            this.trailingHeaders = httpHeaders;
        }

        @Override
        public HttpHeaders trailingHeaders() {
            HttpHeaders httpHeaders = this.trailingHeaders;
            if (httpHeaders == null) {
                return EmptyHttpHeaders.INSTANCE;
            }
            return httpHeaders;
        }

        void setTrailingHeaders(HttpHeaders httpHeaders) {
            this.trailingHeaders = httpHeaders;
        }

        @Override
        public HttpVersion getProtocolVersion() {
            return this.message.protocolVersion();
        }

        @Override
        public HttpVersion protocolVersion() {
            return this.message.protocolVersion();
        }

        @Override
        public FullHttpMessage setProtocolVersion(HttpVersion httpVersion) {
            this.message.setProtocolVersion(httpVersion);
            return this;
        }

        @Override
        public HttpHeaders headers() {
            return this.message.headers();
        }

        public DecoderResult decoderResult() {
            return this.message.decoderResult();
        }

        @Override
        public DecoderResult getDecoderResult() {
            return this.message.decoderResult();
        }

        public void setDecoderResult(DecoderResult decoderResult) {
            this.message.setDecoderResult(decoderResult);
        }

        public ByteBuf content() {
            return this.content;
        }

        public int refCnt() {
            return this.content.refCnt();
        }

        @Override
        public FullHttpMessage retain() {
            this.content.retain();
            return this;
        }

        @Override
        public FullHttpMessage retain(int n) {
            this.content.retain(n);
            return this;
        }

        @Override
        public FullHttpMessage touch(Object object) {
            this.content.touch(object);
            return this;
        }

        @Override
        public FullHttpMessage touch() {
            this.content.touch();
            return this;
        }

        public boolean release() {
            return this.content.release();
        }

        public boolean release(int n) {
            return this.content.release(n);
        }

        @Override
        public abstract FullHttpMessage copy();

        @Override
        public abstract FullHttpMessage duplicate();

        @Override
        public abstract FullHttpMessage retainedDuplicate();
    }
}

