/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.PrematureChannelClosureException;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpDecoderConfig;
import io.netty.handler.codec.http.HttpExpectationFailedEvent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersFactory;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMessageDecoderResult;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.TooLongHttpHeaderException;
import io.netty.handler.codec.http.TooLongHttpLineException;
import io.netty.util.AsciiString;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class HttpObjectDecoder
extends ByteToMessageDecoder {
    public static final int DEFAULT_MAX_INITIAL_LINE_LENGTH = 4096;
    public static final int DEFAULT_MAX_HEADER_SIZE = 8192;
    public static final boolean DEFAULT_CHUNKED_SUPPORTED = true;
    public static final boolean DEFAULT_ALLOW_PARTIAL_CHUNKS = true;
    public static final int DEFAULT_MAX_CHUNK_SIZE = 8192;
    public static final boolean DEFAULT_VALIDATE_HEADERS = true;
    public static final int DEFAULT_INITIAL_BUFFER_SIZE = 128;
    public static final boolean DEFAULT_ALLOW_DUPLICATE_CONTENT_LENGTHS = false;
    private final int maxChunkSize;
    private final boolean chunkedSupported;
    private final boolean allowPartialChunks;
    @Deprecated
    protected final boolean validateHeaders;
    protected final HttpHeadersFactory headersFactory;
    protected final HttpHeadersFactory trailersFactory;
    private final boolean allowDuplicateContentLengths;
    private final ByteBuf parserScratchBuffer;
    private final HeaderParser headerParser;
    private final LineParser lineParser;
    private HttpMessage message;
    private long chunkSize;
    private long contentLength = Long.MIN_VALUE;
    private boolean chunked;
    private boolean isSwitchingToNonHttp1Protocol;
    private final AtomicBoolean resetRequested = new AtomicBoolean();
    private AsciiString name;
    private String value;
    private LastHttpContent trailer;
    private State currentState = State.SKIP_CONTROL_CHARS;
    private static final boolean[] SP_LENIENT_BYTES;
    private static final boolean[] LATIN_WHITESPACE;
    private static final boolean[] ISO_CONTROL_OR_WHITESPACE;
    private static final ByteProcessor SKIP_CONTROL_CHARS_BYTES;

    protected void handlerRemoved0(ChannelHandlerContext channelHandlerContext) {
        try {
            this.parserScratchBuffer.release();
        }
        finally {
            super.handlerRemoved0(channelHandlerContext);
        }
    }

    protected HttpObjectDecoder() {
        this(new HttpDecoderConfig());
    }

    @Deprecated
    protected HttpObjectDecoder(int n, int n2, int n3, boolean bl) {
        this(new HttpDecoderConfig().setMaxInitialLineLength(n).setMaxHeaderSize(n2).setMaxChunkSize(n3).setChunkedSupported(bl));
    }

    @Deprecated
    protected HttpObjectDecoder(int n, int n2, int n3, boolean bl, boolean bl2) {
        this(new HttpDecoderConfig().setMaxInitialLineLength(n).setMaxHeaderSize(n2).setMaxChunkSize(n3).setChunkedSupported(bl).setValidateHeaders(bl2));
    }

    @Deprecated
    protected HttpObjectDecoder(int n, int n2, int n3, boolean bl, boolean bl2, int n4) {
        this(new HttpDecoderConfig().setMaxInitialLineLength(n).setMaxHeaderSize(n2).setMaxChunkSize(n3).setChunkedSupported(bl).setValidateHeaders(bl2).setInitialBufferSize(n4));
    }

    @Deprecated
    protected HttpObjectDecoder(int n, int n2, int n3, boolean bl, boolean bl2, int n4, boolean bl3) {
        this(new HttpDecoderConfig().setMaxInitialLineLength(n).setMaxHeaderSize(n2).setMaxChunkSize(n3).setChunkedSupported(bl).setValidateHeaders(bl2).setInitialBufferSize(n4).setAllowDuplicateContentLengths(bl3));
    }

    @Deprecated
    protected HttpObjectDecoder(int n, int n2, int n3, boolean bl, boolean bl2, int n4, boolean bl3, boolean bl4) {
        this(new HttpDecoderConfig().setMaxInitialLineLength(n).setMaxHeaderSize(n2).setMaxChunkSize(n3).setChunkedSupported(bl).setValidateHeaders(bl2).setInitialBufferSize(n4).setAllowDuplicateContentLengths(bl3).setAllowPartialChunks(bl4));
    }

    protected HttpObjectDecoder(HttpDecoderConfig httpDecoderConfig) {
        ObjectUtil.checkNotNull((Object)httpDecoderConfig, (String)"config");
        this.parserScratchBuffer = Unpooled.buffer((int)httpDecoderConfig.getInitialBufferSize());
        this.lineParser = new LineParser(this.parserScratchBuffer, httpDecoderConfig.getMaxInitialLineLength());
        this.headerParser = new HeaderParser(this.parserScratchBuffer, httpDecoderConfig.getMaxHeaderSize());
        this.maxChunkSize = httpDecoderConfig.getMaxChunkSize();
        this.chunkedSupported = httpDecoderConfig.isChunkedSupported();
        this.headersFactory = httpDecoderConfig.getHeadersFactory();
        this.trailersFactory = httpDecoderConfig.getTrailersFactory();
        this.validateHeaders = this.isValidating(this.headersFactory);
        this.allowDuplicateContentLengths = httpDecoderConfig.isAllowDuplicateContentLengths();
        this.allowPartialChunks = httpDecoderConfig.isAllowPartialChunks();
    }

    protected boolean isValidating(HttpHeadersFactory httpHeadersFactory) {
        if (httpHeadersFactory instanceof DefaultHttpHeadersFactory) {
            DefaultHttpHeadersFactory defaultHttpHeadersFactory = (DefaultHttpHeadersFactory)httpHeadersFactory;
            return defaultHttpHeadersFactory.isValidatingHeaderNames() || defaultHttpHeadersFactory.isValidatingHeaderValues();
        }
        return true;
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        if (this.resetRequested.get()) {
            this.resetNow();
        }
        switch (this.currentState) {
            case SKIP_CONTROL_CHARS: 
            case READ_INITIAL: {
                State state;
                try {
                    state = this.lineParser.parse(byteBuf);
                    if (state == null) {
                        return;
                    }
                    String[] stringArray = this.splitInitialLine((ByteBuf)state);
                    assert (stringArray.length == 3) : "initialLine::length must be 3";
                    this.message = this.createMessage(stringArray);
                    this.currentState = State.READ_HEADER;
                }
                catch (Exception exception) {
                    list.add(this.invalidMessage(this.message, byteBuf, exception));
                    return;
                }
            }
            case READ_HEADER: {
                State state;
                try {
                    state = this.readHeaders(byteBuf);
                    if (state == null) {
                        return;
                    }
                    this.currentState = state;
                    switch (state) {
                        case SKIP_CONTROL_CHARS: {
                            this.addCurrentMessage(list);
                            list.add(LastHttpContent.EMPTY_LAST_CONTENT);
                            this.resetNow();
                            return;
                        }
                        case READ_CHUNK_SIZE: {
                            if (!this.chunkedSupported) {
                                throw new IllegalArgumentException("Chunked messages not supported");
                            }
                            this.addCurrentMessage(list);
                            return;
                        }
                    }
                    if (this.contentLength == 0L || this.contentLength == -1L && this.isDecodingRequest()) {
                        this.addCurrentMessage(list);
                        list.add(LastHttpContent.EMPTY_LAST_CONTENT);
                        this.resetNow();
                        return;
                    }
                    assert (state == State.READ_FIXED_LENGTH_CONTENT || state == State.READ_VARIABLE_LENGTH_CONTENT);
                    this.addCurrentMessage(list);
                    if (state == State.READ_FIXED_LENGTH_CONTENT) {
                        this.chunkSize = this.contentLength;
                    }
                    return;
                }
                catch (Exception exception) {
                    list.add(this.invalidMessage(this.message, byteBuf, exception));
                    return;
                }
            }
            case READ_VARIABLE_LENGTH_CONTENT: {
                int n = Math.min(byteBuf.readableBytes(), this.maxChunkSize);
                if (n > 0) {
                    ByteBuf byteBuf2 = byteBuf.readRetainedSlice(n);
                    list.add(new DefaultHttpContent(byteBuf2));
                }
                return;
            }
            case READ_FIXED_LENGTH_CONTENT: {
                int n = byteBuf.readableBytes();
                if (n == 0) {
                    return;
                }
                int n2 = Math.min(n, this.maxChunkSize);
                if ((long)n2 > this.chunkSize) {
                    n2 = (int)this.chunkSize;
                }
                ByteBuf byteBuf3 = byteBuf.readRetainedSlice(n2);
                this.chunkSize -= (long)n2;
                if (this.chunkSize == 0L) {
                    list.add(new DefaultLastHttpContent(byteBuf3, this.trailersFactory));
                    this.resetNow();
                } else {
                    list.add(new DefaultHttpContent(byteBuf3));
                }
                return;
            }
            case READ_CHUNK_SIZE: {
                try {
                    ByteBuf byteBuf4 = this.lineParser.parse(byteBuf);
                    if (byteBuf4 == null) {
                        return;
                    }
                    int n = HttpObjectDecoder.getChunkSize(byteBuf4.array(), byteBuf4.arrayOffset() + byteBuf4.readerIndex(), byteBuf4.readableBytes());
                    this.chunkSize = n;
                    if (n == 0) {
                        this.currentState = State.READ_CHUNK_FOOTER;
                        return;
                    }
                    this.currentState = State.READ_CHUNKED_CONTENT;
                }
                catch (Exception exception) {
                    list.add(this.invalidChunk(byteBuf, exception));
                    return;
                }
            }
            case READ_CHUNKED_CONTENT: {
                assert (this.chunkSize <= Integer.MAX_VALUE);
                int n = Math.min((int)this.chunkSize, this.maxChunkSize);
                if (!this.allowPartialChunks && byteBuf.readableBytes() < n) {
                    return;
                }
                if ((n = Math.min(n, byteBuf.readableBytes())) == 0) {
                    return;
                }
                DefaultHttpContent defaultHttpContent = new DefaultHttpContent(byteBuf.readRetainedSlice(n));
                this.chunkSize -= (long)n;
                list.add(defaultHttpContent);
                if (this.chunkSize != 0L) {
                    return;
                }
                this.currentState = State.READ_CHUNK_DELIMITER;
            }
            case READ_CHUNK_DELIMITER: {
                int n = byteBuf.writerIndex();
                int n3 = byteBuf.readerIndex();
                while (n > n3) {
                    byte by;
                    if ((by = byteBuf.getByte(n3++)) != 10) continue;
                    this.currentState = State.READ_CHUNK_SIZE;
                    break;
                }
                byteBuf.readerIndex(n3);
                return;
            }
            case READ_CHUNK_FOOTER: {
                try {
                    LastHttpContent lastHttpContent = this.readTrailingHeaders(byteBuf);
                    if (lastHttpContent == null) {
                        return;
                    }
                    list.add(lastHttpContent);
                    this.resetNow();
                    return;
                }
                catch (Exception exception) {
                    list.add(this.invalidChunk(byteBuf, exception));
                    return;
                }
            }
            case BAD_MESSAGE: {
                byteBuf.skipBytes(byteBuf.readableBytes());
                break;
            }
            case UPGRADED: {
                int n = byteBuf.readableBytes();
                if (n <= 0) break;
                list.add(byteBuf.readBytes(n));
                break;
            }
        }
    }

    protected void decodeLast(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        super.decodeLast(channelHandlerContext, byteBuf, list);
        if (this.resetRequested.get()) {
            this.resetNow();
        }
        switch (this.currentState) {
            case READ_VARIABLE_LENGTH_CONTENT: {
                if (!this.chunked && !byteBuf.isReadable()) {
                    list.add(LastHttpContent.EMPTY_LAST_CONTENT);
                    this.resetNow();
                }
                return;
            }
            case READ_HEADER: {
                list.add(this.invalidMessage(this.message, Unpooled.EMPTY_BUFFER, (Exception)new PrematureChannelClosureException("Connection closed before received headers")));
                this.resetNow();
                return;
            }
            case READ_CHUNK_SIZE: 
            case READ_FIXED_LENGTH_CONTENT: 
            case READ_CHUNKED_CONTENT: 
            case READ_CHUNK_DELIMITER: 
            case READ_CHUNK_FOOTER: {
                boolean bl;
                if (this.isDecodingRequest() || this.chunked) {
                    bl = true;
                } else {
                    boolean bl2 = bl = this.contentLength > 0L;
                }
                if (!bl) {
                    list.add(LastHttpContent.EMPTY_LAST_CONTENT);
                }
                this.resetNow();
                return;
            }
            case SKIP_CONTROL_CHARS: 
            case READ_INITIAL: 
            case BAD_MESSAGE: 
            case UPGRADED: {
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled state " + (Object)((Object)this.currentState));
            }
        }
    }

    public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object instanceof HttpExpectationFailedEvent) {
            switch (this.currentState) {
                case READ_CHUNK_SIZE: 
                case READ_VARIABLE_LENGTH_CONTENT: 
                case READ_FIXED_LENGTH_CONTENT: {
                    this.reset();
                    break;
                }
            }
        }
        super.userEventTriggered(channelHandlerContext, object);
    }

    private void addCurrentMessage(List<Object> list) {
        HttpMessage httpMessage = this.message;
        assert (httpMessage != null);
        this.message = null;
        list.add(httpMessage);
    }

    protected boolean isContentAlwaysEmpty(HttpMessage httpMessage) {
        if (httpMessage instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)httpMessage;
            HttpResponseStatus httpResponseStatus = httpResponse.status();
            int n = httpResponseStatus.code();
            HttpStatusClass httpStatusClass = httpResponseStatus.codeClass();
            if (httpStatusClass == HttpStatusClass.INFORMATIONAL) {
                return n != 101 || httpResponse.headers().contains((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ACCEPT) || !httpResponse.headers().contains((CharSequence)HttpHeaderNames.UPGRADE, (CharSequence)HttpHeaderValues.WEBSOCKET, true);
            }
            switch (n) {
                case 204: 
                case 304: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    protected boolean isSwitchingToNonHttp1Protocol(HttpResponse httpResponse) {
        if (httpResponse.status().code() != HttpResponseStatus.SWITCHING_PROTOCOLS.code()) {
            return false;
        }
        String string = httpResponse.headers().get((CharSequence)HttpHeaderNames.UPGRADE);
        return string == null || !string.contains(HttpVersion.HTTP_1_0.text()) && !string.contains(HttpVersion.HTTP_1_1.text());
    }

    public void reset() {
        this.resetRequested.lazySet(true);
    }

    private void resetNow() {
        this.message = null;
        this.name = null;
        this.value = null;
        this.contentLength = Long.MIN_VALUE;
        this.chunked = false;
        this.lineParser.reset();
        this.headerParser.reset();
        this.trailer = null;
        if (this.isSwitchingToNonHttp1Protocol) {
            this.isSwitchingToNonHttp1Protocol = false;
            this.currentState = State.UPGRADED;
            return;
        }
        this.resetRequested.lazySet(false);
        this.currentState = State.SKIP_CONTROL_CHARS;
    }

    private HttpMessage invalidMessage(HttpMessage httpMessage, ByteBuf byteBuf, Exception exception) {
        this.currentState = State.BAD_MESSAGE;
        this.message = null;
        this.trailer = null;
        byteBuf.skipBytes(byteBuf.readableBytes());
        if (httpMessage == null) {
            httpMessage = this.createInvalidMessage();
        }
        httpMessage.setDecoderResult(DecoderResult.failure((Throwable)exception));
        return httpMessage;
    }

    private HttpContent invalidChunk(ByteBuf byteBuf, Exception exception) {
        this.currentState = State.BAD_MESSAGE;
        this.message = null;
        this.trailer = null;
        byteBuf.skipBytes(byteBuf.readableBytes());
        DefaultLastHttpContent defaultLastHttpContent = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER);
        defaultLastHttpContent.setDecoderResult(DecoderResult.failure((Throwable)exception));
        return defaultLastHttpContent;
    }

    private State readHeaders(ByteBuf byteBuf) {
        String string;
        Object object;
        HttpMessage httpMessage = this.message;
        HttpHeaders httpHeaders = httpMessage.headers();
        HeaderParser headerParser = this.headerParser;
        ByteBuf byteBuf2 = headerParser.parse(byteBuf);
        if (byteBuf2 == null) {
            return null;
        }
        int n = byteBuf2.readableBytes();
        while (n > 0) {
            object = byteBuf2.array();
            int n2 = byteBuf2.arrayOffset() + byteBuf2.readerIndex();
            byte by = object[n2];
            if (this.name != null && (by == 32 || by == 9)) {
                String string2 = HttpObjectDecoder.langAsciiString(object, n2, n).trim();
                string = this.value;
                this.value = string + ' ' + string2;
            } else {
                if (this.name != null) {
                    httpHeaders.add((CharSequence)this.name, (Object)this.value);
                }
                this.splitHeader((byte[])object, n2, n);
            }
            byteBuf2 = headerParser.parse(byteBuf);
            if (byteBuf2 == null) {
                return null;
            }
            n = byteBuf2.readableBytes();
        }
        if (this.name != null) {
            httpHeaders.add((CharSequence)this.name, (Object)this.value);
        }
        this.name = null;
        this.value = null;
        object = (Object)new HttpMessageDecoderResult(this.lineParser.size, headerParser.size);
        httpMessage.setDecoderResult((DecoderResult)object);
        List<String> list = httpHeaders.getAll((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        if (!list.isEmpty()) {
            HttpVersion httpVersion = httpMessage.protocolVersion();
            boolean bl = httpVersion.majorVersion() < 1 || httpVersion.majorVersion() == 1 && httpVersion.minorVersion() == 0;
            this.contentLength = HttpUtil.normalizeAndGetContentLength(list, bl, this.allowDuplicateContentLengths);
            if (this.contentLength != -1L) {
                string = list.get(0).trim();
                if (list.size() > 1 || !string.equals(Long.toString(this.contentLength))) {
                    httpHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)this.contentLength);
                }
            }
        } else {
            this.contentLength = HttpUtil.getWebSocketContentLength(httpMessage);
        }
        if (!this.isDecodingRequest() && httpMessage instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)httpMessage;
            this.isSwitchingToNonHttp1Protocol = this.isSwitchingToNonHttp1Protocol(httpResponse);
        }
        if (this.isContentAlwaysEmpty(httpMessage)) {
            HttpUtil.setTransferEncodingChunked(httpMessage, false);
            return State.SKIP_CONTROL_CHARS;
        }
        if (HttpUtil.isTransferEncodingChunked(httpMessage)) {
            this.chunked = true;
            if (!list.isEmpty() && httpMessage.protocolVersion() == HttpVersion.HTTP_1_1) {
                this.handleTransferEncodingChunkedWithContentLength(httpMessage);
            }
            return State.READ_CHUNK_SIZE;
        }
        if (this.contentLength >= 0L) {
            return State.READ_FIXED_LENGTH_CONTENT;
        }
        return State.READ_VARIABLE_LENGTH_CONTENT;
    }

    protected void handleTransferEncodingChunkedWithContentLength(HttpMessage httpMessage) {
        httpMessage.headers().remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        this.contentLength = Long.MIN_VALUE;
    }

    private LastHttpContent readTrailingHeaders(ByteBuf byteBuf) {
        HeaderParser headerParser = this.headerParser;
        ByteBuf byteBuf2 = headerParser.parse(byteBuf);
        if (byteBuf2 == null) {
            return null;
        }
        LastHttpContent lastHttpContent = this.trailer;
        int n = byteBuf2.readableBytes();
        if (n == 0 && lastHttpContent == null) {
            return LastHttpContent.EMPTY_LAST_CONTENT;
        }
        AsciiString asciiString = null;
        if (lastHttpContent == null) {
            lastHttpContent = this.trailer = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER, this.trailersFactory);
        }
        while (n > 0) {
            AsciiString asciiString2;
            byte[] byArray = byteBuf2.array();
            int n2 = byteBuf2.arrayOffset() + byteBuf2.readerIndex();
            byte by = byArray[n2];
            if (asciiString != null && (by == 32 || by == 9)) {
                asciiString2 = lastHttpContent.trailingHeaders().getAll((CharSequence)asciiString);
                if (!asciiString2.isEmpty()) {
                    int n3 = asciiString2.size() - 1;
                    String string = HttpObjectDecoder.langAsciiString(byArray, n2, byteBuf2.readableBytes()).trim();
                    String string2 = (String)asciiString2.get(n3);
                    asciiString2.set(n3, string2 + string);
                }
            } else {
                this.splitHeader(byArray, n2, n);
                asciiString2 = this.name;
                if (!(HttpHeaderNames.CONTENT_LENGTH.contentEqualsIgnoreCase((CharSequence)asciiString2) || HttpHeaderNames.TRANSFER_ENCODING.contentEqualsIgnoreCase((CharSequence)asciiString2) || HttpHeaderNames.TRAILER.contentEqualsIgnoreCase((CharSequence)asciiString2))) {
                    lastHttpContent.trailingHeaders().add((CharSequence)asciiString2, (Object)this.value);
                }
                asciiString = this.name;
                this.name = null;
                this.value = null;
            }
            byteBuf2 = headerParser.parse(byteBuf);
            if (byteBuf2 == null) {
                return null;
            }
            n = byteBuf2.readableBytes();
        }
        this.trailer = null;
        return lastHttpContent;
    }

    protected abstract boolean isDecodingRequest();

    protected abstract HttpMessage createMessage(String[] var1);

    protected abstract HttpMessage createInvalidMessage();

    private static int skipWhiteSpaces(byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            if (HttpObjectDecoder.isWhitespace(byArray[n + i])) continue;
            return i;
        }
        return n2;
    }

    private static int getChunkSize(byte[] byArray, int n, int n2) {
        int n3 = HttpObjectDecoder.skipWhiteSpaces(byArray, n, n2);
        if (n3 == n2) {
            throw new NumberFormatException();
        }
        n += n3;
        n2 -= n3;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5 = StringUtil.decodeHexNibble((byte)byArray[n + i]);
            if (n5 == -1) {
                byte by = byArray[n + i];
                if (by == 59 || HttpObjectDecoder.isControlOrWhitespaceAsciiChar(by)) {
                    if (i == 0) {
                        throw new NumberFormatException("Empty chunk size");
                    }
                    return n4;
                }
                throw new NumberFormatException("Invalid character in chunk size");
            }
            n4 *= 16;
            if ((n4 += n5) >= 0) continue;
            throw new NumberFormatException("Chunk size overflow: " + n4);
        }
        return n4;
    }

    private String[] splitInitialLine(ByteBuf byteBuf) {
        int n;
        int n2;
        int n3;
        byte[] byArray = byteBuf.array();
        byte by = byArray[(n3 = (n2 = (n = byteBuf.arrayOffset()) + byteBuf.readerIndex()) + byteBuf.readableBytes()) - 1];
        if (HttpObjectDecoder.isControlOrWhitespaceAsciiChar(by) && (this.isDecodingRequest() || !HttpObjectDecoder.isOWS(by))) {
            throw new IllegalArgumentException("Illegal character in request line: 0x" + Integer.toHexString(by));
        }
        int n4 = HttpObjectDecoder.findNonSPLenient(byArray, n2, n3);
        int n5 = HttpObjectDecoder.findSPLenient(byArray, n4, n3);
        int n6 = HttpObjectDecoder.findNonSPLenient(byArray, n5, n3);
        int n7 = HttpObjectDecoder.findSPLenient(byArray, n6, n3);
        int n8 = HttpObjectDecoder.findNonSPLenient(byArray, n7, n3);
        int n9 = HttpObjectDecoder.findEndOfString(byArray, Math.max(n8 - 1, n2), n3);
        return new String[]{this.splitFirstWordInitialLine(byArray, n4, n5 - n4), this.splitSecondWordInitialLine(byArray, n6, n7 - n6), n8 < n9 ? this.splitThirdWordInitialLine(byArray, n8, n9 - n8) : ""};
    }

    protected String splitFirstWordInitialLine(byte[] byArray, int n, int n2) {
        return HttpObjectDecoder.langAsciiString(byArray, n, n2);
    }

    protected String splitSecondWordInitialLine(byte[] byArray, int n, int n2) {
        return HttpObjectDecoder.langAsciiString(byArray, n, n2);
    }

    protected String splitThirdWordInitialLine(byte[] byArray, int n, int n2) {
        return HttpObjectDecoder.langAsciiString(byArray, n, n2);
    }

    private static String langAsciiString(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return "";
        }
        if (n == 0) {
            if (n2 == byArray.length) {
                return new String(byArray, 0, 0, byArray.length);
            }
            return new String(byArray, 0, 0, n2);
        }
        return new String(byArray, 0, n, n2);
    }

    private void splitHeader(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        int n5 = n + n2;
        int n6 = n;
        boolean bl = this.isDecodingRequest();
        for (n4 = n6; n4 < n5 && (n3 = byArray[n4]) != 58 && (bl || !HttpObjectDecoder.isOWS((byte)n3)); ++n4) {
        }
        if (n4 == n5) {
            throw new IllegalArgumentException("No colon found");
        }
        for (n3 = n4; n3 < n5; ++n3) {
            if (byArray[n3] != 58) continue;
            ++n3;
            break;
        }
        this.name = this.splitHeaderName(byArray, n6, n4 - n6);
        int n7 = HttpObjectDecoder.findNonWhitespace(byArray, n3, n5);
        if (n7 == n5) {
            this.value = "";
        } else {
            int n8 = HttpObjectDecoder.findEndOfString(byArray, n, n5);
            this.value = HttpObjectDecoder.langAsciiString(byArray, n7, n8 - n7);
        }
    }

    protected AsciiString splitHeaderName(byte[] byArray, int n, int n2) {
        return new AsciiString(byArray, n, n2, true);
    }

    private static int findNonSPLenient(byte[] byArray, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            byte by = byArray[i];
            if (HttpObjectDecoder.isSPLenient(by)) continue;
            if (HttpObjectDecoder.isWhitespace(by)) {
                throw new IllegalArgumentException("Invalid separator");
            }
            return i;
        }
        return n2;
    }

    private static int findSPLenient(byte[] byArray, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (!HttpObjectDecoder.isSPLenient(byArray[i])) continue;
            return i;
        }
        return n2;
    }

    private static boolean isSPLenient(byte by) {
        return SP_LENIENT_BYTES[by + 128];
    }

    private static boolean isWhitespace(byte by) {
        return LATIN_WHITESPACE[by + 128];
    }

    private static int findNonWhitespace(byte[] byArray, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            byte by = byArray[i];
            if (!HttpObjectDecoder.isWhitespace(by)) {
                return i;
            }
            if (HttpObjectDecoder.isOWS(by)) continue;
            throw new IllegalArgumentException("Invalid separator, only a single space or horizontal tab allowed, but received a '" + by + "' (0x" + Integer.toHexString(by) + ")");
        }
        return n2;
    }

    private static int findEndOfString(byte[] byArray, int n, int n2) {
        for (int i = n2 - 1; i > n; --i) {
            if (HttpObjectDecoder.isOWS(byArray[i])) continue;
            return i + 1;
        }
        return 0;
    }

    private static boolean isOWS(byte by) {
        return by == 32 || by == 9;
    }

    private static boolean isControlOrWhitespaceAsciiChar(byte by) {
        return ISO_CONTROL_OR_WHITESPACE[128 + by];
    }

    static {
        byte by;
        SP_LENIENT_BYTES = new boolean[256];
        HttpObjectDecoder.SP_LENIENT_BYTES[160] = true;
        HttpObjectDecoder.SP_LENIENT_BYTES[137] = true;
        HttpObjectDecoder.SP_LENIENT_BYTES[139] = true;
        HttpObjectDecoder.SP_LENIENT_BYTES[140] = true;
        HttpObjectDecoder.SP_LENIENT_BYTES[141] = true;
        LATIN_WHITESPACE = new boolean[256];
        for (by = -128; by < 127; by = (byte)((byte)(by + 1))) {
            HttpObjectDecoder.LATIN_WHITESPACE[128 + by] = Character.isWhitespace(by);
        }
        ISO_CONTROL_OR_WHITESPACE = new boolean[256];
        for (by = -128; by < 127; by = (byte)(by + 1)) {
            HttpObjectDecoder.ISO_CONTROL_OR_WHITESPACE[128 + by] = Character.isISOControl(by) || HttpObjectDecoder.isWhitespace(by);
        }
        SKIP_CONTROL_CHARS_BYTES = new ByteProcessor(){

            public boolean process(byte by) {
                return ISO_CONTROL_OR_WHITESPACE[128 + by];
            }
        };
    }

    private final class LineParser
    extends HeaderParser {
        LineParser(ByteBuf byteBuf, int n) {
            super(byteBuf, n);
        }

        @Override
        public ByteBuf parse(ByteBuf byteBuf) {
            this.reset();
            int n = byteBuf.readableBytes();
            if (n == 0) {
                return null;
            }
            int n2 = byteBuf.readerIndex();
            if (HttpObjectDecoder.this.currentState == State.SKIP_CONTROL_CHARS && this.skipControlChars(byteBuf, n, n2)) {
                return null;
            }
            return super.parse(byteBuf);
        }

        private boolean skipControlChars(ByteBuf byteBuf, int n, int n2) {
            assert (HttpObjectDecoder.this.currentState == State.SKIP_CONTROL_CHARS);
            int n3 = Math.min(this.maxLength, n);
            int n4 = byteBuf.forEachByte(n2, n3, SKIP_CONTROL_CHARS_BYTES);
            if (n4 == -1) {
                byteBuf.skipBytes(n3);
                if (n > this.maxLength) {
                    throw this.newException(this.maxLength);
                }
                return true;
            }
            byteBuf.readerIndex(n4);
            HttpObjectDecoder.this.currentState = State.READ_INITIAL;
            return false;
        }

        @Override
        protected TooLongFrameException newException(int n) {
            return new TooLongHttpLineException("An HTTP line is larger than " + n + " bytes.");
        }
    }

    private static class HeaderParser {
        protected final ByteBuf seq;
        protected final int maxLength;
        int size;

        HeaderParser(ByteBuf byteBuf, int n) {
            this.seq = byteBuf;
            this.maxLength = n;
        }

        public ByteBuf parse(ByteBuf byteBuf) {
            int n = byteBuf.readableBytes();
            int n2 = byteBuf.readerIndex();
            int n3 = this.maxLength - this.size;
            assert (n3 >= 0);
            long l = (long)n3 + 2L;
            int n4 = (int)Math.min(l, (long)n);
            int n5 = n2 + n4;
            assert (n5 >= n2);
            int n6 = byteBuf.indexOf(n2, n5, (byte)10);
            if (n6 == -1) {
                if (n > n3) {
                    throw this.newException(this.maxLength);
                }
                return null;
            }
            int n7 = n6 > n2 && byteBuf.getByte(n6 - 1) == 13 ? n6 - 1 : n6;
            int n8 = n7 - n2;
            if (n8 == 0) {
                this.seq.clear();
                byteBuf.readerIndex(n6 + 1);
                return this.seq;
            }
            int n9 = this.size + n8;
            if (n9 > this.maxLength) {
                throw this.newException(this.maxLength);
            }
            this.size = n9;
            this.seq.clear();
            this.seq.writeBytes(byteBuf, n2, n8);
            byteBuf.readerIndex(n6 + 1);
            return this.seq;
        }

        public void reset() {
            this.size = 0;
        }

        protected TooLongFrameException newException(int n) {
            return new TooLongHttpHeaderException("HTTP header is larger than " + n + " bytes.");
        }
    }

    private static enum State {
        SKIP_CONTROL_CHARS,
        READ_INITIAL,
        READ_HEADER,
        READ_VARIABLE_LENGTH_CONTENT,
        READ_FIXED_LENGTH_CONTENT,
        READ_CHUNK_SIZE,
        READ_CHUNKED_CONTENT,
        READ_CHUNK_DELIMITER,
        READ_CHUNK_FOOTER,
        BAD_MESSAGE,
        UPGRADED;

    }
}

