/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.HttpConstants;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.net.URI;
import java.nio.charset.Charset;

public class QueryStringEncoder {
    private final Charset charset;
    private final StringBuilder uriBuilder;
    private boolean hasParams;
    private static final byte WRITE_UTF_UNKNOWN = 63;
    private static final char[] CHAR_MAP = "0123456789ABCDEF".toCharArray();

    public QueryStringEncoder(String string) {
        this(string, HttpConstants.DEFAULT_CHARSET);
    }

    public QueryStringEncoder(String string, Charset charset) {
        ObjectUtil.checkNotNull((Object)charset, (String)"charset");
        this.uriBuilder = new StringBuilder(string);
        this.charset = CharsetUtil.UTF_8.equals(charset) ? null : charset;
    }

    public void addParam(String string, String string2) {
        ObjectUtil.checkNotNull((Object)string, (String)"name");
        if (this.hasParams) {
            this.uriBuilder.append('&');
        } else {
            this.uriBuilder.append('?');
            this.hasParams = true;
        }
        this.encodeComponent(string);
        if (string2 != null) {
            this.uriBuilder.append('=');
            this.encodeComponent(string2);
        }
    }

    private void encodeComponent(CharSequence charSequence) {
        if (this.charset == null) {
            this.encodeUtf8Component(charSequence);
        } else {
            this.encodeNonUtf8Component(charSequence);
        }
    }

    public URI toUri() {
        return new URI(this.toString());
    }

    public String toString() {
        return this.uriBuilder.toString();
    }

    private void encodeNonUtf8Component(CharSequence charSequence) {
        char[] cArray = null;
        int n = 0;
        int n2 = charSequence.length();
        while (n < n2) {
            byte[] byArray;
            char c = charSequence.charAt(n);
            if (QueryStringEncoder.dontNeedEncoding(c)) {
                this.uriBuilder.append(c);
                ++n;
                continue;
            }
            int n3 = 0;
            if (cArray == null) {
                cArray = new char[charSequence.length() - n];
            }
            do {
                cArray[n3] = c;
                ++n3;
            } while (++n < charSequence.length() && !QueryStringEncoder.dontNeedEncoding(c = charSequence.charAt(n)));
            for (byte by : byArray = new String(cArray, 0, n3).getBytes(this.charset)) {
                this.appendEncoded(by);
            }
        }
    }

    private void encodeUtf8Component(CharSequence charSequence) {
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            if (QueryStringEncoder.dontNeedEncoding(c)) continue;
            this.encodeUtf8Component(charSequence, i, n);
            return;
        }
        this.uriBuilder.append(charSequence);
    }

    private void encodeUtf8Component(CharSequence charSequence, int n, int n2) {
        if (n > 0) {
            this.uriBuilder.append(charSequence, 0, n);
        }
        this.encodeUtf8ComponentSlow(charSequence, n, n2);
    }

    private void encodeUtf8ComponentSlow(CharSequence charSequence, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            char c = charSequence.charAt(i);
            if (c < '\u0080') {
                if (QueryStringEncoder.dontNeedEncoding(c)) {
                    this.uriBuilder.append(c);
                    continue;
                }
                this.appendEncoded(c);
                continue;
            }
            if (c < '\u0800') {
                this.appendEncoded(0xC0 | c >> 6);
                this.appendEncoded(0x80 | c & 0x3F);
                continue;
            }
            if (StringUtil.isSurrogate((char)c)) {
                if (!Character.isHighSurrogate(c)) {
                    this.appendEncoded(63);
                    continue;
                }
                if (++i == charSequence.length()) {
                    this.appendEncoded(63);
                    break;
                }
                this.writeUtf8Surrogate(c, charSequence.charAt(i));
                continue;
            }
            this.appendEncoded(0xE0 | c >> 12);
            this.appendEncoded(0x80 | c >> 6 & 0x3F);
            this.appendEncoded(0x80 | c & 0x3F);
        }
    }

    private void writeUtf8Surrogate(char c, char c2) {
        if (!Character.isLowSurrogate(c2)) {
            this.appendEncoded(63);
            this.appendEncoded(Character.isHighSurrogate(c2) ? 63 : (int)c2);
            return;
        }
        int n = Character.toCodePoint(c, c2);
        this.appendEncoded(0xF0 | n >> 18);
        this.appendEncoded(0x80 | n >> 12 & 0x3F);
        this.appendEncoded(0x80 | n >> 6 & 0x3F);
        this.appendEncoded(0x80 | n & 0x3F);
    }

    private void appendEncoded(int n) {
        this.uriBuilder.append('%').append(QueryStringEncoder.forDigit(n >> 4)).append(QueryStringEncoder.forDigit(n));
    }

    private static char forDigit(int n) {
        return CHAR_MAP[n & 0xF];
    }

    private static boolean dontNeedEncoding(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.' || c == '*' || c == '~';
    }
}

