/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.channel.unix.Buffer;
import io.netty.channel.unix.Limits;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;

final class NativeLongArray {
    private ByteBuffer memory;
    private long memoryAddress;
    private int capacity;
    private int size;

    NativeLongArray(int n) {
        this.capacity = ObjectUtil.checkPositive((int)n, (String)"capacity");
        this.memory = Buffer.allocateDirectWithNativeOrder((int)NativeLongArray.calculateBufferCapacity(n));
        this.memoryAddress = Buffer.memoryAddress((ByteBuffer)this.memory);
    }

    private static int idx(int n) {
        return n * Limits.SIZEOF_JLONG;
    }

    private static int calculateBufferCapacity(int n) {
        return n * Limits.SIZEOF_JLONG;
    }

    void add(long l) {
        this.reallocIfNeeded();
        if (PlatformDependent.hasUnsafe()) {
            PlatformDependent.putLong((long)this.memoryOffset(this.size), (long)l);
        } else {
            this.memory.putLong(NativeLongArray.idx(this.size), l);
        }
        ++this.size;
    }

    void clear() {
        this.size = 0;
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    int size() {
        return this.size;
    }

    void free() {
        Buffer.free((ByteBuffer)this.memory);
        this.memoryAddress = 0L;
    }

    long memoryAddress() {
        return this.memoryAddress;
    }

    long memoryAddressEnd() {
        return this.memoryOffset(this.size);
    }

    private long memoryOffset(int n) {
        return this.memoryAddress + (long)NativeLongArray.idx(n);
    }

    private void reallocIfNeeded() {
        if (this.size == this.capacity) {
            int n = this.capacity <= 65536 ? this.capacity << 1 : this.capacity + this.capacity >> 1;
            ByteBuffer byteBuffer = Buffer.allocateDirectWithNativeOrder((int)NativeLongArray.calculateBufferCapacity(n));
            this.memory.position(0).limit(this.size);
            byteBuffer.put(this.memory);
            byteBuffer.position(0);
            Buffer.free((ByteBuffer)this.memory);
            this.memory = byteBuffer;
            this.memoryAddress = Buffer.memoryAddress((ByteBuffer)byteBuffer);
            this.capacity = n;
        }
    }

    public String toString() {
        return "memoryAddress: " + this.memoryAddress + " capacity: " + this.capacity + " size: " + this.size;
    }
}

