/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.network.tls.CipherSuite;
import io.ktor.network.tls.platform.PlatformVersionKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0013\u0010\u0002\u001a\u00020\u0001*\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003*\n\u0010\u0005\"\u00020\u00042\u00020\u0004*\n\u0010\u0007\"\u00020\u00062\u00020\u0006\u00a8\u0006\b"}, d2={"Lio/ktor/network/tls/CipherSuite;", "", "isSupported", "(Lio/ktor/network/tls/CipherSuite;)Z", "Ljavax/net/ssl/SSLException;", "TlsException", "Ljavax/net/ssl/SSLPeerUnverifiedException;", "TlsPeerUnverifiedException", "ktor-network-tls"})
public final class CipherSuitesJvmKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isSupported(CipherSuite cipherSuite) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)cipherSuite, (String)"");
            String string = PlatformVersionKt.getPlatformVersion().getMajor();
            switch (string.hashCode()) {
                case 46676283: {
                    if (!string.equals("1.6.0")) {
                        return true;
                    }
                    break block6;
                }
                case 46677244: {
                    if (string.equals("1.7.0")) break;
                    return true;
                }
                case 46678205: {
                    if (!string.equals("1.8.0")) return true;
                    if (PlatformVersionKt.getPlatformVersion().getMinor() >= 161) return true;
                    if (cipherSuite.getKeyStrength() > 128) return false;
                    return true;
                }
            }
            if (PlatformVersionKt.getPlatformVersion().getMinor() >= 171) return true;
            if (cipherSuite.getKeyStrength() > 128) return false;
            return true;
        }
        if (PlatformVersionKt.getPlatformVersion().getMinor() >= 181) return true;
        if (cipherSuite.getKeyStrength() > 128) return false;
        return true;
    }
}

