/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.http.IpParserKt;
import io.ktor.network.tls.TLSException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000,\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\u001a\u001f\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u001f\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\b\u0010\u0006\u001a\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u000b\u0010\f\u001a\u0019\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00000\r*\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a\u0019\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00000\r*\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000f\"\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013\"\u0014\u0010\u0014\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0013\u00a8\u0006\u0015"}, d2={"", "serverName", "Ljava/security/cert/X509Certificate;", "certificate", "", "verifyHostnameInCertificate", "(Ljava/lang/String;Ljava/security/cert/X509Certificate;)V", "ipString", "verifyIpInCertificate", "certificateHost", "", "matchHostnameWithCertificate", "(Ljava/lang/String;Ljava/lang/String;)Z", "", "hosts", "(Ljava/security/cert/X509Certificate;)Ljava/util/List;", "ips", "", "DNS_NAME_TYPE", "I", "IP_ADDRESS_TYPE", "ktor-network-tls"})
public final class HostnameUtilsKt {
    private static final int DNS_NAME_TYPE = 2;
    private static final int IP_ADDRESS_TYPE = 7;

    public static final void verifyHostnameInCertificate(String string, X509Certificate x509Certificate) {
        boolean bl;
        List<String> list;
        block6: {
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            Intrinsics.checkNotNullParameter((Object)x509Certificate, (String)"");
            if (IpParserKt.hostIsIp((String)string)) {
                HostnameUtilsKt.verifyIpInCertificate(string, x509Certificate);
                return;
            }
            list = HostnameUtilsKt.hosts(x509Certificate);
            if (list.isEmpty()) {
                return;
            }
            Iterable iterable = list;
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object t : iterable) {
                    String string2 = (String)t;
                    boolean bl3 = false;
                    if (!HostnameUtilsKt.matchHostnameWithCertificate(string, string2)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        throw new TLSException("No server host: " + string + " in the server certificate. Provided in certificate: " + CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, null, (int)63, null), null, 2, null);
    }

    public static final void verifyIpInCertificate(String string, X509Certificate x509Certificate) {
        boolean bl;
        List list;
        block9: {
            Collection collection;
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            Intrinsics.checkNotNullParameter((Object)x509Certificate, (String)"");
            Iterable<List<Object>> iterable = x509Certificate.getSubjectAlternativeNames();
            if (iterable != null) {
                List list2;
                Object object2;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                Iterable string2 = iterable2;
                Iterable iterable3 = new ArrayList();
                boolean bl3 = false;
                for (Object object2 : string2) {
                    list2 = (List)object2;
                    boolean bl4 = false;
                    Object e = list2.get(0);
                    Intrinsics.checkNotNull(e);
                    if (!((Integer)e == 7)) continue;
                    iterable3.add(object2);
                }
                Iterable iterable5 = (List)iterable3;
                boolean bl5 = false;
                iterable3 = iterable5;
                collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable5, (int)10));
                boolean bl6 = false;
                object2 = iterable3.iterator();
                while (object2.hasNext()) {
                    List list3 = list2 = object2.next();
                    Collection collection2 = collection;
                    boolean bl7 = false;
                    Object e = list3.get(1);
                    Intrinsics.checkNotNull(e);
                    collection2.add((String)e);
                }
            } else {
                return;
            }
            list = (List)collection;
            if (list.isEmpty()) {
                return;
            }
            iterable = list;
            boolean bl8 = false;
            if (iterable instanceof Collection && iterable.isEmpty()) {
                bl = false;
            } else {
                for (Object e : iterable) {
                    String string2 = (String)e;
                    boolean bl9 = false;
                    if (!Intrinsics.areEqual((Object)string2, (Object)string)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        throw new TLSException("No server host: " + string + " in the server certificate. The certificate was issued for: " + CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, null, (int)63, null) + '.', null, 2, null);
    }

    public static final boolean matchHostnameWithCertificate(String string, String string2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        if (StringsKt.equals((String)string, (String)string2, (boolean)true)) {
            return true;
        }
        Object object = new char[]{'.'};
        List list = CollectionsKt.asReversed((List)StringsKt.split$default((CharSequence)string, (char[])object, (boolean)false, (int)0, (int)6, null));
        char[] cArray = new char[]{'.'};
        object = CollectionsKt.asReversed((List)StringsKt.split$default((CharSequence)string2, (char[])cArray, (boolean)false, (int)0, (int)6, null));
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        while (n < list.size() && n2 < object.size()) {
            String string3 = (String)list.get(n);
            if (n == 0 && ((CharSequence)string3).length() == 0) {
                ++n;
                continue;
            }
            String string4 = (String)object.get(n2);
            if (n2 == 0 && ((CharSequence)string4).length() == 0) {
                ++n2;
                continue;
            }
            if (!bl && StringsKt.equals((String)string3, (String)string4, (boolean)true)) {
                ++n3;
                ++n;
                ++n2;
                continue;
            }
            if (Intrinsics.areEqual((Object)string4, (Object)"*")) {
                bl = true;
                ++n;
                ++n2;
                continue;
            }
            return false;
        }
        boolean bl2 = !bl || n3 >= 2;
        return n == list.size() && n2 == object.size() && bl2;
    }

    private static final List<String> hosts(X509Certificate x509Certificate) {
        List list;
        Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
        if (collection != null) {
            List list2;
            Object object2;
            Iterable iterable = collection;
            boolean bl = false;
            Iterable iterable2 = iterable;
            Iterable iterable3 = new ArrayList();
            boolean bl2 = false;
            for (Object object2 : iterable2) {
                list2 = (List)object2;
                boolean bl3 = false;
                Object e = list2.get(0);
                Intrinsics.checkNotNull(e);
                if (!((Integer)e == 2)) continue;
                iterable3.add(object2);
            }
            Iterable iterable4 = (List)iterable3;
            boolean bl4 = false;
            iterable3 = iterable4;
            Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable4, (int)10));
            boolean bl5 = false;
            object2 = iterable3.iterator();
            while (object2.hasNext()) {
                List list3 = list2 = object2.next();
                Collection collection3 = collection2;
                boolean bl6 = false;
                Object e = list3.get(1);
                Intrinsics.checkNotNull(e);
                collection3.add((String)e);
            }
            list = (List)collection2;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final List<String> ips(X509Certificate x509Certificate) {
        List list;
        Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
        if (collection != null) {
            List list2;
            Object object2;
            Iterable iterable = collection;
            boolean bl = false;
            Iterable iterable2 = iterable;
            Iterable iterable3 = new ArrayList();
            boolean bl2 = false;
            for (Object object2 : iterable2) {
                list2 = (List)object2;
                boolean bl3 = false;
                Object e = list2.get(0);
                Intrinsics.checkNotNull(e);
                if (!((Integer)e == 7)) continue;
                iterable3.add(object2);
            }
            Iterable iterable4 = (List)iterable3;
            boolean bl4 = false;
            iterable3 = iterable4;
            Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable4, (int)10));
            boolean bl5 = false;
            object2 = iterable3.iterator();
            while (object2.hasNext()) {
                List list3 = list2 = object2.next();
                Collection collection3 = collection2;
                boolean bl6 = false;
                Object e = list3.get(1);
                Intrinsics.checkNotNull(e);
                collection3.add((String)e);
            }
            list = (List)collection2;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

