/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.network.tls.CertificateAndKey;
import io.ktor.network.tls.NoPrivateKeyException;
import io.ktor.network.tls.TLSConfigBuilder;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0019\u0010\u0003\u001a\u00020\u0002*\u00020\u00002\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a'\u0010\n\u001a\u00020\u0002*\u00020\u00002\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000b\u001a1\u0010\u0014\u001a\u00020\u0002*\u00020\u00002\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a\u000f\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lio/ktor/network/tls/TLSConfigBuilder;", "other", "", "takeFrom", "(Lio/ktor/network/tls/TLSConfigBuilder;Lio/ktor/network/tls/TLSConfigBuilder;)V", "", "Ljava/security/cert/X509Certificate;", "chain", "Ljava/security/PrivateKey;", "key", "addCertificateChain", "(Lio/ktor/network/tls/TLSConfigBuilder;[Ljava/security/cert/X509Certificate;Ljava/security/PrivateKey;)V", "Ljava/security/KeyStore;", "store", "", "password", "", "alias", "addKeyStoreNullablePassword", "(Lio/ktor/network/tls/TLSConfigBuilder;Ljava/security/KeyStore;[CLjava/lang/String;)V", "addKeyStore", "Ljavax/net/ssl/X509TrustManager;", "findTrustManager", "()Ljavax/net/ssl/X509TrustManager;", "ktor-network-tls"})
public final class TLSConfigBuilderKt {
    public static final void takeFrom(TLSConfigBuilder tLSConfigBuilder, TLSConfigBuilder tLSConfigBuilder2) {
        Intrinsics.checkNotNullParameter((Object)tLSConfigBuilder, (String)"");
        Intrinsics.checkNotNullParameter((Object)tLSConfigBuilder2, (String)"");
        CollectionsKt.addAll((Collection)tLSConfigBuilder.getCertificates(), (Iterable)tLSConfigBuilder2.getCertificates());
        tLSConfigBuilder.setRandom(tLSConfigBuilder2.getRandom());
        tLSConfigBuilder.setCipherSuites(tLSConfigBuilder2.getCipherSuites());
        tLSConfigBuilder.setServerName(tLSConfigBuilder2.getServerName());
        tLSConfigBuilder.setTrustManager(tLSConfigBuilder2.getTrustManager());
    }

    public static final void addCertificateChain(TLSConfigBuilder tLSConfigBuilder, X509Certificate[] x509CertificateArray, PrivateKey privateKey) {
        Intrinsics.checkNotNullParameter((Object)tLSConfigBuilder, (String)"");
        Intrinsics.checkNotNullParameter((Object)x509CertificateArray, (String)"");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"");
        ((Collection)tLSConfigBuilder.getCertificates()).add(new CertificateAndKey(x509CertificateArray, privateKey));
    }

    public static final void addKeyStoreNullablePassword(TLSConfigBuilder tLSConfigBuilder, KeyStore keyStore, char[] cArray, String string) {
        Object object;
        List list;
        boolean bl;
        Certificate[] certificateArray;
        Object object3;
        block12: {
            block11: {
                Intrinsics.checkNotNullParameter((Object)tLSConfigBuilder, (String)"");
                Intrinsics.checkNotNullParameter((Object)keyStore, (String)"");
                String string2 = KeyManagerFactory.getDefaultAlgorithm();
                Intrinsics.checkNotNull((Object)string2);
                String string3 = string2;
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(string3);
                Intrinsics.checkNotNull((Object)keyManagerFactory);
                KeyManagerFactory keyManagerFactory2 = keyManagerFactory;
                keyManagerFactory2.init(keyStore, cArray);
                KeyManager[] keyManagerArray = keyManagerFactory2.getKeyManagers();
                Intrinsics.checkNotNullExpressionValue((Object)keyManagerArray, (String)"");
                object3 = keyManagerArray;
                boolean bl2 = false;
                Object[] object2 = object3;
                certificateArray = new ArrayList();
                bl = false;
                for (Object object4 : object2) {
                    if (!(object4 instanceof X509KeyManager)) continue;
                    certificateArray.add(object4);
                }
                list = (List)certificateArray;
                object = string;
                if (object == null) break block11;
                certificateArray = object;
                bl = false;
                List list2 = CollectionsKt.listOf((Object)certificateArray);
                object = list2;
                if (list2 != null) break block12;
            }
            Enumeration<String> enumeration = keyStore.aliases();
            Intrinsics.checkNotNull(enumeration);
            ArrayList<String> arrayList = Collections.list(enumeration);
            Intrinsics.checkNotNullExpressionValue(arrayList, (String)"");
            object = arrayList;
        }
        object3 = object;
        Iterator iterator = object3.iterator();
        block1: while (iterator.hasNext()) {
            Object object5;
            String string3;
            block10: {
                boolean bl2;
                string3 = (String)iterator.next();
                Certificate[] certificateArray2 = certificateArray = keyStore.getCertificateChain(string3);
                if (certificateArray == null) {
                    bl = false;
                    String string4 = "Fail to get the certificate chain for this alias: " + string3;
                    throw new IllegalStateException(string4.toString());
                }
                Certificate[] string5 = certificateArray;
                int n2 = 0;
                int n3 = string5.length;
                for (int j = 0; j < n3; ++j) {
                    Certificate[] certificateArray3 = object5 = string5[j];
                    boolean bl3 = false;
                    if (certificateArray3 instanceof X509Certificate) continue;
                    bl2 = false;
                    break block10;
                }
                bl2 = bl = true;
            }
            if (!bl) {
                boolean bl4 = false;
                String string5 = "Fail to add key store " + keyStore + ". Only X509 certificate format supported.";
                throw new IllegalStateException(string5.toString());
            }
            for (X509KeyManager x509KeyManager : list) {
                Object object4;
                if (x509KeyManager.getPrivateKey(string3) == null) continue;
                object5 = certificateArray;
                boolean bl5 = false;
                Certificate[] certificateArray4 = object5;
                Collection collection = new ArrayList(((Certificate[])object5).length);
                boolean bl6 = false;
                int n4 = certificateArray4.length;
                for (int j = 0; j < n4; ++j) {
                    Certificate certificate;
                    Certificate certificate2 = certificate = certificateArray4[j];
                    Collection collection2 = collection;
                    boolean bl7 = false;
                    Intrinsics.checkNotNull((Object)certificate2);
                    collection2.add((X509Certificate)certificate2);
                }
                List list3 = (List)collection;
                object5 = list3;
                bl5 = false;
                certificateArray4 = object5;
                TLSConfigBuilderKt.addCertificateChain(tLSConfigBuilder, certificateArray4.toArray(new X509Certificate[0]), (PrivateKey)object4);
                continue block1;
            }
            throw new NoPrivateKeyException(string3, keyStore);
        }
    }

    public static /* synthetic */ void addKeyStoreNullablePassword$default(TLSConfigBuilder tLSConfigBuilder, KeyStore keyStore, char[] cArray, String string, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string = null;
        }
        TLSConfigBuilderKt.addKeyStoreNullablePassword(tLSConfigBuilder, keyStore, cArray, string);
    }

    private static final X509TrustManager findTrustManager() {
        TrustManager[] trustManagerArray;
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        Intrinsics.checkNotNull((Object)trustManagerFactory);
        TrustManagerFactory trustManagerFactory2 = trustManagerFactory;
        trustManagerFactory2.init((KeyStore)null);
        TrustManager[] trustManagerArray2 = trustManagerFactory2.getTrustManagers();
        Intrinsics.checkNotNull((Object)trustManagerArray2);
        TrustManager[] trustManagerArray3 = trustManagerArray = trustManagerArray2;
        boolean bl = false;
        TrustManager[] trustManagerArray4 = trustManagerArray3;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        for (TrustManager trustManager : trustManagerArray4) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            collection.add(trustManager);
        }
        return (X509TrustManager)CollectionsKt.first((List)((List)collection));
    }

    public static final /* synthetic */ X509TrustManager access$findTrustManager() {
        return TLSConfigBuilderKt.findTrustManager();
    }
}

