/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.java7;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.h.e.a;

public class XmppHostnameVerifier
implements HostnameVerifier {
    private static final Logger LOGGER = Logger.getLogger(XmppHostnameVerifier.class.getName());
    private static final int ALTNAME_DNS = 2;
    private static final int ALTNAME_IP = 7;

    @Override
    public boolean verify(String string, SSLSession sSLSession) {
        boolean bl = false;
        boolean bl2 = false;
        try {
            Certificate[] certificateArray = sSLSession.getPeerCertificates();
            if (certificateArray.length == 0) {
                return false;
            }
            if (!(certificateArray[0] instanceof X509Certificate)) {
                return false;
            }
            X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
            try {
                XmppHostnameVerifier.match(string, x509Certificate);
                bl = true;
            }
            catch (CertificateException certificateException) {
                LOGGER.log(Level.INFO, "Certificate does not match hostname", certificateException);
            }
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            Principal principal = null;
            try {
                principal = sSLSession.getPeerPrincipal();
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException2) {
                LOGGER.log(Level.INFO, "Can't verify principal for " + string + ". Not kerberos", sSLPeerUnverifiedException2);
            }
            if (principal instanceof KerberosPrincipal) {
                bl2 = XmppHostnameVerifier.match(string, (KerberosPrincipal)principal);
            }
            LOGGER.info("Can't verify principal for " + string + ". Not kerberos");
        }
        return bl || bl2;
    }

    private static void match(String string, X509Certificate x509Certificate) {
        if (a.e((CharSequence)string)) {
            XmppHostnameVerifier.matchIp(string, x509Certificate);
        } else {
            XmppHostnameVerifier.matchDns(string, x509Certificate);
        }
    }

    private static boolean match(String string, KerberosPrincipal kerberosPrincipal) {
        LOGGER.warning("KerberosPrincipal '" + kerberosPrincipal + "' validation not implemented yet. Can not verify " + string);
        return false;
    }

    private static void matchDns(String string, X509Certificate x509Certificate) {
        Cloneable cloneable;
        Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
        if (collection != null) {
            String string2;
            cloneable = new LinkedList();
            for (List<?> object : collection) {
                if ((Integer)object.get(0) != 2) continue;
                string2 = (String)object.get(1);
                if (XmppHostnameVerifier.matchesPerRfc2818(string, string2)) {
                    return;
                }
                cloneable.add(string2);
            }
            if (!cloneable.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder("No subject alternative DNS name matching " + string + " found. Tried: ");
                Iterator iterator = cloneable.iterator();
                while (iterator.hasNext()) {
                    string2 = (String)iterator.next();
                    stringBuilder.append(string2).append(',');
                }
                throw new CertificateException(stringBuilder.toString());
            }
        }
        cloneable = null;
        try {
            cloneable = new LdapName(x509Certificate.getSubjectX500Principal().getName());
        }
        catch (InvalidNameException invalidNameException) {
            LOGGER.warning("Invalid DN: " + invalidNameException.getMessage());
        }
        if (cloneable != null) {
            for (Rdn rdn : ((LdapName)cloneable).getRdns()) {
                if (!rdn.getType().equalsIgnoreCase("CN")) continue;
                if (!XmppHostnameVerifier.matchesPerRfc2818(string, rdn.getValue().toString())) break;
                return;
            }
        }
        throw new CertificateException("No name matching " + string + " found");
    }

    private static boolean matchesPerRfc2818(String string, String string2) {
        String[] stringArray;
        String[] stringArray2 = string.toLowerCase(Locale.US).split("\\.");
        if (stringArray2.length != (stringArray = string2.toLowerCase(Locale.US).split("\\.")).length) {
            return false;
        }
        for (int i = 0; i < stringArray2.length; ++i) {
            if (XmppHostnameVerifier.matchWildCards(stringArray2[i], stringArray[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean matchWildCards(String string, String string2) {
        int n = string2.indexOf("*");
        if (n == -1) {
            return string.equals(string2);
        }
        boolean bl = true;
        String string3 = string2;
        while (n != -1) {
            String string4 = string3.substring(0, n);
            string3 = string3.substring(n + 1);
            int n2 = string.indexOf(string4);
            if (n2 == -1 || bl && n2 != 0) {
                return false;
            }
            bl = false;
            string = string.substring(n2 + string4.length());
            n = string3.indexOf("*");
        }
        return string.endsWith(string3);
    }

    private static void matchIp(String string, X509Certificate x509Certificate) {
        Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
        if (collection == null) {
            throw new CertificateException("No subject alternative names present");
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (List<?> list : collection) {
            if ((Integer)list.get(0) != 7) continue;
            String string2 = (String)list.get(1);
            if (string.equalsIgnoreCase(string2)) {
                return;
            }
            try {
                if (InetAddress.getByName(string).equals(InetAddress.getByName(string2))) {
                    return;
                }
            }
            catch (SecurityException | UnknownHostException exception) {
                LOGGER.log(Level.FINE, "Comparing IP strings failed", exception);
            }
            linkedList.add(string2);
        }
        StringBuilder stringBuilder = new StringBuilder("No subject alternative names matching IP address " + string + " found. Tried: ");
        for (String string2 : linkedList) {
            stringBuilder.append(string2).append(',');
        }
        throw new CertificateException(stringBuilder.toString());
    }
}

