/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import org.jivesoftware.smack.AbstractXMPPConnection;

public class AsyncButOrdered<K> {
    private final Map<K, Queue<Runnable>> pendingRunnables = new WeakHashMap<K, Queue<Runnable>>();
    private final Map<K, Handler> threadActiveMap = new HashMap<K, Handler>();
    private final Executor executor;

    public AsyncButOrdered() {
        this(null);
    }

    public AsyncButOrdered(Executor executor) {
        this.executor = executor;
    }

    private void scheduleHandler(Handler handler) {
        if (this.executor == null) {
            AbstractXMPPConnection.asyncGo(handler);
        } else {
            this.executor.execute(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performAsyncButOrdered(K k, Runnable runnable) {
        Queue<Runnable> queue;
        Object object = this.pendingRunnables;
        synchronized (object) {
            queue = this.pendingRunnables.get(k);
            if (queue == null) {
                queue = new ConcurrentLinkedQueue<Runnable>();
                this.pendingRunnables.put(k, queue);
            }
        }
        queue.add(runnable);
        object = null;
        Map<K, Handler> map = this.threadActiveMap;
        synchronized (map) {
            if (!this.threadActiveMap.containsKey(k)) {
                object = new Handler(queue, k);
                this.threadActiveMap.put(k, (Handler)object);
            }
        }
        if (object != null) {
            this.scheduleHandler((Handler)object);
            return true;
        }
        return false;
    }

    public Executor asExecutorFor(final K k) {
        return new Executor(){

            @Override
            public void execute(Runnable runnable) {
                AsyncButOrdered.this.performAsyncButOrdered(k, runnable);
            }
        };
    }

    private class Handler
    implements Runnable {
        private final Queue<Runnable> keyQueue;
        private final K key;

        Handler(Queue<Runnable> queue, K k) {
            this.keyQueue = queue;
            this.key = k;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Runnable runnable = null;
                while ((runnable = this.keyQueue.poll()) != null) {
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        Handler handler = new Handler(this.keyQueue, this.key);
                        Map map = AsyncButOrdered.this.threadActiveMap;
                        synchronized (map) {
                            AsyncButOrdered.this.threadActiveMap.put(this.key, handler);
                        }
                        AsyncButOrdered.this.scheduleHandler(handler);
                        throw throwable;
                    }
                }
                Map map = AsyncButOrdered.this.threadActiveMap;
                synchronized (map) {
                    if (this.keyQueue.isEmpty()) {
                        AsyncButOrdered.this.threadActiveMap.remove(this.key);
                        break;
                    }
                }
            }
        }
    }
}

