/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ScheduledAction;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.util.Objects;

public abstract class Manager {
    final WeakReference<XMPPConnection> weakConnection;

    public Manager(XMPPConnection xMPPConnection) {
        Objects.requireNonNull(xMPPConnection, "XMPPConnection must not be null");
        this.weakConnection = new WeakReference<XMPPConnection>(xMPPConnection);
    }

    protected final XMPPConnection connection() {
        return (XMPPConnection)this.weakConnection.get();
    }

    protected final XMPPConnection getAuthenticatedConnectionOrThrow() {
        XMPPConnection xMPPConnection = this.connection();
        if (!xMPPConnection.isAuthenticated()) {
            throw new SmackException.NotLoggedInException();
        }
        return xMPPConnection;
    }

    protected static final ScheduledAction schedule(Runnable runnable, long l, TimeUnit timeUnit) {
        return Manager.schedule(runnable, l, timeUnit, ScheduledAction.Kind.NonBlocking);
    }

    protected static final ScheduledAction scheduleBlocking(Runnable runnable, long l, TimeUnit timeUnit) {
        return Manager.schedule(runnable, l, timeUnit, ScheduledAction.Kind.Blocking);
    }

    protected static final ScheduledAction schedule(Runnable runnable, long l, TimeUnit timeUnit, ScheduledAction.Kind kind) {
        return AbstractXMPPConnection.SMACK_REACTOR.schedule(runnable, l, timeUnit, kind);
    }
}

