/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Nonza;
import org.jivesoftware.smack.util.MultiMap;
import org.jivesoftware.smack.util.XmppElementUtil;

public class NonzaCallback {
    protected final AbstractXMPPConnection connection;
    protected final Map<QName, ClassAndConsumer<? extends Nonza>> filterAndListeners;

    private NonzaCallback(Builder builder) {
        this.connection = builder.connection;
        this.filterAndListeners = builder.filterAndListeners;
        this.install();
    }

    void onNonzaReceived(Nonza nonza) {
        QName qName = nonza.getQName();
        ClassAndConsumer<? extends Nonza> classAndConsumer = this.filterAndListeners.get(qName);
        ((ClassAndConsumer)classAndConsumer).accept(nonza);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        for (Map.Entry<QName, ClassAndConsumer<? extends Nonza>> entry : this.filterAndListeners.entrySet()) {
            QName qName = entry.getKey();
            MultiMap<QName, NonzaCallback> multiMap = this.connection.nonzaCallbacksMap;
            synchronized (multiMap) {
                this.connection.nonzaCallbacksMap.removeOne(qName, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void install() {
        if (this.filterAndListeners.isEmpty()) {
            return;
        }
        for (QName qName : this.filterAndListeners.keySet()) {
            MultiMap<QName, NonzaCallback> multiMap = this.connection.nonzaCallbacksMap;
            synchronized (multiMap) {
                this.connection.nonzaCallbacksMap.put(qName, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <SN extends Nonza, FN extends Nonza> SN sendAndWaitForResponse(Builder builder, Nonza nonza, Class<SN> clazz, Class<FN> clazz2) {
        Nonza nonza2;
        NonzaResponseCallback nonzaResponseCallback = new NonzaResponseCallback(clazz, clazz2, builder);
        try {
            nonzaResponseCallback.connection.sendNonza(nonza);
            nonza2 = nonzaResponseCallback.waitForResponse();
        }
        finally {
            nonzaResponseCallback.cancel();
        }
        return (SN)nonza2;
    }

    private static final class ClassAndConsumer<N extends Nonza> {
        private final Class<N> clazz;
        private final NonzaListener<N> consumer;

        private ClassAndConsumer(Class<N> clazz, NonzaListener<N> nonzaListener) {
            this.clazz = clazz;
            this.consumer = nonzaListener;
        }

        private void accept(Object object) {
            Nonza nonza = (Nonza)this.clazz.cast(object);
            this.consumer.accept(nonza);
        }
    }

    public static interface NonzaListener<N extends Nonza> {
        public void accept(N var1);
    }

    public static final class Builder {
        private final AbstractXMPPConnection connection;
        private Map<QName, ClassAndConsumer<? extends Nonza>> filterAndListeners = new HashMap<QName, ClassAndConsumer<? extends Nonza>>();

        Builder(AbstractXMPPConnection abstractXMPPConnection) {
            this.connection = abstractXMPPConnection;
        }

        public <N extends Nonza> Builder listenFor(Class<N> clazz, NonzaListener<N> nonzaListener) {
            QName qName = XmppElementUtil.getQNameFor(clazz);
            ClassAndConsumer classAndConsumer = new ClassAndConsumer(clazz, nonzaListener);
            this.filterAndListeners.put(qName, classAndConsumer);
            return this;
        }

        public NonzaCallback install() {
            return new NonzaCallback(this);
        }
    }

    private static final class NonzaResponseCallback<SN extends Nonza, FN extends Nonza>
    extends NonzaCallback {
        private SN successNonza;
        private FN failedNonza;

        private NonzaResponseCallback(Class<SN> clazz, Class<FN> clazz2, Builder builder) {
            super(builder);
            QName qName = XmppElementUtil.getQNameFor(clazz);
            QName qName2 = XmppElementUtil.getQNameFor(clazz2);
            NonzaListener nonzaListener = new NonzaListener<SN>(){

                @Override
                public void accept(SN SN) {
                    successNonza = SN;
                    this.notifyResponse();
                }
            };
            ClassAndConsumer classAndConsumer = new ClassAndConsumer(clazz, nonzaListener);
            NonzaListener nonzaListener2 = new NonzaListener<FN>(){

                @Override
                public void accept(FN FN) {
                    failedNonza = FN;
                    this.notifyResponse();
                }
            };
            ClassAndConsumer classAndConsumer2 = new ClassAndConsumer(clazz2, nonzaListener2);
            this.filterAndListeners.put(qName, classAndConsumer);
            this.filterAndListeners.put(qName2, classAndConsumer2);
            this.install();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyResponse() {
            NonzaResponseCallback nonzaResponseCallback = this;
            synchronized (nonzaResponseCallback) {
                this.notifyAll();
            }
        }

        private boolean hasReceivedSuccessOrFailedNonza() {
            return this.successNonza != null || this.failedNonza != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SN waitForResponse() {
            long l = System.currentTimeMillis() + this.connection.getReplyTimeout();
            NonzaResponseCallback nonzaResponseCallback = this;
            synchronized (nonzaResponseCallback) {
                long l2;
                while (!this.hasReceivedSuccessOrFailedNonza() && (l2 = System.currentTimeMillis()) < l) {
                    this.wait(l - l2);
                }
            }
            if (!this.hasReceivedSuccessOrFailedNonza()) {
                throw SmackException.NoResponseException.newWith((XMPPConnection)this.connection, "Nonza Listener");
            }
            if (this.failedNonza != null) {
                throw new XMPPException.FailedNonzaException((Nonza)this.failedNonza);
            }
            assert (this.successNonza != null);
            return this.successNonza;
        }
    }
}

