/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.ReconnectionListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.StreamError;
import org.jivesoftware.smack.util.Async;

public final class ReconnectionManager {
    private static final Logger LOGGER = Logger.getLogger(ReconnectionManager.class.getName());
    private static final Map<AbstractXMPPConnection, ReconnectionManager> INSTANCES = new WeakHashMap<AbstractXMPPConnection, ReconnectionManager>();
    private static boolean enabledPerDefault;
    private final Set<ReconnectionListener> reconnectionListeners = new CopyOnWriteArraySet<ReconnectionListener>();
    private final WeakReference<AbstractXMPPConnection> weakRefConnection;
    private final int randomBase = new Random().nextInt(13) + 2;
    private final Runnable reconnectionRunnable;
    private static int defaultFixedDelay;
    private static ReconnectionPolicy defaultReconnectionPolicy;
    private volatile int fixedDelay = defaultFixedDelay;
    private volatile ReconnectionPolicy reconnectionPolicy = defaultReconnectionPolicy;
    private boolean automaticReconnectEnabled = false;
    boolean done = false;
    private Thread reconnectionThread;
    private final ConnectionListener connectionListener = new ConnectionListener(){

        @Override
        public void connectionClosed() {
            ReconnectionManager.this.done = true;
        }

        @Override
        public void authenticated(XMPPConnection xMPPConnection, boolean bl) {
            ReconnectionManager.this.done = false;
        }

        @Override
        public void connectionClosedOnError(Exception exception) {
            XMPPException.StreamErrorException streamErrorException;
            StreamError streamError;
            ReconnectionManager.this.done = false;
            if (!ReconnectionManager.this.isAutomaticReconnectEnabled()) {
                return;
            }
            if (exception instanceof XMPPException.StreamErrorException && StreamError.Condition.conflict == (streamError = (streamErrorException = (XMPPException.StreamErrorException)exception).getStreamError()).getCondition()) {
                return;
            }
            ReconnectionManager.this.reconnect();
        }
    };

    public static synchronized ReconnectionManager getInstanceFor(AbstractXMPPConnection abstractXMPPConnection) {
        ReconnectionManager reconnectionManager = INSTANCES.get(abstractXMPPConnection);
        if (reconnectionManager == null) {
            reconnectionManager = new ReconnectionManager(abstractXMPPConnection);
            INSTANCES.put(abstractXMPPConnection, reconnectionManager);
        }
        return reconnectionManager;
    }

    public static void setEnabledPerDefault(boolean bl) {
        enabledPerDefault = bl;
    }

    public static boolean getEnabledPerDefault() {
        return enabledPerDefault;
    }

    public static void setDefaultFixedDelay(int n) {
        defaultFixedDelay = n;
        ReconnectionManager.setDefaultReconnectionPolicy(ReconnectionPolicy.FIXED_DELAY);
    }

    public static void setDefaultReconnectionPolicy(ReconnectionPolicy reconnectionPolicy) {
        defaultReconnectionPolicy = reconnectionPolicy;
    }

    public boolean addReconnectionListener(ReconnectionListener reconnectionListener) {
        return this.reconnectionListeners.add(reconnectionListener);
    }

    public boolean removeReconnectionListener(ReconnectionListener reconnectionListener) {
        return this.reconnectionListeners.remove(reconnectionListener);
    }

    public void setFixedDelay(int n) {
        this.fixedDelay = n;
        this.setReconnectionPolicy(ReconnectionPolicy.FIXED_DELAY);
    }

    public void setReconnectionPolicy(ReconnectionPolicy reconnectionPolicy) {
        this.reconnectionPolicy = reconnectionPolicy;
    }

    private ReconnectionManager(AbstractXMPPConnection abstractXMPPConnection) {
        this.weakRefConnection = new WeakReference<AbstractXMPPConnection>(abstractXMPPConnection);
        this.reconnectionRunnable = new Runnable(){
            private int attempts = 0;

            private int timeDelay() {
                int n;
                ++this.attempts;
                switch (ReconnectionManager.this.reconnectionPolicy) {
                    case FIXED_DELAY: {
                        n = ReconnectionManager.this.fixedDelay;
                        break;
                    }
                    case RANDOM_INCREASING_DELAY: {
                        if (this.attempts > 13) {
                            n = ReconnectionManager.this.randomBase * 6 * 5;
                            break;
                        }
                        if (this.attempts > 7) {
                            n = ReconnectionManager.this.randomBase * 6;
                            break;
                        }
                        n = ReconnectionManager.this.randomBase;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown reconnection policy " + (Object)((Object)ReconnectionManager.this.reconnectionPolicy)));
                    }
                }
                return n;
            }

            @Override
            public void run() {
                AbstractXMPPConnection abstractXMPPConnection = (AbstractXMPPConnection)ReconnectionManager.this.weakRefConnection.get();
                if (abstractXMPPConnection == null) {
                    return;
                }
                this.attempts = 0;
                while (ReconnectionManager.this.isReconnectionPossible(abstractXMPPConnection)) {
                    int n = this.timeDelay();
                    while (n > 0) {
                        if (!ReconnectionManager.this.isReconnectionPossible(abstractXMPPConnection)) {
                            return;
                        }
                        try {
                            Thread.sleep(1000L);
                            --n;
                            for (Object object : ReconnectionManager.this.reconnectionListeners) {
                                object.reconnectingIn(n);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            LOGGER.log(Level.FINE, "Reconnection Thread was interrupted, aborting reconnection mechanism", interruptedException);
                            return;
                        }
                    }
                    for (Object object : ReconnectionManager.this.reconnectionListeners) {
                        object.reconnectingIn(0);
                    }
                    if (!ReconnectionManager.this.isReconnectionPossible(abstractXMPPConnection)) {
                        return;
                    }
                    try {
                        try {
                            abstractXMPPConnection.connect();
                        }
                        catch (SmackException.AlreadyConnectedException alreadyConnectedException) {
                            LOGGER.log(Level.FINER, "Connection was already connected on reconnection attempt", alreadyConnectedException);
                        }
                        abstractXMPPConnection.login();
                    }
                    catch (SmackException.AlreadyLoggedInException alreadyLoggedInException) {
                        LOGGER.log(Level.FINER, "Reconnection not required, was already logged in", alreadyLoggedInException);
                    }
                    catch (IOException | SmackException | XMPPException exception) {
                        Object object;
                        object = ReconnectionManager.this.reconnectionListeners.iterator();
                        while (object.hasNext()) {
                            ReconnectionListener reconnectionListener = (ReconnectionListener)object.next();
                            reconnectionListener.reconnectionFailed(exception);
                        }
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        LOGGER.log(Level.FINE, "Reconnection Thread was interrupted, aborting reconnection mechanism", interruptedException);
                        return;
                    }
                    return;
                }
            }
        };
        if (ReconnectionManager.getEnabledPerDefault()) {
            this.enableAutomaticReconnection();
        }
    }

    public synchronized void enableAutomaticReconnection() {
        if (this.automaticReconnectEnabled) {
            return;
        }
        XMPPConnection xMPPConnection = (XMPPConnection)this.weakRefConnection.get();
        if (xMPPConnection == null) {
            throw new IllegalStateException("Connection instance no longer available");
        }
        xMPPConnection.addConnectionListener(this.connectionListener);
        this.automaticReconnectEnabled = true;
    }

    public synchronized void disableAutomaticReconnection() {
        if (!this.automaticReconnectEnabled) {
            return;
        }
        XMPPConnection xMPPConnection = (XMPPConnection)this.weakRefConnection.get();
        if (xMPPConnection == null) {
            throw new IllegalStateException("Connection instance no longer available");
        }
        xMPPConnection.removeConnectionListener(this.connectionListener);
        this.automaticReconnectEnabled = false;
    }

    public synchronized boolean isAutomaticReconnectEnabled() {
        return this.automaticReconnectEnabled;
    }

    private boolean isReconnectionPossible(XMPPConnection xMPPConnection) {
        return !this.done && !xMPPConnection.isConnected() && this.isAutomaticReconnectEnabled();
    }

    private synchronized void reconnect() {
        XMPPConnection xMPPConnection = (XMPPConnection)this.weakRefConnection.get();
        if (xMPPConnection == null) {
            LOGGER.fine("Connection is null, will not reconnect");
            return;
        }
        if (this.reconnectionThread != null && this.reconnectionThread.isAlive()) {
            return;
        }
        this.reconnectionThread = Async.go(this.reconnectionRunnable, "Smack Reconnection Manager (" + xMPPConnection.getConnectionCounter() + ')');
    }

    public synchronized void abortPossiblyRunningReconnection() {
        if (this.reconnectionThread == null) {
            return;
        }
        this.reconnectionThread.interrupt();
        this.reconnectionThread = null;
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(XMPPConnection xMPPConnection) {
                if (xMPPConnection instanceof AbstractXMPPConnection) {
                    ReconnectionManager.getInstanceFor((AbstractXMPPConnection)xMPPConnection);
                }
            }
        });
        enabledPerDefault = false;
        defaultFixedDelay = 15;
        defaultReconnectionPolicy = ReconnectionPolicy.RANDOM_INCREASING_DELAY;
    }

    public static enum ReconnectionPolicy {
        RANDOM_INCREASING_DELAY,
        FIXED_DELAY;

    }
}

