/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.ScheduledAction;

public class SmackReactor {
    private static final Logger LOGGER = Logger.getLogger(SmackReactor.class.getName());
    private static final int DEFAULT_REACTOR_THREAD_COUNT = 2;
    private static final int PENDING_SET_INTEREST_OPS_MAX_BATCH_SIZE = 1024;
    private static SmackReactor INSTANCE;
    private final Selector selector;
    private final String reactorName;
    private final List<Reactor> reactorThreads = Collections.synchronizedList(new ArrayList());
    private final DelayQueue<ScheduledAction> scheduledActions = new DelayQueue();
    private final Lock registrationLock = new ReentrantLock();
    private final Semaphore actionsSemaphore = new Semaphore(-1, false);
    private final Queue<SelectionKey> pendingSelectionKeys = new ConcurrentLinkedQueue<SelectionKey>();
    private final Queue<SetInterestOps> pendingSetInterestOps = new ConcurrentLinkedQueue<SetInterestOps>();

    static synchronized SmackReactor getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SmackReactor("DefaultReactor");
        }
        return INSTANCE;
    }

    SmackReactor(String string) {
        this.reactorName = string;
        try {
            this.selector = Selector.open();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        this.setReactorThreadCount(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectionKey registerWithSelector(SelectableChannel selectableChannel, int n, ChannelSelectedCallback channelSelectedCallback) {
        SelectionKeyAttachment selectionKeyAttachment = new SelectionKeyAttachment(channelSelectedCallback);
        this.registrationLock.lock();
        try {
            this.selector.wakeup();
            SelectionKey selectionKey = selectableChannel.register(this.selector, n, selectionKeyAttachment);
            return selectionKey;
        }
        finally {
            this.registrationLock.unlock();
        }
    }

    public void setInterestOps(SelectionKey selectionKey, int n) {
        SetInterestOps setInterestOps = new SetInterestOps(selectionKey, n);
        this.pendingSetInterestOps.add(setInterestOps);
        this.selector.wakeup();
    }

    ScheduledAction schedule(Runnable runnable, long l, TimeUnit timeUnit, ScheduledAction.Kind kind) {
        long l2 = System.currentTimeMillis() + timeUnit.toMillis(l);
        Date date = new Date(l2);
        ScheduledAction scheduledAction = new ScheduledAction(runnable, date, this, kind);
        this.scheduledActions.add(scheduledAction);
        this.selector.wakeup();
        return scheduledAction;
    }

    boolean cancel(ScheduledAction scheduledAction) {
        return this.scheduledActions.remove(scheduledAction);
    }

    private static void handleSelectedKeys(Collection<SelectionKey> collection) {
        for (SelectionKey selectionKey : collection) {
            SelectableChannel selectableChannel = selectionKey.channel();
            SelectionKeyAttachment selectionKeyAttachment = (SelectionKeyAttachment)selectionKey.attachment();
            ChannelSelectedCallback channelSelectedCallback = selectionKeyAttachment.channelSelectedCallback;
            channelSelectedCallback.onChannelSelected(selectableChannel, selectionKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReactorThreadCount(int n) {
        if (n < 2) {
            throw new IllegalArgumentException("Must have at least two reactor threads, but you requested " + n);
        }
        List<Reactor> list = this.reactorThreads;
        synchronized (list) {
            int n2 = n - this.reactorThreads.size();
            if (n2 > 0) {
                for (int j = 0; j < n2; ++j) {
                    Reactor reactor = new Reactor();
                    reactor.setDaemon(true);
                    reactor.setName("Smack " + this.reactorName + " Thread #" + j);
                    this.reactorThreads.add(reactor);
                    reactor.start();
                }
                this.actionsSemaphore.release(n2);
            } else {
                int n3;
                n2 -= n2;
                for (n3 = n2 - 1; n3 > 0; --n3) {
                    this.actionsSemaphore.acquireUninterruptibly();
                }
                for (n3 = n2 - 1; n3 > 0; --n3) {
                    Reactor reactor = this.reactorThreads.remove(n3);
                    reactor.requestShutdown();
                }
                this.selector.wakeup();
            }
        }
    }

    public static final class SelectionKeyAttachment {
        private final ChannelSelectedCallback channelSelectedCallback;
        private final AtomicBoolean reactorThreadRacing = new AtomicBoolean();

        private SelectionKeyAttachment(ChannelSelectedCallback channelSelectedCallback) {
            this.channelSelectedCallback = channelSelectedCallback;
        }

        private void setRacing() {
            this.reactorThreadRacing.lazySet(true);
        }

        public void resetReactorThreadRacing() {
            this.reactorThreadRacing.set(false);
        }

        public boolean isReactorThreadRacing() {
            return this.reactorThreadRacing.get();
        }
    }

    public static interface ChannelSelectedCallback {
        public void onChannelSelected(SelectableChannel var1, SelectionKey var2);
    }

    private class Reactor
    extends Thread {
        private volatile long shutdownRequestTimestamp = -1L;

        private Reactor() {
        }

        @Override
        public void run() {
            try {
                this.reactorLoop();
            }
            finally {
                if (this.shutdownRequestTimestamp > 0L) {
                    long l = System.currentTimeMillis() - this.shutdownRequestTimestamp;
                    LOGGER.info(this + " shut down after " + l + "ms");
                } else {
                    boolean bl = SmackReactor.this.reactorThreads.remove(this);
                    assert (bl);
                }
            }
        }

        private void reactorLoop() {
            while (this.shutdownRequestTimestamp < 0L) {
                this.handleScheduledActionsOrPerformSelect();
                this.handlePendingSelectionKeys();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleScheduledActionsOrPerformSelect() {
            ArrayList arrayList;
            SelectionKey selectionKey;
            Iterator iterator;
            ScheduledAction scheduledAction = null;
            boolean bl = SmackReactor.this.actionsSemaphore.tryAcquire();
            if (bl) {
                try {
                    scheduledAction = (ScheduledAction)SmackReactor.this.scheduledActions.poll();
                }
                finally {
                    SmackReactor.this.actionsSemaphore.release();
                }
            }
            if (scheduledAction != null) {
                scheduledAction.run();
                return;
            }
            int n = 0;
            Selector selector = SmackReactor.this.selector;
            synchronized (selector) {
                long l;
                ScheduledAction scheduledAction2 = (ScheduledAction)SmackReactor.this.scheduledActions.peek();
                if (scheduledAction2 == null) {
                    l = 0L;
                } else {
                    l = scheduledAction2.getTimeToDueMillis();
                    if (l <= 0L) {
                        return;
                    }
                }
                int n2 = 0;
                while ((iterator = (SetInterestOps)SmackReactor.this.pendingSetInterestOps.poll()) != null) {
                    this.setInterestOpsCancelledKeySafe(((SetInterestOps)((Object)iterator)).selectionKey, ((SetInterestOps)((Object)iterator)).interestOps);
                    if (n2++ < 1024) continue;
                    SmackReactor.this.selector.wakeup();
                    break;
                }
                SmackReactor.this.registrationLock.lock();
                SmackReactor.this.registrationLock.unlock();
                try {
                    n = SmackReactor.this.selector.select(l);
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.SEVERE, "IOException while using select()", iOException);
                    return;
                }
                if (n == 0) {
                    return;
                }
                iterator = SmackReactor.this.selector.selectedKeys();
                Iterator iterator2 = iterator.iterator();
                while (iterator2.hasNext()) {
                    selectionKey = (SelectionKey)iterator2.next();
                    SelectionKeyAttachment selectionKeyAttachment = (SelectionKeyAttachment)selectionKey.attachment();
                    selectionKeyAttachment.setRacing();
                }
                iterator2 = iterator.iterator();
                while (iterator2.hasNext()) {
                    selectionKey = (SelectionKey)iterator2.next();
                    this.setInterestOpsCancelledKeySafe(selectionKey, 0);
                }
                arrayList = new ArrayList(iterator.size());
                arrayList.addAll(iterator);
                iterator.clear();
            }
            int n3 = arrayList.size();
            int n4 = SmackReactor.this.reactorThreads.size();
            int n5 = n3 > n4 ? n3 / n4 : n3;
            Level level = Level.FINE;
            if (LOGGER.isLoggable(level)) {
                LOGGER.log(level, "New selected key count: " + n + ". Total selected key count " + n3 + ". My key count: " + n5 + ". Current reactor thread count: " + n4);
            }
            ArrayList<SelectionKey> arrayList2 = new ArrayList<SelectionKey>(n5);
            iterator = arrayList.iterator();
            for (int j = 0; j < n5; ++j) {
                selectionKey = (SelectionKey)iterator.next();
                arrayList2.add(selectionKey);
            }
            while (iterator.hasNext()) {
                SelectionKey selectionKey2 = (SelectionKey)iterator.next();
                SmackReactor.this.pendingSelectionKeys.add(selectionKey2);
            }
            if (n3 - n5 > 0) {
                SmackReactor.this.selector.wakeup();
            }
            SmackReactor.handleSelectedKeys(arrayList2);
        }

        private void handlePendingSelectionKeys() {
            SelectionKey selectionKey;
            int n = SmackReactor.this.pendingSelectionKeys.size();
            if (n == 0) {
                return;
            }
            int n2 = SmackReactor.this.reactorThreads.size();
            int n3 = n / n2;
            if (n3 == 0) {
                n3 = 1;
            }
            ArrayList<SelectionKey> arrayList = new ArrayList<SelectionKey>(n3);
            for (int j = 0; j < n3 && (selectionKey = (SelectionKey)SmackReactor.this.pendingSelectionKeys.poll()) != null; ++j) {
                arrayList.add(selectionKey);
            }
            if (!SmackReactor.this.pendingSelectionKeys.isEmpty()) {
                SmackReactor.this.selector.wakeup();
            }
            SmackReactor.handleSelectedKeys(arrayList);
        }

        private void setInterestOpsCancelledKeySafe(SelectionKey selectionKey, int n) {
            block2: {
                try {
                    selectionKey.interestOps(n);
                }
                catch (CancelledKeyException cancelledKeyException) {
                    Level level = Level.FINER;
                    if (!LOGGER.isLoggable(level)) break block2;
                    LOGGER.log(level, "Key '" + selectionKey + "' has been cancelled", cancelledKeyException);
                }
            }
        }

        void requestShutdown() {
            this.shutdownRequestTimestamp = System.currentTimeMillis();
        }
    }

    private static final class SetInterestOps {
        private final SelectionKey selectionKey;
        private final int interestOps;

        private SetInterestOps(SelectionKey selectionKey, int n) {
            this.selectionKey = selectionKey;
            this.interestOps = n;
        }
    }
}

