/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.compression.zlib;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.XmppInputOutputFilter;
import org.jivesoftware.smack.compression.XMPPInputOutputStream;
import org.jivesoftware.smack.compression.XmppCompressionFactory;

public final class ZlibXmppCompressionFactory
extends XmppCompressionFactory {
    public static final ZlibXmppCompressionFactory INSTANCE = new ZlibXmppCompressionFactory();

    private ZlibXmppCompressionFactory() {
        super("zlib", 100);
    }

    @Override
    public XmppInputOutputFilter fabricate(ConnectionConfiguration connectionConfiguration) {
        return new ZlibXmppInputOutputFilter();
    }

    public static final class Stats {
        public final long compressorInBytes;
        public final long compressorOutBytes;
        public final double compressionRatio;
        public final long decompressorInBytes;
        public final long decompressorOutBytes;
        public final double decompressionRatio;
        public final int maxOutputOutput;
        public final int maxInputOutput;
        public final int maxBytesWrittenAfterFullFlush;
        private transient String toStringCache;

        private Stats(ZlibXmppInputOutputFilter zlibXmppInputOutputFilter) {
            this.compressorOutBytes = zlibXmppInputOutputFilter.compressorOutBytes;
            this.compressorInBytes = zlibXmppInputOutputFilter.compressorInBytes;
            this.compressionRatio = (double)this.compressorOutBytes / (double)this.compressorInBytes;
            this.decompressorOutBytes = zlibXmppInputOutputFilter.decompressorOutBytes;
            this.decompressorInBytes = zlibXmppInputOutputFilter.decompressorInBytes;
            this.decompressionRatio = (double)this.decompressorInBytes / (double)this.decompressorOutBytes;
            this.maxOutputOutput = zlibXmppInputOutputFilter.maxOutputOutput;
            this.maxInputOutput = zlibXmppInputOutputFilter.maxInputOutput;
            this.maxBytesWrittenAfterFullFlush = zlibXmppInputOutputFilter.maxBytesWrittenAfterFullFlush;
        }

        public String toString() {
            if (this.toStringCache != null) {
                return this.toStringCache;
            }
            this.toStringCache = "compressor-in-bytes: " + this.compressorInBytes + '\n' + "compressor-out-bytes: " + this.compressorOutBytes + '\n' + "compression-ratio: " + this.compressionRatio + '\n' + "decompressor-in-bytes: " + this.decompressorInBytes + '\n' + "decompressor-out-bytes: " + this.decompressorOutBytes + '\n' + "decompression-ratio: " + this.decompressionRatio + '\n' + "max-output-output: " + this.maxOutputOutput + '\n' + "max-input-output: " + this.maxInputOutput + '\n' + "max-bytes-written-after-full-flush: " + this.maxBytesWrittenAfterFullFlush + '\n';
            return this.toStringCache;
        }
    }

    private static final class ZlibXmppInputOutputFilter
    implements XmppInputOutputFilter {
        private static final int MINIMUM_OUTPUT_BUFFER_INITIAL_SIZE = 4;
        private static final int MINIMUM_OUTPUT_BUFFER_INCREASE = 480;
        private final Deflater compressor;
        private final Inflater decompressor = new Inflater();
        private long compressorInBytes;
        private long compressorOutBytes;
        private long decompressorInBytes;
        private long decompressorOutBytes;
        private int maxOutputOutput = -1;
        private int maxInputOutput = -1;
        private int maxBytesWrittenAfterFullFlush = -1;
        private ByteBuffer outputBuffer;

        private ZlibXmppInputOutputFilter() {
            this(-1);
        }

        private ZlibXmppInputOutputFilter(int n) {
            this.compressor = new Deflater(n);
        }

        @Override
        public XmppInputOutputFilter.OutputResult output(ByteBuffer byteBuffer, boolean bl, boolean bl2, boolean bl3) {
            int n;
            int n2;
            byte[] byArray;
            int n3;
            if (bl2 && XMPPInputOutputStream.getFlushMethod() == XMPPInputOutputStream.FlushMethod.FULL_FLUSH) {
                this.outputBuffer = ByteBuffer.allocate(256);
                n3 = this.deflate(3);
                this.maxBytesWrittenAfterFullFlush = Math.max(n3, this.maxBytesWrittenAfterFullFlush);
                this.compressorOutBytes += (long)n3;
            }
            if (byteBuffer == null && this.outputBuffer == null) {
                return XmppInputOutputFilter.OutputResult.NO_OUTPUT;
            }
            n3 = byteBuffer.remaining();
            if (this.outputBuffer == null) {
                int n4 = n3 < 4 ? 4 : n3;
                this.outputBuffer = ByteBuffer.allocate(n4);
            }
            assert (this.compressor.needsInput());
            if (byteBuffer.hasArray()) {
                byArray = byteBuffer.array();
                n2 = byteBuffer.arrayOffset();
                n = byteBuffer.remaining();
            } else {
                byArray = new byte[byteBuffer.remaining()];
                n2 = 0;
                n = byArray.length;
                byteBuffer.get(byArray);
            }
            this.compressorInBytes += (long)n;
            this.compressor.setInput(byArray, n2, n);
            int n5 = bl3 ? 0 : 2;
            int n6 = this.deflate(n5);
            this.maxOutputOutput = Math.max(this.outputBuffer.position(), this.maxOutputOutput);
            this.compressorOutBytes += (long)n6;
            XmppInputOutputFilter.OutputResult outputResult = new XmppInputOutputFilter.OutputResult(this.outputBuffer);
            this.outputBuffer = null;
            return outputResult;
        }

        private int deflate(int n) {
            int n2 = 0;
            while (true) {
                int n3 = this.outputBuffer.position();
                byte[] byArray = this.outputBuffer.array();
                int n4 = this.outputBuffer.limit() - n3;
                int n5 = this.compressor.deflate(byArray, n3, n4, n);
                int n6 = n3 + n5;
                this.outputBuffer.position(n6);
                n2 += n5;
                if (this.compressor.needsInput() && this.outputBuffer.hasRemaining()) break;
                int n7 = this.outputBuffer.capacity() * 2;
                if (n7 < 480) {
                    n7 = 480;
                }
                ByteBuffer byteBuffer = ByteBuffer.allocate(n7);
                this.outputBuffer.flip();
                byteBuffer.put(this.outputBuffer);
                this.outputBuffer = byteBuffer;
            }
            return n2;
        }

        @Override
        public ByteBuffer input(ByteBuffer byteBuffer) {
            int n;
            int n2;
            int n3;
            byte[] byArray;
            int n4 = byteBuffer.remaining();
            if (byteBuffer.hasArray()) {
                byArray = byteBuffer.array();
                n3 = byteBuffer.arrayOffset();
                n2 = byteBuffer.remaining();
            } else {
                byArray = new byte[n4];
                byteBuffer.get(byArray);
                n3 = 0;
                n2 = byArray.length;
            }
            this.decompressorInBytes += (long)n2;
            this.decompressor.setInput(byArray, n3, n2);
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(2 * n2);
            while (true) {
                byte[] byArray2 = byteBuffer2.array();
                int n5 = byteBuffer2.position();
                int n6 = byteBuffer2.limit() - n5;
                try {
                    n = this.decompressor.inflate(byArray2, n5, n6);
                }
                catch (DataFormatException dataFormatException) {
                    throw new IOException(dataFormatException);
                }
                byteBuffer2.position(n5 + n);
                this.decompressorOutBytes += (long)n;
                if (this.decompressor.needsInput()) break;
                int n7 = byteBuffer2.capacity() * 2;
                ByteBuffer byteBuffer3 = ByteBuffer.allocate(n7);
                byteBuffer2.flip();
                byteBuffer3.put(byteBuffer2);
                byteBuffer2 = byteBuffer3;
            }
            if (n == 0) {
                return null;
            }
            this.maxInputOutput = Math.max(byteBuffer2.position(), this.maxInputOutput);
            return byteBuffer2;
        }

        @Override
        public Stats getStats() {
            return new Stats(this);
        }

        @Override
        public String getFilterName() {
            return "Compression (zlib)";
        }
    }
}

